/******************************************************************************

            Copyright 1988 by Sony Corporation, Tokyo, Japan.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Sony not be used in 
advertising or publicity pertaining to distribution of the software 
without specific, written prior permission.  

SONY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
SONY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/
/*
 * $Header: SScreenP.h,v 1.1 88/08/20 09:06:54 michael Exp $ Sony Corporation
 *
 * $Log:	SScreenP.h,v $
 * Revision 1.1  88/08/20  09:06:54  michael
 * Initial revision
 * 
 */

/************************************************************************
 *									* 
 *	SScreenPrivate.h - Private definitions for Screen widget	*
 *									*
 *						Sony Corporation	*
 *						Wed Aug 10 1988		*
 *									*
 ************************************************************************/
#ifndef _XtSScreenPrivate_h
#define _XtSScreenPrivate_h

/*==============================================================
	New fields for the Screen widget class record
================================================================*/
typedef struct {
    int mumble;   /* No new procedures */
} SScreenClassPart;

/*==============================================================
	Full class record declaration
================================================================*/
typedef struct _ScreenClassRec {
    CoreClassPart	core_class;
    CompositeClassPart  composite_class;
    SScreenClassPart	screen_class;
} SScreenClassRec;

extern SScreenClassRec sScreenClassRec;

/*==============================================================
	New fields for the Screen widget record
================================================================*/
typedef struct {
    int mumble;   /* No new procedures */
} SScreenPart;

/*==============================================================
 	Full instance record declaration
================================================================*/
typedef struct _SScreenRec {
    CorePart	    core;
    CompositePart   composite;
    SScreenPart      screen;
} SScreenRec;

#endif _XtSScreenPrivate_h
/* DON'T ADD STUFF AFTER THIS #endif */

