#ifndef lint
static char rcsid[] = "$Header: SScreen.c,v 1.1 88/08/20 09:06:31 michael Exp $ Sony Corporation";
#endif lint
/*
 * $Log:	SScreen.c,v $
 * Revision 1.1  88/08/20  09:06:31  michael
 * Initial revision
 * 
 */

/******************************************************************************

            Copyright 1988 by Sony Corporation, Tokyo, Japan.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Sony not be used in 
advertising or publicity pertaining to distribution of the software 
without specific, written prior permission.  

SONY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
SONY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/

/**************************************************************** 
 *								*
 * 	SScreen.c - Screen composite widget			*
 * 								*
 * 				Sony Corporation		*
 *				Wed Aug 10 1988			*
 *								*
 ****************************************************************/
#include	<X11/IntrinsicP.h>
#include	<X11/StringDefs.h>
#include	<X11/Misc.h>
#include	<X11/SScreen.h>
#include	<X11/SScreenP.h>

static void	ClassInitialize();
static void	Initialize();
static void	Realize();
static void	Resize();
static Boolean	SetValues();
static XtGeometryResult GeometryManager();

SScreenClassRec sScreenClassRec = {
  { /* core_class fields      */
    /* superclass         */    (WidgetClass) &compositeClassRec,
    /* class_name         */    "SScreen",
    /* widget_size        */    sizeof(SScreenRec),
    /* class_initialize   */    NULL,
    /* class_part_init    */    NULL,
    /* class_inited       */	FALSE,
    /* initialize         */    Initialize,
    /* initialize_hook    */    NULL,
    /* realize            */    Realize,
    /* actions            */    NULL,
    /* num_actions	  */	0,
    /* resources          */    NULL,
    /* num_resources      */    0,
    /* xrm_class          */    NULLQUARK,
    /* compress_motion	  */	TRUE,
    /* compress_exposure  */	TRUE,
    /* compress_enterleave*/    TRUE,
    /* visible_interest   */    FALSE,
    /* destroy            */    NULL,
    /* resize             */    Resize,
    /* expose             */    NULL,
    /* set_values         */    SetValues,
    /* set_values_hook    */    NULL,
    /* set_values_almost  */    XtInheritSetValuesAlmost,
    /* get_values_hook    */    NULL,
    /* accept_focus       */    NULL,
    /* version            */    XtVersion,
    /* callback_private   */    NULL,
    /* tm_table           */    NULL,
    /* query_geometry     */    NULL,
  },{ /* composite_class fields */
    /* geometry_manager   */    GeometryManager,
    /* change_managed     */    XtInheritChangeManaged,
    /* insert_child	  */	XtInheritInsertChild,	/* Inherit from superclass */
    /* delete_child	  */	XtInheritDeleteChild,	/* Inherit from superclass */
    /* move_focus_to_next */    NULL,
    /* move_focus_to_prev */    NULL
  },{
    /* mumble		  */	0	/* Make C compiler happy   */
  }
};

WidgetClass sScreenWidgetClass = (WidgetClass)&sScreenClassRec;


/****************************************************************
 *								*
 *	Private Routines					*
 *								*
 ****************************************************************/

/*===============================================================
	Class initialize
=================================================================*/
static void ClassInitialize()
{

}


/*===============================================================
	Resize
=================================================================*/
static void Resize(sw)
    SScreenWidget	sw;
{

} /* Resize */


/*===============================================================
	Initialize
=================================================================*/
static void Initialize(request, new, args, num_args)
    SScreenWidget request, new;
    ArgList args;
    Cardinal num_args;
{

} /* Initialize */


/*===============================================================
	Realize
=================================================================*/
static void Realize(w, valueMask, attributes)
    register Widget w;
    Mask *valueMask;
    XSetWindowAttributes *attributes;
{
    attributes->bit_gravity = NorthWestGravity;
    *valueMask |= CWBitGravity;
    
    w->core.window =
	XCreateWindow(XtDisplay(w), XtWindow(w->core.parent),
	w->core.x, w->core.y, w->core.width, w->core.height,
	w->core.border_width, w->core.depth,
	InputOutput, (Visual *)CopyFromParent,
	*valueMask, attributes);
} /* Realize */


/*===============================================================
	Set Values
=================================================================*/
static Boolean SetValues (current, request, new, last)
    SScreenWidget current, request, new;
    Boolean last;
{
    return (FALSE);
}


/*===============================================================
	Geometry Manager
=================================================================*/
static XtGeometryResult GeometryManager(w, req, reply)
Widget w;
XtWidgetGeometry *req,*reply;
{
    if (req->request_mode & CWX)
	w->core.x = req->x;
    if (req->request_mode & CWY)
	w->core.y = req->y;
    if (req->request_mode & CWWidth)
	w->core.width = req->width;
    if (req->request_mode & CWHeight)
	w->core.height = req->height;
    if (req->request_mode & CWBorderWidth)
	w->core.border_width = req->border_width;
    return XtGeometryYes;
}
