#include <X11/copyright.h>

/*
 * $Header: SKanjiTextP.h,v 1.1 88/08/20 09:06:49 michael Exp $ Sony Corporation
 *
 * $Log:	SKanjiTextP.h,v $
 * Revision 1.1  88/08/20  09:06:49  michael
 * Initial revision
 * 
 */
/***********************************************************
 *                                                         *
 *	Copyright (c) 1988 Sony Corp.                      *
 *                                                         *
 *    Original: AsciiTextP.h by DEC, M.I.T.                *
 *    Modified: by Sony Corp.                              *
 *                                                         *
 ***********************************************************/

/******************************************************************************

            Copyright 1988 by Sony Corporation, Tokyo, Japan.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Sony not be used in 
advertising or publicity pertaining to distribution of the software 
without specific, written prior permission.  

SONY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
SONY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/

/***********************************************************
Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

#ifndef _SKanjiTextP_h
#define _SKanjiTextP_h

#include "SKanjiText.h"
#include "STextP.h"	/* KanjiText is a subclass of Text */

extern XtActionsRec sTextActionsTable[];
extern Cardinal sTextActionsTableCount;

typedef struct {int empty;} SKanjiStringClassPart;

typedef struct _SKanjiStringClassRec {
    CoreClassPart	core_class;
    SimpleClassPart	simple_class;
    STextClassPart	text_class;
    SKanjiStringClassPart kanji_string_class;
} SKanjiStringClassRec;

extern SKanjiStringClassRec sKanjiStringClassRec;

typedef struct {
    String	string;		/* string for which to create a source */
#ifdef KANJI
    Boolean	kanji;		/* TRUE:Kanji  FALSE:Ascii */
#endif KANJI
} SKanjiStringPart;

typedef struct _SKanjiStringRec {
    CorePart		core;
    SimplePart		simple;
    STextPart		text;
    SKanjiStringPart	kanji_string;
} SKanjiStringRec;

typedef struct {int empty;} SKanjiDiskClassPart;

typedef struct _SKanjiDiskClassRec {
    CoreClassPart	core_class;
    SimpleClassPart	simple_class;
    STextClassPart	text_class;
    SKanjiDiskClassPart	kanji_disk_class;
} SKanjiDiskClassRec;

extern SKanjiDiskClassRec sKanjiDiskClassRec;

typedef struct {
    String	file_name;	/* file for which to create a source */
#ifdef KANJI
    Boolean	kanji;		/* TRUE:Kanji  FALSE:Ascii */
#endif KANJI
} SKanjiDiskPart;

typedef struct _SKanjiDiskRec {
    CorePart		core;
    SimplePart		simple;
    STextPart		text;
    SKanjiDiskPart	kanji_disk;
} SKanjiDiskRec;

#endif  _SKanjiTextP_h
