#ifndef lint
static char rcsid[] = "$Header: SImage.c,v 1.1 88/08/20 09:06:26 michael Exp $ Sony Corporation";
#endif lint
/*
 * $Log:	SImage.c,v $
 * Revision 1.1  88/08/20  09:06:26  michael
 * Initial revision
 * 
 */

/********************************************************
*							*
*	Sony image Widget				*
*							*
*	Copyright (C) 1988 by Sony			*
*	Written by M.Abe				*
*							*
********************************************************/

#define XtStrlen(s)             ((s) ? strlen(s) : 0)

/********************************************************
*							*
*	Include definition				*
*							*
********************************************************/

#include <stdio.h>
#include <ctype.h>

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xutil.h>
#include <X11/Misc.h>

#include <X11/SImage.h>
#include <X11/SImageP.h>

/********************************************************
*							*
*	Private procedure definitions			*
*							*
********************************************************/

static	void	ClassInitialize();
static	void	Initialize();
static	void	Realize();
static	void	Resize();
static	void	Exposure();
static	Boolean	SetValues();
static	void	Destroy();
static	void	Redisplay();
static	XtGeometryResult	PreferredSize();

static	void	Set();
static	void	Unset();
static	void	Drag();
static	void	Notify();
static	void	Install();
static	void	Uninstall();

/********************************************************
*							*
*	Default Translation				*
*							*
********************************************************/

static char defaultTranslations[] =
	"<Btn1Down>: set() \n\
	 <Btn1Motion>: drag() \n\
	 <Btn1Up>: notify() unset() \n\
	 <EnterWindow>: install() \n\
	 <LeaveWindow>: uninstall()";

/********************************************************
*							*
*	Full class record constant			*
*							*
********************************************************/

static XtResource resources[] = { 
    {XtNvisual, XtCVisual, XtRPointer, sizeof(Visual *),
	XtOffset(SImageWidget ,simage.visual),
	XtRPointer, (caddr_t)NULL},
    {XtNcolormap, XtCColormap, XtRInt, sizeof(Colormap),
	XtOffset(SImageWidget ,core.colormap),
	XtRInt, 0},
    {XtNimage, XtCImage, XtRPointer, sizeof(XImage *),
	XtOffset(SImageWidget ,simage.image),
	XtRPointer, (caddr_t)NULL},
    {XtNcallback, XtCCallback, XtRCallback, sizeof(caddr_t),
	XtOffset(SImageWidget, simage.callbacks), XtRCallback,
	(caddr_t)NULL},
};  

/********************************************************
*							*
*	SImage Actionsi					*
*							*
********************************************************/

static XtActionsRec actionsList[] = {
	{"set",		Set},
	{"unset",	Unset},
	{"drag",	Drag},
	{"notify",	Notify},
	{"install",	Install},
	{"uninstall",	Uninstall},
};

SImageClassRec sImageClassRec = {
  {
    (WidgetClass) &widgetClassRec,	/* superclass		*/
    "SImage",				/* class_name		*/
    sizeof(SImageRec),			/* size			*/
    ClassInitialize,                    /* class initialize  	*/
    NULL,				/* class_part_init	*/
    FALSE,                              /* class_inited      	*/
    Initialize,                         /* initialize		*/
    NULL,				/* initialize_hook	*/
    Realize,                            /* realize		*/
    actionsList,                        /* actions		*/
    XtNumber(actionsList),		/* num_actions		*/
    resources,                          /* resources	        */
    XtNumber(resources),                /* resource_count	*/
    NULLQUARK,                          /* xrm_class	        */
    TRUE,
    TRUE,
    TRUE,				/* compress enterleave	*/
    FALSE,                              /* visible_interest	*/
    Destroy,                            /* destroy		*/
    Resize,				/* resize		*/
    Exposure,				/* expose		*/
    SetValues,                          /* set_values		*/
    NULL,				/* set_values_hook	*/
    XtInheritSetValuesAlmost,		/* set_values_almost	*/
    NULL,				/* get_value_hook	*/
    NULL,                               /* accept_focus		*/
    XtVersion,				/* version              */
    NULL,				/* callback_private     */
    defaultTranslations,		/* tm_table             */
    PreferredSize,			/* query_geometry       */
  },
  {	/* simage field */
    NULL,				/* dummy		*/
  }
};

  /* for public consumption */
WidgetClass sImageWidgetClass = (WidgetClass) &sImageClassRec;

/********************************************************
*							*
*	Private Procedures				*
*							*
********************************************************/

/********************************************************
*							*
*	Class Initialize				*
*							*
********************************************************/

static void ClassInitialize(class)
WidgetClass class;
{
    register SImageWidgetClass c = (SImageWidgetClass)class;
} /* ClassInitialize */

/********************************************************
*							*
*	Query geometry					*
*							*
********************************************************/

static XtGeometryResult PreferredSize(widget, constraint, preferred)
Widget widget;
XtWidgetGeometry *constraint, *preferred;
{
	SImageWidget iw = (SImageWidget)widget;

	preferred->request_mode = CWWidth | CWHeight;
	preferred->width = iw->simage.preferred_width;
	preferred->height = iw->simage.preferred_height;
	return(XtGeometryAlmost);
}

/********************************************************
*							*
*	Initialize					*
*							*
********************************************************/

static void GetnormalGC(iw)
SImageWidget iw;
{
    XGCValues	values;
    Display *dpy;
    int screen;

    dpy = XtDisplay(iw);
    screen = DefaultScreen(dpy);

    values.foreground	= (unsigned long)BlackPixel(dpy, screen);
    values.background	= (unsigned long)WhitePixel(dpy, screen);

    iw->simage.gc = XtGetGC(
	(Widget)iw,
	(unsigned) GCForeground | GCBackground,
	&values);
}

static void Initialize(request, new, args, num_args)
Widget request, new;
ArgList args;
Cardinal num_args;
{
    SImageWidget iw = (SImageWidget)new;
    SImageWidget req = (SImageWidget)request;

    GetnormalGC(iw);

    iw->simage.preferred_width = iw->simage.image->width;
    iw->simage.preferred_height = iw->simage.image->height;
} 

/********************************************************
*							*
*	Realize						*
*							*
********************************************************/

static void Realize(w, valueMask, attributes) 
register Widget w;
Mask *valueMask;
XSetWindowAttributes *attributes;
{
    SImageWidget iw = (SImageWidget)w;

    XtCreateWindow( w, (unsigned int)InputOutput,
		(Visual *)iw->simage.visual, *valueMask, attributes );

} /* Realize */

/********************************************************
*							*
*	Destroy						*
*							*
********************************************************/

static void Destroy(w)
Widget w;
{
	/* must free GCs and pixmaps */
}

/********************************************************
*							*
*	Resize						*
*							*
********************************************************/

static void Resize(w)
Widget	w;
{
     SImageWidget iw = (SImageWidget)w;
}

/********************************************************
*							*
*	Redisplay					*
*							*
*********************************************************/

static void Exposure(w, event)
Widget w;
XEvent *event;
{
    SImageWidget iw = (SImageWidget) w;
    XExposeEvent *expose = (XExposeEvent *)event;

    if (expose->x < iw->simage.image->width &&
	expose->y < iw->simage.image->height) {
	    if ((iw->simage.image->width - expose->x) < expose->width)
		expose->width = iw->simage.image->width - expose->x;
	    if ((iw->simage.image->height - expose->y) < expose->height)
		expose->height = iw->simage.image->height - expose->y;
	    XPutImage(XtDisplay(w), XtWindow(w), iw->simage.gc,
		iw->simage.image, expose->x, expose->y,
		expose->x, expose->y, expose->width, expose->height);
    }
}

/********************************************************
*							*
*	Set Value					*
*							*
*********************************************************/

/*
	if (new != req) {	for supreclass resource only
		if (new != cur) {
			superclass set created value internally
		} else {
			superclass just ignore the req
		}
	} else {
		if (new != cur) {
			requested value is set
		} else {
			no request or
			requested value is the same as current value
		}
	}
*/

static Boolean SetValues (current, request, new, last)
Widget current, request, new;
Boolean last;
{
    SImageWidget cur = (SImageWidget) current;
    SImageWidget req = (SImageWidget) request;
    SImageWidget iw = (SImageWidget) new;

    if (cur->simage.image != iw->simage.image) {
	return(TRUE);
    }
    return(FALSE);
}

/********************************************************
*							*
*	Action procedure				*
*							*
********************************************************/

#define	memcpy(A, B, C) bcopy(B, A, C)

/*
char *memcpy(dest, src, len)
char *dest, *src;
int len;
{
	register i;
	register char *p = src;
	register char *q = dest;

	for (i = len; i > 0; i--)
		*q++ = *p++;
	return(dest);
}
*/

unsigned char *MakeScrapDataFormat(iw, image, num_bytes)
SImageWidget iw;
XImage *image;
int *num_bytes;
{
    unsigned char *bytes, *p;
    int length;

    length = image->bytes_per_line * image->height;
    if (image->format = XYPixmap)
	length *= image->depth;
    length += 102;

    bytes = (unsigned char *)malloc(length + 12);
    p = bytes;

    strncpy(p, "XWD     ", 8);			p += 8;
    *(int *)p = length;				p += 4;

    *(short *)p = 0;				p += 2;
    *(int *)p = 100;				p += 4;
    *(int *)p = 7;				p += 4;
    *(int *)p = image->format;			p += 4;
    *(int *)p = image->depth;			p += 4;
    *(int *)p = image->width;			p += 4;
    *(int *)p = image->height;			p += 4;
    *(int *)p = image->xoffset;			p += 4;
    *(int *)p = image->byte_order;		p += 4;
    *(int *)p = image->bitmap_unit;		p += 4;
    *(int *)p = image->bitmap_bit_order;	p += 4;
    *(int *)p = image->bitmap_pad;		p += 4;
    *(int *)p = image->bits_per_pixel;		p += 4;
    *(int *)p = image->bytes_per_line;		p += 4;
    *(int *)p = iw->simage.visual->class;	p += 4;
    *(int *)p = image->red_mask;		p += 4;
    *(int *)p = image->green_mask;		p += 4;
    *(int *)p = image->blue_mask;		p += 4;

	/* bits_per_rgb */
    *(int *)p = 1;				p += 4;
	/* colormap size */
    *(int *)p = 0;				p += 4;
	/* ncolors */
    *(int *)p = 0;				p += 4;

    *(int *)p = image->width;			p += 4;
    *(int *)p = image->height;			p += 4;

	/* frame x posision */
    *(int *)p = 0;				p += 4;
	/* frame y posision */
    *(int *)p = 0;				p += 4;
	/* frame border_width */
    *(int *)p = 0;				p += 4;

    memcpy(p, image->data, length - 102);	/* BUG */

    *num_bytes = length + 12;
    return(bytes);
}

static DrawRect(iw)
SImageWidget iw;
{
	XGCValues       values;
	GC gc;

	values.function = GXinvert;
	values.subwindow_mode = IncludeInferiors;
	gc = XtGetGC(iw, GCFunction|GCSubwindowMode, &values);

	XDrawRectangle(XtDisplay(iw), XtWindow(iw), gc,
		iw->simage.rect.x,
		iw->simage.rect.y,
		iw->simage.rect.width,
		iw->simage.rect.height);
		XtDestroyGC(gc);
}

static void Set(w, event, param, num_param)
Widget w;
XEvent *event;
char **param;
unsigned long *num_param;
{
	SImageWidget iw = (SImageWidget)w;

	iw->simage.activated = TRUE;

	iw->simage.offset_x = event->xbutton.x;
	iw->simage.offset_y = event->xbutton.y;

	iw->simage.rect.x = event->xbutton.x;
	iw->simage.rect.y = event->xbutton.y;
	iw->simage.rect.width = 0;
	iw->simage.rect.height = 0;
	DrawRect(iw);
}

static void Unset(w, event, param, num_param)
Widget w;
XEvent *event;
char **param;
unsigned long *num_param;
{
	SImageWidget iw = (SImageWidget)w;
	XImage *subimage;
	unsigned char *bytes;
	int num_bytes;

	if (iw->simage.activated) {
		DrawRect(iw);
		iw->simage.activated = FALSE;

		if (iw->simage.rect.width < 0) {
		    iw->simage.rect.x += iw->simage.rect.width;
		    iw->simage.rect.width *= -1;
		}
		if (iw->simage.rect.height < 0) {
		    iw->simage.rect.y += iw->simage.rect.height;
		    iw->simage.rect.height *= -1;
		}
		/*
		 *	XSubImage is very slow
		 */
		subimage =  XSubImage(iw->simage.image,
				iw->simage.rect.x,
				iw->simage.rect.y,
				iw->simage.rect.width,
				iw->simage.rect.height);

		bytes = MakeScrapDataFormat(iw, subimage, &num_bytes);
		XStoreBuffer(XtDisplay(iw), bytes, num_bytes, 2);
		XtFree(bytes);
	}
}

static void Drag(w, event, param, num_param)
Widget w;
XEvent *event;
char **param;
unsigned long *num_param;
{
	SImageWidget iw = (SImageWidget)w;

	if (iw->simage.activated) {
	    DrawRect(iw);
	    iw->simage.rect.width =
		event->xbutton.x - iw->simage.offset_x;
	    iw->simage.rect.height =
		event->xbutton.y - iw->simage.offset_y;
	    DrawRect(iw);
	}
}

static void Notify(w, event, param, num_param)
Widget w;
XEvent *event;
char **param;
unsigned long *num_param;
{
	SImageWidget iw = (SImageWidget)w;

	XtCallCallbacks(iw, XtNcallback, &iw->simage.rect);
}

static void Install(w, event, param, num_param)
Widget w;
XEvent *event;
char **param;
unsigned long *num_param;
{
	SImageWidget iw = (SImageWidget)w;

	XInstallColormap(XtDisplay(iw), iw->core.colormap);
}

static void Uninstall(w, event, param, num_param)
Widget w;
XEvent *event;
char **param;
unsigned long *num_param;
{
	SImageWidget iw = (SImageWidget)w;

	XUninstallColormap(XtDisplay(iw), iw->core.colormap);
}
