#ifndef lint
static char rcsid[] = "$Header: SDiskSrc.c,v 1.1 88/08/20 09:06:24 michael Exp $ Sony Corporation";
#endif lint
/*
 * $Log:	SDiskSrc.c,v $
 * Revision 1.1  88/08/20  09:06:24  michael
 * Initial revision
 * 
 */

/***********************************************************
 *                                                         *
 *	Copyright (c) 1988 Sony Corp.                      *
 *                                                         *
 *    Original: DiskSrc.c by DEC, M.I.T.                   *
 *    Modified: Kanji support by Sony Corp.                *
 *                                                         *
 ***********************************************************/

/******************************************************************************

            Copyright 1988 by Sony Corporation, Tokyo, Japan.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Sony not be used in 
advertising or publicity pertaining to distribution of the software 
without specific, written prior permission.  

SONY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
SONY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/

/***********************************************************
Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/* File: SDiskSource.c */
/* Documentation for source specfic routine semantics may be found in the
 * STextPrivate.h file.
 */

#include <stdio.h>
#ifdef KANJI
#include <ctype.h>
#include <jstrings.h>
#endif KANJI
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/STextP.h>   /** included in all text subwindow files **/

#define TMPSIZ 32		/* bytes to allocate for tmpnam */

extern char *tmpnam();
void bcopy();

/** private DiskSource definitions **/

typedef struct _DiskSourceData {
	/* resources */
    char       *fileName;
	/* private data */
    Boolean	is_tempfile;
    FILE *file;		
    XtTextPosition position, 	/* file position of first char in buffer */
 		   length; 	/* length of file */
    char *buffer;		/* piece of file in memory */
    int charsInBuffer;		/* number of bytes used in memory */
    int lastLine;
    int *src_lt;
} DiskSourceData, *DiskSourcePtr;

#define bufSize 1000

static char Look();

#define Increment(data, position, direction)\
{\
    if (direction == XtsdLeft) {\
	if (position > 0) \
	    position -= 1;\
    }\
    else {\
	if (position < data->length)\
	    position += 1;\
    }\
}

static void MojiIncrement(data, position, direction)
DiskSourcePtr data;
XtTextPosition *position;
XtTextScanDirection direction;
{
    register XtTextPosition i;
    char c;
    if (direction == XtsdLeft) {
	if (*position > 0) { 
	    for ( i = *position; i > 0; i-- ) {
		FillBuffer(data, i);
		if ((Look(data, i, direction) & 0xff) < 0x40) 
		    break;
	    }
	    if ( i < *position ) {
	        while (i < *position - 1) {
		    FillBuffer(data, i);
#ifdef KANJI
		    (iskanji(Look(data, i, XtsdRight))) ? i += 2 : i += 1;
#else KANJI
		    Look(data, i, XtsdRight);
		    i += 1;
#endif KANJI
	        }
                ( i == *position - 1 ? *position -= 1: *position -= 2);
	    } else
		*position -= 1;
	}
    }
    else {
	if (*position < data->length) {
	    FillBuffer(data, *position);
#ifdef KANJI
	    (iskanji(Look(data, *position, direction)) ? *position += 2 : *position += 1);
#else KANJI
	    Look(data, *position, direction);
	    *position += 1;
#endif KANJI
	}
    }
}

static XtResource diskResources[] = {
    {XtNfile, XtCFile, XtRString, sizeof (char *),
        XtOffset(DiskSourcePtr, fileName), XtRString, NULL},
};

static XtResource sourceResources[] = {
    {XtNeditType, XtCEditType, XtREditMode, sizeof(int), 
        XtOffset(XtTextSource, edit_mode), XtRString, "read"},
};

static char Look(data, position, direction)
  DiskSourcePtr data;
  XtTextPosition position;
  XtTextScanDirection direction;
{

    if (direction == XtsdLeft) {
	if (position == 0)
	    return('\n');
	else {
	    FillBuffer(data, position - 1);
	    return(data->buffer[position - data->position - 1]);
	}
    }
    else {
	if (position == data->length)
	    return('\n');
	else {
	    FillBuffer(data, position);
	    return(data->buffer[position - data->position]);
	}
    }
}



int SDiskReadText (src, pos, text, length)
  XtTextSource src;
  XtTextPosition pos;	/** starting position */
  XtTextBlock *text;	/** RETURNED: text read in */
  int length;		/** max number of bytes to read **/
{
    XtTextPosition count;
    DiskSourcePtr data;

    data = (DiskSourcePtr) src->data;
    FillBuffer(data, pos);
    text->firstPos = pos;
    text->ptr = data->buffer + (pos - data->position);
    count = data->charsInBuffer - (pos - data->position);
    text->length = (length > count) ? count : length;
    return pos + text->length;
}

/*
 * this routine reads text starting at "pos" into memory.
 * Contains heuristic for keeping the read position centered in the buffer.
 */
static int FillBuffer (data, pos)
  DiskSourcePtr data;
  XtTextPosition pos;
{
    long readPos;
    /* Bug!!!  Fixed by M. Ono */ 
    /*
    if ((pos < data->position ||
	    pos >= data->position + data->charsInBuffer - 100) &&
	    data->charsInBuffer != data->length) {
    */
    /* followings may be correct */
    if  (data->charsInBuffer == 0 ||
	(    (data->charsInBuffer != data->length) &&
	     (    (pos < data->position) ||
		  (   (pos >= data->position + data->charsInBuffer - 100) &&
		      (data->position < data->length - bufSize))))) {
	if (pos < (bufSize / 2))
	    readPos = 0;
	else
	    if (pos >= data->length - bufSize)
		readPos = data->length - bufSize;
	    else
	        readPos = pos - (bufSize / 2);
	(void) fseek(data->file, readPos, 0);
	data->charsInBuffer = fread(data->buffer, sizeof(char), bufSize,
				data->file);
	data->position = readPos;
    }
}

/*
 * This is a dummy routine for read only disk sources.
 */
/*ARGSUSED*/  /* keep lint happy */
static int DummyReplaceText (src, startPos, endPos, text, deltaLine)
  XtTextSource src;
  XtTextPosition startPos, endPos;
  XtTextBlock *text;
  int *deltaLine;
{
    return(EditError);
}


/*
 * This routine will only append to the end of a source.  If incorrect
 * starting and ending positions are given, an error will be returned.
 */
static int DiskAppendText (src, startPos, endPos, text, deltaLine)
  XtTextSource src;
  XtTextPosition startPos, endPos;
  XtTextBlock *text;
  int *deltaLine;
{
    long topPosition = 0;
    char *tmpPtr;
    DiskSourcePtr data;
    int line, i;

    data = (DiskSourcePtr) src->data;
    if (startPos != endPos || endPos != data->length)
        return (PositionError);
    /* write the new text to the end of the file */
    if (text->length > 0) {
        /* added by M. Ono */
	text->ptr = XtRealloc(text->ptr, text->length + 1);
	strcat(text->ptr, "\n");
	text->length++;
	/* add end */
	(void) fseek(data->file, data->length, 0);
	(void) fwrite(text->ptr, sizeof(char), text->length, data->file);
    } else
	/* if the delete key was hit, blank out last char in the file */
	if (text->length < 0) {
		(void) fseek(data->file, data->length, 0);
		(void) fwrite(" ", sizeof(char), 1, data->file);
	}
    /* need this in case the application trys to seek to end of file. */
     (void) fseek(data->file, topPosition, 2);	
     
    /* put the new text into the buffer in memory */
    /*
    data->length += text->length;
    */
    data->length += text->length - 1;
    if (data->charsInBuffer + text->length <= bufSize) {
/**** NOTE: need to check if text won't fit in the buffer ***/
	if (text->length > 0) {
		/*
		tmpPtr = data->buffer + data->charsInBuffer;
		*/
		tmpPtr = data->buffer + data->charsInBuffer - 1;
		bcopy(text->ptr, tmpPtr, text->length);
	}
	/*
	data->charsInBuffer += text->length;
	*/
	data->charsInBuffer += text->length - 1;
    } else
        /*
	FillBuffer(data, data->length - text->length);
	*/
	FillBuffer(data, data->length - text->length + 1);

    line = 0;
    text->length--;
    for( i = text->length - 1; i >= 0; i-- ) {
      if( text->ptr[i] == '\n' ) {
	  ++line;
	  }
    }
    *deltaLine = line;
    if (line > 0) {
        data->lastLine += line;
        data->src_lt = (int *)XtRealloc(data->src_lt,
				sizeof(int *) * data->lastLine);
	line = data->lastLine;
	data->src_lt[line - 1] = data->length;
	line--;
        for( i = text->length - 1; i >= 0; i-- ) {
	    if ( text->ptr[i] == '\n' ) {
	        data->src_lt[line - 1] = data->length - text->length + i;
	        line--;
	    }
	}
    }
    return (EditDone);
}


static int DiskSetLastPos (src, lastPos)
  XtTextSource src;
  XtTextPosition lastPos;
{
    ((DiskSourceData *)(src->data))->length = lastPos;
}

/*
 * This routine will start at
 * the "pos" position of the source and scan in the appropriate
 * direction until it finds something of the right sType.  It returns 
 * the new position.  If upon reading it hits the end of the buffer
 * in memory, it will refill the buffer.
 */
static XtTextPosition DiskScan (src, pos, sType, dir, count, include)
  XtTextSource 	 src;
  XtTextPosition pos;
  XtTextScanType sType;
  XtTextScanDirection  dir;
  int     	 count;
  Boolean	 include;
{
    DiskSourcePtr data;
    XtTextPosition position;
    int     i, whiteSpace;
    char    c;
#ifdef KANJI
    Boolean kanji;
    unsigned short mskanji;
#endif KANJI
    int ddir = (dir == XtsdRight) ? 1 : -1;
    int line;

    data = (DiskSourcePtr) src->data;
    position = pos;
    switch (sType) {
	case XtstPositions: 
	    if (!include && count > 0)
		count -= 1;
	    for (i = 0; i < count; i++) {
		MojiIncrement(data, &position, dir);
	    }
	    break;
	case XtstWhiteSpace: 
	    for (i = 0; i < count; i++) {
		whiteSpace = -1;
		while (position >= 0 && position <= data->length) {
#ifdef KANJI
		    kanji = FALSE;
#endif KANJI
		    if (dir == XtsdRight) {
			FillBuffer(data, position);
		        c = Look(data, position, dir);
#ifdef KANJI
		        if (iskanji(c)) {
			    FillBuffer(data, position + ddir);
			    mskanji = (( c & 0xff )<< 8) + 
				      (Look(data, position + ddir, dir) & 0xff);
			    kanji = TRUE;
			} 
#endif KANJI
		    } else {
			FillBuffer(data, position + ddir);
		        c = Look(data, position + ddir, dir);
#ifdef KANJI
			if (iskanji(c)) {
			    FillBuffer(data, position);
			    mskanji = (( c & 0xff )<< 8 )+ 
				      (Look(data, position, dir) & 0xff);
			    
			    kanji = TRUE;
			}
#endif KANJI
		    }

#ifdef KANJI
		    if ( kanji ) {
		        if (((mskanji < 0x8151 || mskanji > 0x8159) && 
				mskanji != 0x815b && jiskigou(mskanji))
				    ||jisspace(mskanji) ) {
			    if (whiteSpace < 0) 
			        whiteSpace = position;
			} else if (whiteSpace >= 0)
			    break;
			position += 2 * ddir;
		    }   else {
#endif KANJI
			FillBuffer(data, position);
		        c = Look(data, position, dir);
		        if ((c == ' ') || (c == '\t') || (c == '\n')){
		            if (whiteSpace < 0) whiteSpace = position;
		        } else if (whiteSpace >= 0)
			    break;
		        position += ddir;
#ifdef KANJI
		    }
#endif KANJI
		}
	    }
	    if (!include) {
		if(whiteSpace < 0 && dir == XtsdRight) whiteSpace = data->length;
		position = whiteSpace;
	    }
	    break;
	case XtstEOL: 
	    /* By M. Ono
	    for (i = 0; i < count; i++) {
		while (position >= 0 && position <= data->length) {
		    if (Look(data, position, dir) == '\n')
			break;
		    Increment(data, position, dir);
		}
		if (i + 1 != count)
		    Increment(data, position, dir);
	    }
	    */
	    line = DiskGetLinePos( src, position );
	    if ( dir == XtsdRight ) {
		if (line + count - 1<= data->lastLine)
		    position = data->src_lt[line + count - 2];
		else
		    position = data->src_lt[data->lastLine - 1];
	    }
	    else {
		if (line - count >= 1)
		    position = data->src_lt[line - count - 1] + 1;
		else
		    position = 0;
	    }
	    if (include) {
	    /* later!!!check for last char in file # eol */
		Increment(data, position, dir);
	    }
	    break;
	case XtstAll: 
	    if (dir == XtsdLeft)
		position = 0;
	    else
		position = data->length;
    }
    return(position);
}

/*
 * Get Line position
 *  This routine is added for Scroll Text
 */

static int DiskGetLinePos( src, pos )
XtTextSource src;
XtTextPosition pos;
{
    DiskSourcePtr data;
    int line;
    data = (DiskSourcePtr) src->data;
    for( line = 1; line <= data->lastLine; line++ ) {
      if( data->src_lt[line - 1] >= pos )
	  break;
    }
    return( line );
}

static int MakeLineTable( src )
XtTextSource src;
{
    DiskSourcePtr data;
    XtTextPosition p;
    int line = 1;
    data = (DiskSourcePtr) src->data;
    p = data->length;
    while( p ) {
      if( Look( data, p, XtsdLeft ) == '\n' )
	  ++line;
      p--;
    }
    data->lastLine = line;
    data->src_lt = (int *)XtMalloc(sizeof(int *) * line);
    data->src_lt[line - 1] = data->length;
    line--;
    p = data->length;
    while( p ) {
	if ( Look(data, p, XtsdLeft) == '\n' ) {
	    data->src_lt[line - 1] = p - 1;
	    line--;
	}
	p--;
    }
}

/******* Public routines **********/

XtTextSource XtSDiskSourceCreate(parent, args, num_args)
    Widget	parent;
    ArgList	args;
    Cardinal	num_args;
{
    XtTextSource src;
    DiskSourcePtr data;
    long topPosition = 0;
    char checkBuf[10];
    long length;

    src = XtNew(XtTextSourceRec);

    XtGetSubresources (parent, (caddr_t)src, XtNtextSource, XtCTextSource,
		       sourceResources, XtNumber(sourceResources),
		       args, num_args);

    src->Read = SDiskReadText;
    src->SetLastPos = DiskSetLastPos;
    src->Scan = DiskScan;
    src->GetLinePos = DiskGetLinePos;
    data = XtNew(DiskSourceData);
    src->data = (caddr_t)data;

    XtGetSubresources (parent, (caddr_t)data, XtNtextSource, XtCTextSource,
        diskResources, XtNumber(diskResources),
	args, num_args);

    if (data->fileName == NULL) {
	data->fileName = tmpnam (XtMalloc((unsigned)TMPSIZ));
	data->is_tempfile = TRUE;
    } else
        data->is_tempfile = FALSE;

    switch (src->edit_mode) {
        case XttextRead:
           if ((data->file = fopen(data->fileName, "r")) == 0)
                XtError("Cannot open source file in XtDiskSourceCreate");
            src->Replace = DummyReplaceText;
            break;
        case XttextAppend:
            if ((data->file = fopen(data->fileName, "r+")) == 0)
                XtError("Cannot open source file in XtDiskSourceCreate");
            src->Replace = DiskAppendText;
            break;
        default:
            if ((data->file = fopen(data->fileName, "r")) == 0)
                XtError("Cannot open source file in XtDiskSourceCreate");
            src->Replace = DummyReplaceText;
    }
    (void) fseek(data->file, topPosition, 2);  
    data->length = ftell (data->file);
    (void) fseek(data->file, -1L, 2);  
    length = fread(checkBuf, sizeof(char), 10, data->file);
    if (length && checkBuf[0] == '\n')  /* Ignore last nl.(Ono) */
	data->length--;
    data->buffer = (char *) XtMalloc((unsigned)bufSize);
    data->position = 0;
    data->charsInBuffer = 0;
    MakeLineTable(src);
    return src;
}

void XtSDiskSourceDestroy (src)
  XtTextSource src;
{
    DiskSourcePtr data;
    data = (DiskSourcePtr) src->data;
    XtFree((char *) data->buffer);
    XtFree((char *) data->src_lt);
    if (data->is_tempfile) {
        unlink(data->fileName);
	XtFree((char *) data->fileName);
    }
    XtFree((char *) src->data);
    XtFree((char *) src);
}
