#ifndef lint
static char rcsid[] = "$Header: SDialog.c,v 1.1 88/08/20 09:06:23 michael Exp $ Sony Corporation";
#endif lint
/*
 * $Log:	SDialog.c,v $
 * Revision 1.1  88/08/20  09:06:23  michael
 * Initial revision
 * 
 */

/******************************************************************************

            Copyright 1988 by Sony Corporation, Tokyo, Japan.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Sony not be used in 
advertising or publicity pertaining to distribution of the software 
without specific, written prior permission.  

SONY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
SONY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/

#include <X11/Xlib.h>
#include <X11/Xos.h>
#include <X11/IntrinsicP.h>
#include <X11/Misc.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <X11/SStringDefs.h>
#include <X11/SDialogP.h>
#include <X11/SBitmap.h>
#include <X11/SButton.h>
#include <X11/SScrollText.h>
#include <X11/SWindow.h>
#include <X11/SKanjiText.h>

#define	RadioButtonBitmap	"radio_button"
#define	HighlightRadioButton	"highlight_radio_button"
#define	SelectedRadioButton	"select_radio_button"
#define	SelHighRadioButton	"highlight_select_radio_button"

#define CheckBoxBitmap	"check_box"
#define HighlightCheckBox	"highlight_check_box"
#define SelectedCheckBox	"select_check_box"
#define SelHighCheckBox	"highlight_select_check_box"

#define BeepLength 50
#define BeepInterval 100
#define FlashLength 100

static int defBeep = 1;

static XtResource resources[] = {
  {XtNdialogType, XtCDialogType, XtRDialogType, sizeof(XtDialogType),
     XtOffset(SDialogWidget, dialog.dialog_type), XtRString, "alert"},
  {XtNitemList, XtCItemList, XtRPointer, sizeof(XtDialogItemList),
     XtOffset(SDialogWidget, dialog.item_list), XtRPointer, NULL},
  {XtNdefaultButton, XtCDefaultButton, XtRString, sizeof(char *),
     XtOffset(SDialogWidget, dialog.default_button), XtRString, "button1"},
  {XtNnumBeep, XtCNumBeep, XtRInt, sizeof(int),
     XtOffset(SDialogWidget, dialog.num_beep), XtRInt, (caddr_t)&defBeep}
};

#define MaxText 100

static void ClassInitialize();
static void Initialize(), ConstraintInitialize();
static Boolean SetValues();
static void Redisplay();

static void SetArgsAndCreateWidget();
static void SetFocus();
static void UnsetFocus();
static void MoveFocusNext();
static void MoveFocusPrev();
static void MoveFocusToMe();
static void FlashButton();

SDialogClassRec sDialogClassRec = {
  { /* core_class fields */
    /* superclass         */    (WidgetClass) &formClassRec,
    /* class_name         */    "SDialog",
    /* widget_size        */    sizeof(SDialogRec),
    /* class_initialize   */    ClassInitialize,
    /* class_part init    */    NULL,
    /* class_inited       */    FALSE,
    /* initialize         */    Initialize,
    /* initialize_hook    */    NULL,
    /* realize            */    XtInheritRealize,
    /* actions            */    NULL,
    /* num_actions        */    0,
    /* resources          */    resources,
    /* num_resources      */    XtNumber(resources),
    /* xrm_class          */    NULLQUARK,
    /* compress_motion    */    TRUE,
    /* compress_exposure  */    TRUE,
    /* compress_enterleave*/    TRUE,
    /* visible_interest   */    FALSE,
    /* destroy            */    NULL,
    /* resize             */    XtInheritResize,
    /* expose             */    Redisplay,/*XtInheritExpose,*/
    /* set_values         */    SetValues,
    /* set_values_hook    */    NULL,
    /* set_values_almost  */    XtInheritSetValuesAlmost,
    /* get_values_hook    */    NULL,
    /* accept_focus       */    NULL,
    /* version            */    XtVersion,
    /* callback_private   */    NULL,
    /* tm_table           */    NULL,
    /* query_geometry     */	NULL
  },
  { /* composite_class fields */
    /* geometry_manager   */   XtInheritGeometryManager,
    /* change_managed     */   XtInheritChangeManaged,
    /* insert_child       */   XtInheritInsertChild,
    /* delete_child       */   XtInheritDeleteChild,
    /* move_focus_to_next */   MoveFocusNext,
    /* move_focus_to_prev */   MoveFocusPrev
  },
  { /* constraint_class fields */
    /* subresourses       */   NULL,
    /* subresource_count  */   0,
    /* constraint_size    */   sizeof(SDialogConstraintsRec),
    /* initialize         */   ConstraintInitialize,
    /* destroy            */   NULL,
    /* set_values         */   NULL
  },
  { /* form_class fields */
    /* empty              */   0
  },
  { /* dialog_class fields */
    /* empty              */   0
  }
};

WidgetClass sDialogWidgetClass = (WidgetClass)&sDialogClassRec;

static char dialogTextEventBindings[] = 
    "<Key>0xff53:	forward-character() \n\
    <Key>0xff51:	backward-character() \n\
    <Key>0xff7f:	delete-previous-character() \n\
    <Key>0xffff:	delete-previous-character() \n\
    <Key>0xff08:	delete-previous-character() \n\
    <FocusIn>:		focus-in() \n\
    <FocusOut>:		focus-out() \n\
    <Btn1Down>:		notify(click) select-start() \n\
    Button1<PtrMoved>:	extend-adjust() \n\
    <Btn1Up>:		extend-end() \n\
    <Btn2Down>:		notify(click) stuff() \n\
    <Btn3Down>:		notify(click) extend-start() \n\
    Button3<PtrMoved>: 	extend-adjust() \n\
    <Btn3Up>:		extend-end() \n\
    Shift<Key>0xff09: 	notify(s_tab) \n\
    Shift Ctrl<Key>I: 	notify(s_tab) \n\
    <Key>0xff09: 	notify(tab) \n\
    Ctrl<Key>I: 	notify(tab) \n\
    <Key>0xff0d: 	notify(return) \n\
    <Key>:		insert-char()";
    
static char dialogNumericTextEventBindings[] = 
    "<Key>0xff53:	forward-character() \n\
    <Key>0xff51:	backward-character() \n\
    <Key>0xff7f:	delete-previous-character() \n\
    <Key>0xffff:	delete-previous-character() \n\
    <Key>0xff08:	delete-previous-character() \n\
    <FocusIn>:		focus-in() \n\
    <FocusOut>:		focus-out() \n\
    <Btn1Down>:		notify(click) select-start() \n\
    Button1<PtrMoved>:	extend-adjust() \n\
    <Btn1Up>:		extend-end() \n\
    <Btn2Down>:		notify(click) stuff() \n\
    <Btn3Down>:		notify(click) extend-start() \n\
    Button3<PtrMoved>: 	extend-adjust() \n\
    <Btn3Up>:		extend-end() \n\
    Shift<Key>0xff09: 	notify(s_tab) \n\
    Shift Ctrl<Key>I: 	notify(s_tab) \n\
    <Key>0xff09: 	notify(tab) \n\
    Ctrl<Key>I: 	notify(tab) \n\
    <Key>0xff0d: 	notify(return) \n\
    None<Key>0x0030:	insert-char() \n\
    None<Key>0x0031:	insert-char() \n\
    None<Key>0x0032:	insert-char() \n\
    None<Key>0x0033:	insert-char() \n\
    None<Key>0x0034:	insert-char() \n\
    None<Key>0x0035:	insert-char() \n\
    None<Key>0x0036:	insert-char() \n\
    None<Key>0x0037:	insert-char() \n\
    None<Key>0x0038:	insert-char() \n\
    None<Key>0x0039:	insert-char() \n\
    None<Key>0xffb0:	insert-char() \n\
    None<Key>0xffb1:	insert-char() \n\
    None<Key>0xffb2:	insert-char() \n\
    None<Key>0xffb3:	insert-char() \n\
    None<Key>0xffb4:	insert-char() \n\
    None<Key>0xffb5:	insert-char() \n\
    None<Key>0xffb6:	insert-char() \n\
    None<Key>0xffb7:	insert-char() \n\
    None<Key>0xffb8:	insert-char() \n\
    None<Key>0xffb9:	insert-char() \n\
    <Key>:		beep()";
    
static char dialogScrollTextEventBindings[] =
    "<Btn1Up>(2):	notify(return) \n\
    <Btn1Down>:		select-start() \n\
    <Btn1Up>:		select-end()";

static char defaultButtonEventBindings[] =
    "<Key>0xff0d: 	set() notify() unset()";


#define done(address, type) \
        { toVal->size = sizeof(type); toVal->addr = (caddr_t) address; }

/* DialogType enumeration constants */

static  XrmQuark  XtQDialogAlert;
static  XrmQuark  XtQDialogModal;
static  XrmQuark  XtQDialogModeless;



/*****************************************************
 *
 * Callback routines 
 *
 *****************************************************/

/* ARGSUSED */
static void text_callback( w, closure, data )
Widget w;
caddr_t closure;
caddr_t data;
{
    Widget dw;
    char **key;
    Widget dflt_btn;

    if (!data) return;
    key = (char **)data;
    dw = w;
    while( XtClass(dw = XtParent(dw)) != sDialogWidgetClass );

    if (!strcmp( key[0], "tab" ))
        MoveFocusNext( w );
    else if (!strcmp( key[0], "s_tab" ))
        MoveFocusPrev( w );
    else if (!strcmp( key[0], "click" ))
	MoveFocusToMe( w );
    else if (!strcmp( key[0], "return" )){
	if (dflt_btn = 
	      XtNameToWidget(dw, ((SDialogWidget)dw)->dialog.default_button)) {
	    FlashButton( dflt_btn );
	}
    }
}

/* ARGSUSED */
static void radioButtonCallback(widget,closure,callData)
Widget widget;
caddr_t closure;
caddr_t callData;
{
    SButtonWidget bw = (SButtonWidget)widget;
    SDialogWidget dw = (SDialogWidget)XtParent(widget);
    int button_group = (int)closure;
    static Arg arg[] = {
	{XtNselected, (XtArgVal)NULL},
    };

    arg[0].value = NULL;
    XtGetValues((Widget)bw, arg, 1);
    if( !arg[0].value ) {
	if ( dw->dialog.radio_button_group[ button_group ] ) {
            arg[0].value =  FALSE;
            XtSetValues( (Widget)dw->dialog.radio_button_group[ button_group ],
			 arg, 1 );
        }
        arg[0].value = TRUE;
        XtSetValues( (Widget)bw, arg, 1 );
	dw->dialog.radio_button_group[ button_group ] = (Widget)bw;
    }
}


/* ARGSUSED */
static  void checkBoxCallback(widget,closure,callData)
Widget widget;
caddr_t closure;
caddr_t callData;
{
    SButtonWidget bw = (SButtonWidget)widget;
    static Arg arg[] = {
	{XtNselected, (XtArgVal)NULL},
    };

    arg[0].value = NULL;
    XtGetValues((Widget)bw, arg, 1);
    arg[0].value = arg[0].value ? FALSE : TRUE;
    XtSetValues((Widget)bw, arg, 1);
}


/* ARGSUSED */
void XtSDialogPopupCallback(widget,closure,callData)
Widget widget;
caddr_t closure;
caddr_t callData;
{
    SDialogWidget dw = (SDialogWidget)closure;
    if ( dw->dialog.current_focus_widget ) 
	SetFocus( dw->dialog.current_focus_widget );
    else {
	Widget db;
	if ( db = XtNameToWidget((Widget)dw, dw->dialog.default_button) ) {
	    SetFocus( db );
	}
    }
}

/* ARGSUSED */
void XtSDialogPopdownCallback(widget,closure,callData)
Widget widget;
caddr_t closure;
caddr_t callData;
{
    SDialogWidget dw = (SDialogWidget)closure;
    if( dw->dialog.dialog_type == XtdtAlert ) {
	XUngrabServer( XtDisplay(dw) );
	XUngrabKeyboard( XtDisplay(dw), CurrentTime );
    }
    if ( dw->dialog.current_focus_widget ) 
	UnsetFocus( dw->dialog.current_focus_widget);
    else 
        XtSetKeyboardFocus((Widget)dw, (Widget)None);
}

/* ARGSUSED */
static void BeepTimeout(client_data, id)
caddr_t client_data;
XtIntervalId *id;
{
    SDialogWidget dw = (SDialogWidget)client_data;

    XBell( XtDisplay(dw), BeepLength );
    XSync( XtDisplay(dw), FALSE );
    dw->dialog.beep_count --;
    if ( dw->dialog.beep_count )
	XtAddTimeOut( BeepInterval, BeepTimeout, (caddr_t)dw );
}

/* ARGSUSED */
static void FlashTimeout(client_data, id)
caddr_t client_data;
XtIntervalId *id;
{
    static Arg arg[] = {
	{XtNselected, (XtArgVal)NULL}
    };
    Widget bw = (Widget)client_data;
    arg[0].value = (XtArgVal)FALSE;
    XtSetValues( bw, arg, 1);
    XtCallCallbacks( bw, XtNcallback, (caddr_t)NULL );
}


/****************************************************
 *
 * Resouce converter for String to DialogType
 *
 ****************************************************/

/* ARGSUSED */
static void CvtStringToDialogType(args, num_args, fromVal, toVal)
    XrmValuePtr *args;		/* unused */
    Cardinal	*num_args;	/* unused */
    XrmValuePtr	fromVal;
    XrmValuePtr	toVal;
{
    static XtDialogType dialogType;
    XrmQuark    q;
    char        lowerName[1000];

    LowerCase((char *)fromVal->addr, lowerName);
    q = XrmStringToQuark(lowerName);
    if (q == XtQDialogAlert ) {
        dialogType = XtdtAlert;
        done(&dialogType, XtDialogType);
        return;
    }
    if (q == XtQDialogModal ) {
        dialogType = XtdtModal;
        done(&dialogType, XtDialogType);
        return;
    }
    if (q == XtQDialogModeless ) {
        dialogType = XtdtModeless;
        done(&dialogType, XtDialogType);
        return;
    }
    toVal->size = 0;
    toVal->addr = NULL;
};

static void ClassInitialize()
{
    XtQDialogAlert = XrmStringToQuark(XtEdialogAlert);
    XtQDialogModal = XrmStringToQuark(XtEdialogModal);
    XtQDialogModeless = XrmStringToQuark(XtEdialogModeless);
    XtAddConverter(XtRString, XtRDialogType, CvtStringToDialogType, NULL, 0);
}


/* ARGSUSED */
static void Initialize(request, new)
Widget request, new;
{
    SDialogWidget dw = (SDialogWidget)new;

    static XtCallbackRec radio_callback[] = {
	{(XtCallbackProc)radioButtonCallback, (caddr_t)NULL},
	{NULL, (caddr_t)NULL }
    };

    static XtCallbackRec check_callback[] = {
	{checkBoxCallback, (caddr_t)NULL},
	{NULL, (caddr_t)NULL }
    };

    static Arg bitmap_arg[] = {
	{XtNfromVert, (XtArgVal)NULL},
	{XtNfromHoriz, (XtArgVal)NULL},
	{XtNborderWidth, (XtArgVal) 0}
    };

    static Arg button_arg[] = {
	{XtNfromVert, (XtArgVal)NULL},
	{XtNfromHoriz, (XtArgVal)NULL},
	{XtNborderWidth, (XtArgVal)2}
    };

    static Arg radio_arg[] = {
	{XtNfromVert, (XtArgVal)NULL},
	{XtNfromHoriz, (XtArgVal)NULL},
	{XtNbitmapFile, (XtArgVal)RadioButtonBitmap},
	{XtNhighlightBitmapFile, (XtArgVal)HighlightRadioButton},
	{XtNselectedBitmapFile, (XtArgVal)SelectedRadioButton},
	{XtNselhighBitmapFile, (XtArgVal)SelHighRadioButton},
	{XtNborderWidth, (XtArgVal)0},
	{XtNhighlightMode, (XtArgVal)2},
	{XtNselectMode, (XtArgVal)2},
	{XtNcallback, (XtArgVal)radio_callback}
    };

    static Arg check_arg[] = {
	{XtNfromVert, (XtArgVal)NULL},
	{XtNfromHoriz, (XtArgVal)NULL},
	{XtNbitmapFile, (XtArgVal)CheckBoxBitmap},
	{XtNhighlightBitmapFile, (XtArgVal)HighlightCheckBox},
	{XtNselectedBitmapFile, (XtArgVal)SelectedCheckBox},
	{XtNselhighBitmapFile, (XtArgVal)SelHighCheckBox},
	{XtNborderWidth, (XtArgVal)0},
	{XtNhighlightMode, (XtArgVal)2},
	{XtNselectMode, (XtArgVal)2},
	{XtNcallback, (XtArgVal)check_callback}
    };

    static Arg standardText_arg[] = {
	{XtNfromVert, (XtArgVal)NULL},
	{XtNfromHoriz, (XtArgVal)NULL},
	{XtNtextOptions, (XtArgVal)wordBreak},
	{XtNeditType, (XtArgVal)XttextEdit}
    };

    static Arg text_arg[] = {
	{XtNfromVert, (XtArgVal)NULL},
	{XtNfromHoriz, (XtArgVal)NULL},
	{XtNtranslations, (XtArgVal)NULL},
	{XtNeditType, (XtArgVal)XttextEdit},
	{XtNshowInsertCursor, (XtArgVal)FALSE}
    };

    static Arg staticText_arg[] = {
	{XtNfromVert, (XtArgVal)NULL},
	{XtNfromHoriz, (XtArgVal)NULL},
	{XtNtranslations, (XtArgVal)NULL},
	{XtNtextOptions, (XtArgVal)wordBreak},
	{XtNshowInsertCursor, (XtArgVal)FALSE},
	{XtNcursor, (XtArgVal)NULL}
    };

    static XtTextSelectType line_sel[] = {XtselectLine, XtselectNull};
    static Arg scrollText_arg[] = {
	{XtNfromVert, (XtArgVal)NULL},
	{XtNfromHoriz, (XtArgVal)NULL},
	{XtNshowInsertCursor, (XtArgVal)FALSE},
	{XtNselectTypes, (XtArgVal)line_sel}
    };
    static Arg st_arg2[] = {{XtNtranslations, (XtArgVal)NULL}};

    static Arg viewText_arg[] = {
	{XtNfromVert, (XtArgVal)NULL},
	{XtNfromHoriz, (XtArgVal)NULL},
	{XtNtextOptions, (XtArgVal)wordBreak},
	{XtNshowInsertCursor, (XtArgVal)FALSE}
    };
    static Arg vt_arg2[] = {{XtNtranslations, (XtArgVal)NULL}};

    Widget text;

    static Arg user_arg[] = {
	{XtNfromVert, (XtArgVal)NULL},
	{XtNfromHoriz, (XtArgVal)NULL}
    };

    int group_num;
    char *suffix;
    static Arg radio_arg2[] = {
	{XtNselected, (XtArgVal)NULL}
    };

    XtDialogItemType itemType;
    XtDialogItemList itemList;

    XtTranslations textTranslation, numericTranslation;

    itemList = dw->dialog.item_list;
    dw->dialog.focus_list = NULL;
    dw->dialog.current_focus = 0;
    dw->dialog.current_focus_widget = NULL;
    dw->dialog.num_focus = dw->dialog.num_slots = 0;
    dw->dialog.has_grab = FALSE;
    dw->dialog.prev_grab = NULL;

    textTranslation = XtParseTranslationTable(dialogTextEventBindings);
    numericTranslation = XtParseTranslationTable(dialogNumericTextEventBindings);

    staticText_arg[2].value = vt_arg2[0].value = 
		(XtArgVal)XtParseTranslationTable("");
    st_arg2[0].value = (XtArgVal) XtParseTranslationTable( 
		dialogScrollTextEventBindings);

    for (group_num = 99; group_num >= 0; group_num-- )
        dw->dialog.radio_button_group[ group_num ] = NULL;

    while ( (itemType = itemList->item_type) != XtdiEnd ) {
	switch ( itemType ) {
	    case XtdiBitmap: 
		SetArgsAndCreateWidget( dw, sBitmapWidgetClass, itemList,
					bitmap_arg, XtNumber(bitmap_arg) );
		break;

	    case XtdiButton:
		if ( !strcmp( itemList->item_name, 
		     dw->dialog.default_button )) 
		    button_arg[2].value = (XtArgVal)4;
		else
		    button_arg[2].value = (XtArgVal)2;
		SetArgsAndCreateWidget( dw, sButtonWidgetClass, 
				        itemList,
				        button_arg, 
					XtNumber(button_arg) );
		break;

	    case XtdiRadioBtn:
		if ( !(suffix = index( itemList->item_name, '-' )))
		    XtError("<Dialog> Invalid radio button name.\n");
		group_num = atoi( suffix + 1 );
		if ( group_num < 0 || group_num >= MaxGroup )
		    XtError("<Dialog> Illegal group number.\n");

		radio_callback[0].closure = (caddr_t)group_num;
		SetArgsAndCreateWidget( dw, sButtonWidgetClass, itemList,
					radio_arg, XtNumber(radio_arg) );

		radio_arg2[0].value = NULL;
		XtGetValues( itemList->widget, radio_arg2, 1 );
		if (radio_arg2[0].value == TRUE) 
		    dw->dialog.radio_button_group[ group_num ] = itemList->widget;

		break;

	    case XtdiCheckBtn:
		SetArgsAndCreateWidget( dw, sButtonWidgetClass, itemList,
					check_arg, XtNumber(check_arg) );
		break;

	    case XtdiStandardText:
		SetArgsAndCreateWidget( dw, sKanjiStringWidgetClass, 
				        itemList,
					standardText_arg, 
					XtNumber(standardText_arg) );
		break;

	    case XtdiStaticText:
		SetArgsAndCreateWidget( dw, sKanjiStringWidgetClass, 
				        itemList,
					staticText_arg, 
					XtNumber(staticText_arg) );
		break;

	    case XtdiText:
	    case XtdiNumericText:
		text_arg[2].value = (XtArgVal)(itemType == XtdiText ?
					textTranslation : numericTranslation);
		SetArgsAndCreateWidget( dw, sTextWidgetClass, itemList,
					text_arg, XtNumber(text_arg) );
		XtAddCallback( itemList->widget, XtNtextCallback, 
				 text_callback, (caddr_t)NULL );
		break;

	    case XtdiScrollText:
		SetArgsAndCreateWidget( dw, sScrollTextWidgetClass, 
					itemList,
					scrollText_arg, 
					XtNumber(scrollText_arg) );

		text = XtNameToWidget(itemList->widget, "text");
		XtSetValues( text, st_arg2, 1 );
		XtAddCallback( text, XtNtextCallback, text_callback, (caddr_t)NULL );
		break;

	    case XtdiViewText:
		SetArgsAndCreateWidget( dw, sScrollTextWidgetClass, 
					itemList,
					viewText_arg, 
					XtNumber(viewText_arg));
		text = XtNameToWidget(itemList->widget, "text");
		XtSetValues( text, vt_arg2, 1 );
		break;

	    case XtdiUser:
		SetArgsAndCreateWidget( dw, itemList->item_widget_class,
				        itemList,
					user_arg, XtNumber(user_arg) );
		break;
	    default:
		XtError("Unkouwn item type\n");
		break;
	}
	if ( itemList->focus ) {
	    if (dw->dialog.num_focus == dw->dialog.num_slots ) {
		dw->dialog.num_slots += (dw->dialog.num_slots / 2) + 2;
		dw->dialog.focus_list = 
		    (WidgetList) XtRealloc((caddr_t)dw->dialog.focus_list,
		    (unsigned int) (dw->dialog.num_slots * sizeof(Widget)));
	    }
	    dw->dialog.focus_list[ dw->dialog.num_focus++ ] = itemList->widget;
	}
	itemList++;
    }
    if ( !dw->dialog.num_focus ) {
	Widget db;
	if ( db = XtNameToWidget((Widget)dw, dw->dialog.default_button) ) 
	    XtAugmentTranslations( db, 
		       XtParseTranslationTable( defaultButtonEventBindings ));
    } else {
	dw->dialog.current_focus_widget = dw->dialog.focus_list[0];
    }
}


/* ARGSUSED */
static void ConstraintInitialize(request, new)
Widget request, new;
{
/* Nothing to do ???*/
}


/* ARGSUSED */
static Boolean SetValues(current, request, new)
Widget current, request, new;
{
    return False;
}

/* ARGSUSED */
static void Redisplay(w, event, region)
Widget w;
XEvent *event;
Region region;
{
    SDialogWidget dw = (SDialogWidget)w;

    Widget pw;

    if( dw->dialog.dialog_type == XtdtAlert ) {
        XGrabServer( XtDisplay(dw) );
	XGrabKeyboard( XtDisplay(dw), XtWindow(dw), TRUE,
		       GrabModeAsync, GrabModeAsync, CurrentTime );
    }
    /*  Currently Modeless and Model are same
    if (dw->dialog.dialog_type != XtdtModeless) {
	if( dw->dialog.dialog_type == XtdtAlert )
	    XGrabServer( XtDisplay(dw) );
	if(XGrabKeyboard( XtDisplay(w), XtWindow(w), TRUE,
		       GrabModeAsync, GrabModeAsync, CurrentTime ) ==
			 AlreadyGrabbed) 
	    while( XGrabKeyboard( XtDisplay(w), XtWindow(w), TRUE,
			GrabModeAsync, GrabModeAsync, CurrentTime )
			== AlreadyGrabbed ) 
                    ;
	else {
	    pw = (Widget)dw;
            while( (pw = XtParent(pw)) != NULL ) 
		if( XtClass(pw) == sDialogWidgetClass &&
		    ((SDialogWidget)pw)->dialog.has_grab ) break;
	    if ( pw != NULL )
	        dw->dialog.prev_grab = pw;
	} 
	XGrabPointer( XtDisplay(w), XtWindow(XtParent(w)), TRUE,
		       NULL,
		       GrabModeAsync, GrabModeAsync, 
		       XtWindow(XtParent(w)), NULL,
		       CurrentTime );
        dw->dialog.has_grab = TRUE;
    }
    */

    if (dw->dialog.dialog_type == XtdtAlert && 
		dw->dialog.num_beep > 0) {
	dw->dialog.beep_count = dw->dialog.num_beep;
	XtAddTimeOut( BeepLength, BeepTimeout, (caddr_t)dw );
    }
}

/*********************************************************
 *
 * Misc. private routines
 *
 *********************************************************/

static void SetArgsAndCreateWidget( dialog, widget_class, itemList, args, num_args )
SDialogWidget dialog;
WidgetClass widget_class;
XtDialogItemList itemList;
ArgList	args;
unsigned int num_args;
{
    ArgList mergedArgs;

    args[0].value = args[1].value = 0;
    if (itemList->fromVert)
        if ( !(args[0].value = 
             (XtArgVal)XtNameToWidget( (Widget)dialog, itemList->fromVert )))
	        XtWarning("fromVert - Can't find widget\n");
    if (itemList->fromHoriz)
        if ( !(args[1].value = 
	     (XtArgVal)XtNameToWidget( (Widget)dialog, itemList->fromHoriz )))
		XtWarning("fromHoriz - Can't find widget\n");
    mergedArgs = XtMergeArgLists( itemList->item_arg, 
			          itemList->num_arg,
			          args, num_args);
    itemList->widget = XtCreateManagedWidget( itemList->item_name,
			          widget_class, (Widget)dialog, 
			          mergedArgs, 
			          num_args + itemList->num_arg );
    XtFree((char *)mergedArgs);
}

static void FlashButton( w )
Widget w;
{
    static Arg arg[] = {
	{XtNselected, (XtArgVal)NULL}
    };
    arg[0].value = (XtArgVal)TRUE;
    XtSetValues( w, arg, 1);
    XtAddTimeOut( FlashLength, FlashTimeout, (caddr_t)w );
}

/********************************************************
 *
 * Focus Management Routines
 *
 ********************************************************/

static void SetFocus( widget )
Widget widget;
{
    int len;

    if (XtIsSubclass(widget, sTextWidgetClass)) {
        SDialogWidget dw = (SDialogWidget) XtParent(widget);
	dw->dialog.current_focus_widget = widget;
        XtSetKeyboardFocus( (Widget)dw, widget );
        len = strlen(XtSTextGetWholeText(widget));
        if (len > 0 && XtIsRealized(widget))  /* no selection at 1st popup OK?? */ 
           XtSTextSetSelection(widget, 0, len);
        XtSTextShowCursor( widget, TRUE );
    } else 
	XtSetKeyboardFocus(XtParent(widget), widget);
}

static void UnsetFocus( widget )
Widget widget;
{
    SDialogWidget dw = (SDialogWidget) XtParent(widget);
    XtSTextShowCursor( widget, FALSE );
    XtSTextUnsetSelection( widget );
    XtSetKeyboardFocus( (Widget)dw, (Widget)None );
}

static void MoveFocusNext(widget)
Widget widget;
{
    SDialogWidget dw = (SDialogWidget) XtParent(widget);
    WidgetList focus_list = dw->dialog.focus_list;
    int num_focus = dw->dialog.num_focus;
    int current_focus = dw->dialog.current_focus;

    if ( num_focus == 0 ) return;
    UnsetFocus( widget );

    current_focus++;
    if (current_focus == num_focus )
	current_focus = 0;
    dw->dialog.current_focus = current_focus;

    SetFocus( focus_list[current_focus] );
}

static void MoveFocusPrev(widget)
Widget widget;
{
    SDialogWidget dw = (SDialogWidget) XtParent(widget);
    WidgetList focus_list = dw->dialog.focus_list;
    int num_focus = dw->dialog.num_focus;
    int current_focus = dw->dialog.current_focus;

    if ( num_focus == 0 ) return;
    UnsetFocus( widget );

    current_focus--;
    if (current_focus < 0 )
	current_focus = num_focus - 1;
    dw->dialog.current_focus = current_focus;

    SetFocus( focus_list[current_focus] );
}


static void MoveFocusToMe(widget)
Widget widget;
{
    SDialogWidget dw = (SDialogWidget) XtParent(widget);
    WidgetList focus_list = dw->dialog.focus_list;
    int num_focus = dw->dialog.num_focus;
    int current_focus = dw->dialog.current_focus;
    Widget current_focus_widget = dw->dialog.current_focus_widget;

    if ( widget != current_focus_widget ) {
	if (current_focus_widget)
	    UnsetFocus( current_focus_widget );

	current_focus = 0;
	while( widget != focus_list[current_focus] )
	    current_focus++;
	if (current_focus < num_focus)
	    dw->dialog.current_focus = current_focus;
	SetFocus( widget );
    }
}

/*****************************************************
 *
 * Public routines
 *
 *****************************************************/

void XtSDialogGetItemValue( dw )
    SDialogWidget dw;
{
    static Arg btn_arg[] = {
	{XtNselected, (XtArgVal)NULL},
    };

    STextWidget tw;
    XtTextPosition 	left, right;
    XtDialogItemList 	itemList;

    itemList = dw->dialog.item_list;

    while (itemList->item_type != XtdiEnd ) {
	switch (itemList->item_type) {
	    case XtdiRadioBtn:
	    case XtdiCheckBtn:
		btn_arg[0].value = NULL;
		XtGetValues( itemList->widget, btn_arg, 1 );
		itemList->value = (caddr_t)btn_arg[0].value;
		break;
	    
	    case XtdiText:
	    case XtdiStandardText:
		itemList->value = (caddr_t)XtSTextGetWholeText(itemList->widget);
		break;

	    case XtdiNumericText:
		itemList->value = (caddr_t)atoi(
				XtSTextGetWholeText(itemList->widget));
		break;

	    case XtdiScrollText:
		tw = (STextWidget)XtNameToWidget(itemList->widget, "text");
		XtSTextGetSelectionPos( tw, &left, &right );
		if ( left == right )
		    itemList->value = (caddr_t)"";
		else
		    itemList->value = (caddr_t)_XtSTextGetText( tw, 
						       left, right );
		break;
	    
	    case XtdiBitmap:
	    case XtdiButton:
	    case XtdiStaticText:
	    case XtdiViewText:
	    case XtdiUser:
		break;
	}
	itemList++;
    }
}


Widget 
XtSCreateDialog( name, parent, popup_args, popup_num_args,
	         window_args, window_num_args, 
		 dialog_args, dialog_num_args, popup, window )
    char *name;
    Widget parent;
    ArgList popup_args, window_args, dialog_args;
    unsigned int popup_num_args, window_num_args, dialog_num_args;
    Widget *popup, *window;
{
    Widget dialog;
    Arg internal_args[3] ;
    ArgList mergedArgs;
    char *popup_name;

    if ( !parent ) XtError("<Dialog> Parent is NULL.\n");

    popup_name = XtMalloc( strlen(name) + 6 );
    sprintf( popup_name, "%s_popup", name );
    *popup = XtCreatePopupShell( popup_name, transientShellWidgetClass,
				parent, popup_args, popup_num_args );
    XtFree(popup_name);

    XtSetArg( internal_args[0], XtNscreenClass, sDialogWidgetClass );
    XtSetArg( internal_args[1], XtNscreenArgs, dialog_args );
    XtSetArg( internal_args[2], XtNnumScreenArgs, dialog_num_args );
    mergedArgs = XtMergeArgLists( window_args, window_num_args,
				  internal_args, XtNumber(internal_args));
    *window = XtCreateManagedWidget( name, sWindowWidgetClass,
				    *popup, mergedArgs, 
				    window_num_args + XtNumber(internal_args));
    dialog = XtNameToWidget( *window, "screen" );
    XtAddCallback( *popup, XtNpopupCallback, XtSDialogPopupCallback, (caddr_t)dialog );
    XtAddCallback( *popup, XtNpopdownCallback, XtSDialogPopdownCallback, (caddr_t)dialog );
    return dialog;
}
