#ifndef lint
static char rcsid[] = "$Header: SCreatePixmap.c,v 1.1 88/08/20 09:06:22 michael Exp $ Sony Corporation";
#endif lint
/*
 * $Log:	SCreatePixmap.c,v $
 * Revision 1.1  88/08/20  09:06:22  michael
 * Initial revision
 * 
 */

/******************************************************************************

            Copyright 1988 by Sony Corporation, Tokyo, Japan.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Sony not be used in 
advertising or publicity pertaining to distribution of the software 
without specific, written prior permission.  

SONY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
SONY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/

/***********************************************************
Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/IntrinsicP.h>

#define MAX_LINE 1000

typedef struct _PixmapCache {
    String	file;
    int		depth;
    Pixmap	pixmap;
    unsigned int width;
    unsigned int height;
    int		x_hot;
    int		y_hot;
    struct _PixmapCache *next;
  } CacheEntry;

static CacheEntry *pixmapCache = NULL;

static cleanup(data, stream)
  char *data;
  FILE *stream;
{
  if (data)
    XtFree(data);
  fclose(stream);
}

static Pixmap CreatePixmap( display, data, width, height, foreground, background , depth )
Display		*display;
char		*data;
unsigned int	width, height;
Pixel		foreground, background;
int		depth;
{
    register Screen *screen = DefaultScreenOfDisplay(display);
    XImage	image;
    Pixmap	new_pixmap;
    GC		gc;
    XGCValues 	gcValues;


    /* nope, we'll have to construct one now */
    image.height           = height;
    image.width            = width;
    image.xoffset          = 0;
    image.format           = XYBitmap;
    image.data             = data;
    image.byte_order       = LSBFirst;
    image.bitmap_pad       = BitmapPad(display);
    image.bitmap_bit_order = LSBFirst;
    image.bitmap_unit      = BitmapUnit(display);
    image.depth            = 1;
    image.bytes_per_line   = width/8;
    image.obdata           = NULL;

    new_pixmap = XCreatePixmap( display, RootWindowOfScreen(screen), 
				 image.width, image.height, depth);


    /* now store the image into it */
    gcValues.foreground = foreground;
    gcValues.background = background;
    /*
    gc = XCreateGC( display, RootWindowOfScreen(screen),
    */
    gc = XCreateGC( display, new_pixmap,
		    GCForeground | GCBackground, &gcValues );

    XPutImage( display, new_pixmap, gc, &image, 0, 0, 0, 0,
	       image.width, image.height);

    XFreeGC( display, gc );

    return( new_pixmap );
}

/****************************************************************
 *	Creates a pixmap of depth DefaultDepth(screen)		*
 ****************************************************************/
int XtSCreatePixmap(display, d, filename, foreground, background, depth, width, height, bitmap, x_hot, y_hot)
Display		*display;
Drawable	d;
char		*filename;
Pixel		foreground, background;
int		depth;
unsigned int	*width, *height;   /* RETURNED */
Pixmap		*bitmap;           /* RETURNED */
int		 *x_hot, *y_hot;    /* RETURNED */
{
    FILE	*stream;
    char	*data = 0;
    char	*ptr;
    char	line[MAX_LINE];
    int		size, bytes;
    char 	name_and_type[MAX_LINE];
    char 	*type;
    int 	value;
    int 	version10p;
    int 	padding;
    int 	bytes_per_line;
    unsigned int ww = 0;
    unsigned int hh = 0;
    int 	hx = -1;
    int 	hy = -1;
    Pixmap 	pix;
    CacheEntry	*cachePtr;
    register Screen *screen = DefaultScreenOfDisplay(display);


    for (cachePtr = pixmapCache; cachePtr; cachePtr = cachePtr->next) {
	if ((cachePtr->depth == depth) && (!strcmp(cachePtr->file, filename))) {
	    *bitmap = cachePtr->pixmap;
	    *width  = cachePtr->width;
	    *height = cachePtr->height;
	    *x_hot  = cachePtr->x_hot;
	    *y_hot  = cachePtr->y_hot;
	    return(BitmapSuccess);
	}
    }

    if (!(stream = fopen(filename, "r")))
	return(BitmapOpenFailed);

    for (;;) {
	if (!fgets(line, MAX_LINE, stream))
	    break;
	if (strlen(line) == MAX_LINE-1) {
	    cleanup(data, stream);
	    return(BitmapFileInvalid);
	}

	if (sscanf(line, "#define %s %d", name_and_type, &value) == 2) {
	    if (!(type = rindex(name_and_type, '_')))
		type = name_and_type;
	    else
		type++;
	    if (!strcmp("width", type))
		ww=(unsigned int) value;
	    if (!strcmp("height", type))
		hh=(unsigned int) value;
	    if (!strcmp("hot", type)) {
		if (type--==name_and_type || type--==name_and_type)
		    continue;
		if (!strcmp("x_hot", type))
		    hx = value;
		if (!strcmp("y_hot", type))
		    hy = value;
	    }
	    continue;
        }
    
	if (sscanf(line, "static short %s = {", name_and_type) == 1)
	    version10p = 1;
	else if (sscanf(line, "static unsigned char %s = {", name_and_type) == 1)
	    version10p = 0;
	else if (sscanf(line, "static char %s = {", name_and_type) == 1)
	    version10p = 0;
	else continue;

	if (!(type = rindex(name_and_type, '_')))
	    type = name_and_type;
	else
	    type++;
	if (strcmp("bits[]", type))
	    continue;
    
	if (!ww || !hh) {
	    cleanup(data, stream);
	    return(BitmapFileInvalid);
	}

	padding = 0;
	if ((ww % 16) && ((ww % 16) < 9) && version10p)
	    padding = 1;

	bytes_per_line = (ww+7)/8 + padding;
    
	size = bytes_per_line * hh;
	data = (char *) XtMalloc( (unsigned)size );
	if (!data) {
	    cleanup(data, stream);
	    return(BitmapNoMemory);
	}

	if (version10p)
	    for (bytes=0, ptr=data; bytes<size; (bytes += 2)) {
		if (fscanf(stream, " 0x%x%*[,}]%*[ \n]", &value) != 1) {
	  	    cleanup(data, stream);
	  	    return(BitmapFileInvalid);
		}
		*(ptr++) = value & 0xff;
		if (!padding || ((bytes+2) % bytes_per_line))
		    *(ptr++) = value >> 8;
	    }
	else
	    for (bytes=0, ptr=data; bytes<size; bytes++, ptr++) {
		if (fscanf(stream, " 0x%x%*[,}]%*[ \n]", &value) != 1) {
		    cleanup(data, stream);
		    return(BitmapFileInvalid);
		}
		*ptr=value;
	    }
    
    }

    if (!data) {
	cleanup(data, stream);
	return(BitmapFileInvalid);
    }

    pix = CreatePixmap(display, data, ww, hh, foreground, background, depth);
    if (!pix) {
	cleanup(data, stream);
	return(BitmapNoMemory);
    }
    *bitmap = pix;
    *width = ww;
    *height = hh;

    /* and insert it at the head of the cache */
    cachePtr 	    = XtNew(CacheEntry);
    cachePtr->depth = depth;
    cachePtr->file  = XtMalloc(strlen(filename));
    strcpy(cachePtr->file, filename);
    cachePtr->next  = pixmapCache;
    pixmapCache     = cachePtr;
    pixmapCache->pixmap = pix;
    pixmapCache->width  = ww;
    pixmapCache->height = hh;

    if (x_hot) {
	*x_hot = hx;
    	pixmapCache->x_hot = hx;
    } else
    	pixmapCache->x_hot = 0;
    if (y_hot) {
	*y_hot = hy;
    	pixmapCache->y_hot = hy;
    } else
    	pixmapCache->y_hot = 0;

    cleanup(data, stream);
    return(BitmapSuccess);
}
