/******************************************************************************

            Copyright 1988 by Sony Corporation, Tokyo, Japan.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Sony not be used in 
advertising or publicity pertaining to distribution of the software 
without specific, written prior permission.  

SONY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
SONY BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/
/*
 * $Header: SBitmapP.h,v 1.1 88/08/20 09:06:40 michael Exp $ Sony Corporation
 *
 * $Log:	SBitmapP.h,v $
 * Revision 1.1  88/08/20  09:06:40  michael
 * Initial revision
 * 
 */
/********************************************************
*							*
*	Private header for Sony Bitmap Widget		*
*							*
*	Written by M.Abe				*
*							*
********************************************************/

#ifndef _XtSBitmapPrivate_h
#define _XtSBitmapPrivate_h

#include <X11/CoreP.h>
#include "X11/SBitmap.h"

/********************************************************
*							*
*	Class structure					*
*							*
********************************************************/

/* New fields for the SBitmap widget class record */
typedef struct _SBitmapClass 
  {
	XtExposeProc	redisplay;
  } SBitmapClassPart;

/* Full class record declaration */
typedef struct _SBitmapClassRec {
    CoreClassPart	core_class;
    SBitmapClassPart     sbitmap_class;
} SBitmapClassRec;

extern SBitmapClassRec sBitmapClassRec;

/********************************************************
*							*
*	Instance (widget) structure 			*
*							*
********************************************************/

/* New fields for the SBitmap widget record */
typedef struct {
	/* resources  for left labels */
	char		*left_label;
	char		*label;
	char		*right_label;

	/* resources  for normal font */
	XFontStruct	*left_font;
	XFontStruct	*font;
	XFontStruct	*right_font;

#ifdef KANJI
	/* resources  for kanji font */
	XFontStruct	*left_kanji_font;
	XFontStruct	*kanji_font;
	XFontStruct	*right_kanji_font;
#endif KANJI

	/* resources  for text extent */
	XtTextExtent	*left_text;
	XtTextExtent	*text;
	XtTextExtent	*right_text;

	/* resources  for bitmap files */
	char *		bitmap_path;
	char *		bitmap_file;
	char *		highlight_bitmap_file;
	char *		selected_bitmap_file;
	char *		selhigh_bitmap_file;
	char *		insensitive_bitmap_file;
	char *		background_file;

	/* resources  for colors */
	Boolean		transp;
	Pixel		foreground;
	Pixel		highlight_border_pixel;
	Pixel		selected_border_pixel;

	/* resources  for flags and modes */
	Boolean		auto_adjust;
	Boolean		selected;
	int		highlight_mode;
	int		select_mode;
	XtOrientation	orientation;

	/* resources  for geometry */
	Dimension	internal_width;
	Dimension	internal_height;

	/* resources  for cursor */
	Cursor		cursor;

	/* private GCs */
	GC		normal_GC;
	GC		normal_KGC;
	GC		highlight_GC;
	GC		highlight_KGC;
	GC		gray_GC;
	GC		gray_KGC;
	GC		invert_GC;

	/* private data for bitmaps */
	Position	bitmap_x;
	Position	bitmap_y;
	Dimension	bitmap_width;
	Dimension	bitmap_height;
	Pixmap		bitmap_data;
	Pixmap		highlight_bitmap_data;
	Pixmap		selected_bitmap_data;
	Pixmap		selhigh_bitmap_data;
	Pixmap		insensitive_bitmap_data;

	/* others */
	Boolean		highlighted;
	XtInternal	internal;	/* not supported yet */
} SBitmapPart;

/* Full widget declaration */
typedef struct _SBitmapRec {
    CorePart	core;
    SBitmapPart	sbitmap;
} SBitmapRec;

#endif _XtSBitmapPrivate_h
/* DON'T ADD STUFF AFTER THIS #endif */
