/********************************************************
*							*
*	Test Program for Pull Down Menu Widget		*
*							*
*	Version 1.0	 4/ 5/88	M.Abe		*
*							*
********************************************************/

/********************************************************
*							*
*	Include definitions				*
*							*
********************************************************/

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Cascade.h>
#include <X11/Shell.h>
#include <X11/Box.h>
#include <X11/SBitmap.h>
#include <X11/SPDMenu.h>

/********************************************************
*							*
*	Report the syntax error for calling button	*
*							*
********************************************************/

Syntax(call)
char *call;
{
	fprintf(stderr, "%s : Syntax error\n", call);
	exit(1);
}

/********************************************************
*							*
*	Global variables				*
*							*
********************************************************/

void apple_proc();
void file_proc();
void edit_proc();
void view_proc();

Widget menubar;
Widget apple_menu;
Widget file_menu;
Widget edit_menu;
Widget view_menu;
Widget special_menu;
Widget window_menu;
Widget pattern_menu;
Widget others_menu;

static Boolean shown_clipboard = FALSE;
static int current_view;

/*
 *	Apple menu items
 */

static XtCallbackRec apple_callback[] =
	{{apple_proc, NULL}, {NULL, NULL}};
static XtMenuItem apple_items[] = {
    {(Widget)NULL, "about",   (WidgetClass)NULL, (ArgList)NULL, 0},
    {(Widget)NULL, "calendar",(WidgetClass)NULL, (ArgList)NULL, 0},
    {(Widget)NULL, "clock",   (WidgetClass)NULL, (ArgList)NULL, 0},
    {(Widget)NULL, "calc",    (WidgetClass)NULL, (ArgList)NULL, 0},
    {(Widget)NULL, "notepad", (WidgetClass)NULL, (ArgList)NULL, 0},
};
static Arg apple_arg[] = {
    {XtNpullDownCallback, (XtArgVal)apple_callback },
    {XtNitems, (XtArgVal)apple_items },
    {XtNnumItems, (XtArgVal)(XtNumber(apple_items)) },
};

/*
 *	File menu items
 */

static XtCallbackRec file_callback[] =
	{{file_proc, NULL}, {NULL, NULL}};
static XtMenuItem file_items[] = {
   {(Widget)NULL, "openfile",      (WidgetClass)NULL, (ArgList)NULL, 0},
   {(Widget)NULL, "closefile",     (WidgetClass)NULL, (ArgList)NULL, 0},
   {(Widget)NULL, "createfile",    (WidgetClass)NULL, (ArgList)NULL, 0},
   {(Widget)NULL, "deletefile",    (WidgetClass)NULL, (ArgList)NULL, 0},
   {(Widget)NULL, "duplicatefile", (WidgetClass)NULL, (ArgList)NULL, 0},
   {(Widget)NULL, "movefile",      (WidgetClass)NULL, (ArgList)NULL, 0},
   {(Widget)NULL, "printfile",     (WidgetClass)NULL, (ArgList)NULL, 0},
   {(Widget)NULL, "quit",          (WidgetClass)NULL, (ArgList)NULL, 0},
};
static Arg file_arg[] = {
    {XtNpullDownCallback, (XtArgVal)file_callback },
    {XtNitems, (XtArgVal)file_items },
    {XtNnumItems, (XtArgVal)(XtNumber(file_items)) },
};

/*
 *	Edit menu items
 */

static XtCallbackRec edit_callback[] =
	{{edit_proc, NULL}, {NULL, NULL}};
static XtMenuItem edit_items[] = {
   {(Widget)NULL, "undo",      (WidgetClass)NULL, (ArgList)NULL, 0},
   {(Widget)NULL, "cut",       (WidgetClass)NULL, (ArgList)NULL, 0},
   {(Widget)NULL, "paste",     (WidgetClass)NULL, (ArgList)NULL, 0},
   {(Widget)NULL, "copy",      (WidgetClass)NULL, (ArgList)NULL, 0},
   {(Widget)NULL, "clipboard", (WidgetClass)NULL, (ArgList)NULL, 0},
};
static Arg edit_arg[] = {
    {XtNpullDownCallback, (XtArgVal)edit_callback },
    {XtNitems, (XtArgVal)edit_items },
    {XtNnumItems, (XtArgVal)(XtNumber(edit_items)) },
};

/*
 *	View menu items
 */

static XtCallbackRec view_callback[] =
	{{view_proc, NULL}, {NULL, NULL}};
static XtMenuItem view_items[] = {
    {(Widget)NULL, "byicon", (WidgetClass)NULL, (ArgList)NULL, 0},
    {(Widget)NULL, "byname", (WidgetClass)NULL, (ArgList)NULL, 0},
    {(Widget)NULL, "bysize", (WidgetClass)NULL, (ArgList)NULL, 0},
    {(Widget)NULL, "bydate", (WidgetClass)NULL, (ArgList)NULL, 0},
    {(Widget)NULL, "bykind", (WidgetClass)NULL, (ArgList)NULL, 0},
};
static Arg view_arg[] = {
    {XtNpullDownCallback, (XtArgVal)view_callback},
    {XtNitems, (XtArgVal)view_items },
    {XtNnumItems, (XtArgVal)(XtNumber(view_items)) },
};

/********************************************************
*							*
*	Call back procedure				*
*							*
********************************************************/

void apple_proc(w, closure, callData)
Widget w;
caddr_t closure;
caddr_t callData;
{
	int num_new_items;
	int item = (int)callData;
	Arg local_arg[1];
	static Arg arg[] = {
	    { XtNleftLabel, (XtArgVal)"New Item" },
	};
	static XtMenuItem new_items[] = {
	    {(Widget)NULL, "newitem", (WidgetClass)NULL, (ArgList)arg, 1},
	};

	switch (item) {
		case 0:	/* About */
			fprintf(stderr, "About is selected\n");
			XtAppendPDMenuItems(apple_menu,
				(XtMenuItemList)new_items,
				XtNumber(new_items));
			break;

		case 1:	/* Calendar */
			fprintf(stderr, "Calendar is selected\n");
			break;

		case 2:	/* Clock */
			fprintf(stderr, "Clock is selected\n");
			break;

		case 3:	/* Calc */
			fprintf(stderr, "Calc is selected\n");
			break;

		case 4:	/* NotePad */
			fprintf(stderr, "NotePad is selected\n");
			break;
	}
}

void file_proc(w, closure, callData)
Widget w;
caddr_t closure;
caddr_t callData;
{
	int item = (int)callData;

	int i, j;
	for (i = 0; i < 32767; i++) {
		for (j = 0; j < 10; j++) ;
	}
	switch (item) {
		case 0:	/* Open File */
			fprintf(stderr, "Open File is selected\n");
			break;

		case 1:	/* Close File */
			fprintf(stderr, "Close File is selected\n");
			break;

		case 2:	/* Create File */
			fprintf(stderr, "Create File is selected\n");
			break;

		case 3:	/* Delete File */
			fprintf(stderr, "Delete File is selected\n");
			break;

		case 4:	/* Duplicate File */
			fprintf(stderr, "Duplicate File is selected\n");
			break;

		case 5:	/* Move File */
			fprintf(stderr, "Move File is selected\n");
			break;

		case 6:	/* Print File */
			fprintf(stderr, "Print File is selected\n");
			break;

		case 7:	/* Quit */
			fprintf(stderr, "Quit is selected\n");
			exit(1);
	}
}

void edit_proc(w, closure, callData)
Widget w;
caddr_t closure;
caddr_t callData;
{
	int item = (int)callData;
	Widget widget;
	Arg arg[1];

	switch (item) {
		case 0: /* Undo */
			fprintf(stderr, "Undo is selected\n");
			break;

		case 1:	/* Cut */
			fprintf(stderr, "Cut is selected\n");
			widget  = edit_items[2].widget;
			arg[0].name = XtNsensitive;
			arg[0].value = TRUE;
			XtSetValues(widget, arg, 1);
			break;

		case 2:	/* Paste */
			fprintf(stderr, "Paste is selected\n");
			break;

		case 3:	/* Copy */
			fprintf(stderr, "Copy is selected\n");
			break;

		case 4:	/* Clipboard */
			fprintf(stderr, "Clipboard is selected\n");
			widget  = edit_items[4].widget;
			arg[0].name = XtNleftLabel;
			if (shown_clipboard) {
			    shown_clipboard = FALSE;
			    arg[0].value = (XtArgVal)"Show Clipboard";
			} else {
			    shown_clipboard = TRUE;
			    arg[0].value = (XtArgVal)"Hide Clipboard";
			}
			XtSetValues(widget, arg, 1);
			break;
	}
}

void view_proc(w, closure, callData)
Widget w;
caddr_t closure;
caddr_t callData;
{
	int item = (int)callData;
	Arg arg[1];

	switch (item) {
		case 0:	/* By Icon */
			fprintf(stderr, "By Icon is selected\n");
			break;

		case 1:	/* By Name */
			fprintf(stderr, "By Name is selected\n");
			break;

		case 2:	/* By Size */
			fprintf(stderr, "By Size is selected\n");
			break;

		case 3:	/* By Data */
			fprintf(stderr, "By Data is selected\n");
			break;

		case 4:	/* By Kind */
			fprintf(stderr, "By Kind is selected\n");
			break;
		default:
			return;
	}
	if (current_view == item) {
		fprintf(stderr, "It is already selected\n");
		return;
	} else {
		arg[0].name = XtNselected;
		arg[0].value = (XtArgVal)FALSE;
		XtSetValues(view_items[current_view].widget, arg, 1);
		current_view = item;
		arg[0].value = (XtArgVal)TRUE;
		XtSetValues(view_items[current_view].widget, arg, 1);
	}

}

/********************************************************
*							*
*	Main program starts here			*
*							*
********************************************************/

void main(argc, argv)
unsigned int argc;
char **argv;
{
    Widget toplevel, box;

    toplevel = XtInitialize(argv[0], "SPdmenu", NULL, 0, &argc, argv);
    if (argc != 1) Syntax(argv[0]);

    box = XtCreateManagedWidget("box",boxWidgetClass,
					toplevel, NULL, 0);

    /* Create Menu Bar */
    menubar = XtCreateManagedWidget("menubar", sMenuWidgetClass,
					box, (ArgList)NULL, 0);

	/* Create Apple Menu */
	apple_menu = XtCreateManagedWidget(
			"apple", sPDMenuWidgetClass, menubar,
			(ArgList)apple_arg, XtNumber(apple_arg));

	/* Create File Menu */
	file_menu = XtCreateManagedWidget(
			"file", sPDMenuWidgetClass, menubar,
			(ArgList)file_arg, XtNumber(file_arg));

	/* Create Edit Menu */
	edit_menu = XtCreateManagedWidget(
			"edit", sPDMenuWidgetClass, menubar,
			(ArgList)edit_arg, XtNumber(edit_arg));

	/* Create View Menu */
	view_menu = XtCreateManagedWidget(
			"view", sPDMenuWidgetClass, menubar,
			(ArgList)view_arg, XtNumber(view_arg));
	current_view = 0;

	/* Create Special Menu */
	special_menu = XtCreateManagedWidget(
			"special", sPDMenuWidgetClass, menubar,
			(ArgList)NULL, 0);

	/* Create Window Menu */
	window_menu = XtCreateManagedWidget(
			"window", sPDMenuWidgetClass, menubar,
			(ArgList)NULL, 0);

	/* Create Pattern Menu */
	pattern_menu = XtCreateManagedWidget(
			"pattern", sPDMenuWidgetClass, menubar,
			(ArgList)NULL, 0);

	/* Create Others Menu */
	others_menu = XtCreateManagedWidget(
			"others", sPDMenuWidgetClass, menubar,
			(ArgList)NULL, 0);

	XtRealizeWidget(toplevel);
	XtMainLoop();
}
