/********************************************************
*							*
*	Test Program for SButton Widgets		*
*							*
*	Version 1.0	 4/ 5/88	M.Abe		*
*							*
********************************************************/

/********************************************************
*							*
*	Include definitions				*
*							*
********************************************************/

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Box.h>
#include <X11/SButton.h>

/********************************************************
*							*
*	Global variable					*
*							*
********************************************************/

SButtonWidget radio_button1;
SButtonWidget radio_button2;
SButtonWidget current_radio_button;

/********************************************************
*							*
*	Report the syntax error for calling button	*
*							*
********************************************************/

Syntax(call)
char *call;
{
	fprintf(stderr, "%s : Syntax error\n", call);
	exit(1);
}

/********************************************************
*							*
*	Call back procedure				*
*							*
********************************************************/

void normal(widget,closure,callData)
Widget widget;
caddr_t closure;
caddr_t callData;
{
	fprintf(stderr, "normal callback procedure\n");
}

void pushButton(widget,closure,callData)
Widget widget;
caddr_t closure;
caddr_t callData;
{
	SButtonWidget  bw = (SButtonWidget)widget;
	Arg arg[1];

	arg[0].name = XtNselected;
	arg[0].value = NULL;
	XtGetValues(bw, arg, 1);

	if (!arg[0].value) {
	    arg[0].value = (XtArgVal)FALSE;
	    XtSetValues(current_radio_button, arg, 1);

	    current_radio_button = bw;

	    arg[0].value = (XtArgVal)TRUE;
	    XtSetValues(current_radio_button, arg, 1);
	}
}

void trace(widget,closure,callData)
Widget widget;
caddr_t closure;
caddr_t callData;
{
	XEvent *event = (XEvent *)callData;

	switch (event->type) {
		case ButtonPress:
			fprintf(stderr, "Button Pressed\n");
			break;
		case ButtonRelease:
			fprintf(stderr, "Button Released\n");
			break;
		case MotionNotify:
			fprintf(stderr, "Mouse Moved %d\n", event->xbutton.subwindow);
			break;
	}
}

void toggle(widget,closure,callData)
Widget widget;
caddr_t closure;
caddr_t callData;
{
	SButtonWidget  bw = (SButtonWidget)widget;
	Arg arg[1];

	arg[0].name = XtNselected;
	arg[0].value = NULL;
	XtGetValues(bw, arg, 1);

	if (arg[0].value) {
		arg[0].value = (XtArgVal)FALSE;
	} else {
		arg[0].value = (XtArgVal)TRUE;
	}
	XtSetValues(bw, arg, 1);
}

/********************************************************
*							*
*	Main program starts here			*
*							*
********************************************************/

void main(argc, argv)
unsigned int argc;
char **argv;
{
	Widget toplevel, box;
	Widget normal_button;
	Widget quick_button;
	Widget unescapable_button;
	Widget live_button;
	Widget check_box;
	Widget close_box;
	Widget scroll_button;
	Widget resize_button;
	Widget small_icon;
	Arg arg[10];
	XEvent event;

	static char translation_table1[] =
		"<Btn1Down>: notify(always)";

	static char translation_table2[] =
		"<Btn1Down>: set() \n\
		<Btn1Up>: notify() unset() \n\
		<MouseMoved>: notify()";

	static char translation_table3[] =
		"<Btn1Down>: notify() \n\
		<EnterWindow>: set() \n\
		<LeaveWindow>: unset()";

	static char translation_table4[] =
		"<Btn1Down>: set() timeron() \n\
		<Btn1Up>: timeroff() notify() unset() \n\
		<EnterWindow>: highlight() timeron() \n\
		<LeaveWindow>: timeroff() unhighlight()";

	static XtCallbackRec normal_callback[] =
		{{normal, NULL}, {NULL, NULL}};
	static XtCallbackRec trace_callback[] =
		{{trace, NULL}, {NULL, NULL}};
	static XtCallbackRec select_callback[] =
		{{pushButton, NULL}, {NULL, NULL}};
	static XtCallbackRec toggle_callback[] =
		{{toggle, NULL}, {NULL, NULL}};

	static Arg normal_arg[] = {
		{ XtNcallback, (XtArgVal)normal_callback},
	};

	static Arg another_arg[] = {
		{ XtNcallback, (XtArgVal)normal_callback},
		{ XtNtranslations, (XtArgVal)NULL },
	};

	static Arg unescapable_button_arg[] = {
		{ XtNcallback, (XtArgVal)(caddr_t)trace_callback},
		{ XtNtranslations, (XtArgVal)NULL },
	};

	static Arg radio_button_arg[] = {
	    { XtNcallback, (XtArgVal)(caddr_t)select_callback},
	};

	static Arg toggle_arg[] = {
		{ XtNcallback, (XtArgVal)(caddr_t)toggle_callback},
	};


	toplevel = XtInitialize(argv[0], "SButtons",
						NULL, 0, &argc, argv);
	if (argc != 1) Syntax(argv[0]);

	box = XtCreateManagedWidget("buttonBox",
				boxWidgetClass, toplevel, NULL, 0);

		normal_button = XtCreateManagedWidget("normalButton",
			sButtonWidgetClass, box,
			(ArgList)normal_arg, XtNumber(normal_arg));

		another_arg[1].value =
		  (XtArgVal)XtParseTranslationTable(translation_table1);
		quick_button = XtCreateManagedWidget("quickButton",
			sButtonWidgetClass, box,
			(ArgList)another_arg, XtNumber(another_arg));

		unescapable_button_arg[1].value =
		  (XtArgVal)XtParseTranslationTable(translation_table2);
		unescapable_button = XtCreateManagedWidget(
			"unescapableButton", sButtonWidgetClass, box,
			(ArgList)unescapable_button_arg,
			XtNumber(unescapable_button_arg));

		another_arg[1].value =
		  (XtArgVal)XtParseTranslationTable(translation_table3);
		live_button = XtCreateManagedWidget("liveButton",
			sButtonWidgetClass, box,
			(ArgList)another_arg, XtNumber(another_arg));

		radio_button1 = (SButtonWidget)XtCreateManagedWidget(
			"radioButton1", sButtonWidgetClass, box,
			(ArgList)radio_button_arg,
			XtNumber(radio_button_arg));

		current_radio_button = radio_button1;

		radio_button2 = (SButtonWidget)XtCreateManagedWidget(
			"radioButton2", sButtonWidgetClass, box,
			(ArgList)radio_button_arg,
			XtNumber(radio_button_arg));

		check_box = XtCreateManagedWidget("checkBox",
			sButtonWidgetClass, box,
			(ArgList)toggle_arg,
			XtNumber(toggle_arg));

		close_box = XtCreateManagedWidget("closeBox",
			sButtonWidgetClass, box,
			(ArgList)normal_arg, XtNumber(normal_arg));

		another_arg[1].value =
		  (XtArgVal)XtParseTranslationTable(translation_table4);
		scroll_button = XtCreateManagedWidget("scrollButton",
			sButtonWidgetClass, box,
			(ArgList)another_arg,
			XtNumber(another_arg));

		resize_button = XtCreateManagedWidget("resizeButton",
			sButtonWidgetClass, box,
			(ArgList)normal_arg,
			XtNumber(normal_arg));
			
		small_icon = XtCreateManagedWidget("smallIcon",
			sButtonWidgetClass, box,
			(ArgList)toggle_arg,
			XtNumber(toggle_arg));

	XtRealizeWidget(toplevel);

	XtMainLoop();
}
