/*
 * Author:  Dan Heller (see Mailwatch.c for detailed info)
 */
#ifndef _XtMailwatchP_h
#define _XtMailwatchP_h

#include "Mailwatch.h"
#include <X11/CoreP.h>

#ifndef MAILBOX_DIRECTORY
#define MAILBOX_DIRECTORY "/usr/spool/mail"
#endif /* MAILBOX_DIRECTORY */
#define MAILBOX_VOLUME 33		/* percentage */

typedef struct {			/* new fields for mailwatch widget */
    Pixel	foreground_pixel;	/* color index of normal state fg */
    GC		normal_GC;		/* normal GC to use */
    GC		invert_GC;		/* invert GC to use */
    int		update;			/* seconds between updates */
    String	filename;		/* filename to watch */
    long	last_size;		/* size in bytes of mailboxname */
    time_t	last_access;		/* last time user accessed mailbox */
    Boolean	reverseVideo;		/* do reverse video? */
    Boolean	flag_up;		/* is the flag up? */
    String	mail;			/* author/subject/date info to "get" */
    String	flagup;			/* path to alternate icon to use */
    String	flagdown;		/* path to alternate icon to use */
    Pixmap	flagup_pixmap;		/* for when there is mail */
    Pixmap	flagdown_pixmap;	/* for when there isn't mail */
    XtCallbackList callback;		/* Call func(s) when mail arrives */
    XtIntervalId interval_id;		/* time between checks */
} MailwatchPart;

typedef struct _MailwatchRec {		/* full instance record */
    CorePart core;
    MailwatchPart mailbox;
} MailwatchRec;

typedef struct {			/* new fields for mailwatch class */
    int dummy;				/* stupid C compiler */
} MailwatchClassPart;

typedef struct _MailwatchClassRec {	/* full class record declaration */
    CoreClassPart core_class;
    MailwatchClassPart mailwatch_class;
} MailwatchClassRec;

extern MailwatchClassRec mailwatchClassRec;	 /* class pointer */

#endif _XtMailwatchP_h
