.TH DCLOCK 1 "1 March 1988" "X Version 11"
.SH NAME
dclock - digital clock for X
.SH SYNOPSIS
.B dclock
[-\fItoolkitoption\fP ...] [-option ...]
.SH DESCRIPTION
The
.I dclock 
program displays the time in digital format only.  The time is
updated on a per second basis or on a per minute basis.  This program is
nothing more than a wrapper around the dclock widget not associated with
the Athena Widget Set.
.sp
When the clock is running, the user may change attributes by typing:
.in +2
.nf
\fBr\fP\ \ Toggles \fBReverse Video\fP.
\fBs\fP\ \ Toggles the \fBseconds\fP display.
\fBb\fP\ \ Toggles the \fBbell\fP attribute (see below).
\fBj\fP\ \ Toggles the \fBjump/scroll\fP attribute (see below).
.in -2
.fi
.SH OPTIONS
.I Dclock
accepts all of the standard X Toolkit command line options along with the 
additional options listed below:
.TP 8
.B \-help
This option indicates that a brief summary of the allowed options should be
printed on the standard error.
.TP 8
.B \-bell
This option indicates that the beel will beep
once on the half hour and twice on the hour.
.TP 8
.B \-scroll
.br
.B \-noscroll
When the time changes, the digits scroll from the previous digit to the
next digit.  Since this is on by default, the -noscroll option can turn
it off.
.TP 8
.B \-date "format"
The date is printed under the time in the specified font.  The string
displayed is in the "format" argument.  If the string contains a formatting
character (%), then the next character is examined and a value is inserted
into the string.  Example:
.sp
.ti +2
dclock -date "Today is %W"
.sp
The date string will print "Today is Friday" if the weekday name happens
to be friday.  The formatting characters that are understood are:
.in +2
.nf
%W	Full weekday name
%w	Three-char weekday name (Sun, Mon, Tue...)
%M	Full month name
%m      Three-char abbreviation for that month (Jan, Feb, Mar...)
%d	The date (numerical day number of the month)
%Y	Full year (4 digits)
%y	2-digit year number
.fi
.in -2
.TP 8
.B \-seconds
This option will update the clock every second and display the time
including the seconds.
.TP 8
.B \-bg \fIcolor\fP
This option specifies the color to use for the background of the window.  
The default is ``white.''
.TP 8
.B \-bd \fIcolor\fP
This option specifies the color to use for the border of the window.
The default is ``black.''
.TP 8
.B \-bw \fInumber\fP
This option specifies the width in pixels of the border surrounding the window.
.TP 8
.B \-fg \fIcolor\fP
This option specifies the color to use for displaying text.  The default is 
``black''.
.TP 8
.B \-fn \fIfont\fP
This option specifies the font to be used for displaying normal text.  The
default is ``Fixed.''
.TP 8
.B \-rv
This option indicates that reverse video should be simulated by swapping
the foreground and background colors.
.TP 8
.B \-geometry \fIgeometry\fP
This option specifies the prefered size and position of the clock window.
.TP 8
.B \-display \fIhost\fP:\fIdisplay\fP
This option specifies the X server to contact.
.TP 8
.B \-xrm \fIresourcestring\fP
This option specifies a resource string to be used.  This is especially
useful for setting resources that do not have separate command line options.
.SH X DEFAULTS
It understands all of the core resource names and
classes as well as:
.PP
.TP 8
.B width (\fPclass\fB Width)
Specifies the width of the clock.
.TP 8
.B height (\fPclass\fB Height)
Specifies the height of the clock.
.TP 8
.B foreground (\fPclass\fB Foreground)
Specifies the color for the tic marks.  Using the class specifies the
color for all things that normally would appear in the foreground color.
The default is ``black'' since the core default for background is ``white.''
.TP 8
.B bell (\fPclass\fB Boolean)
Specifies whether or not a bell should be rung on the hour and half hour.
.TP 8
.B font (\fPclass\fB Font)
Specifies the font to be used for the date.
.TP 8
.B reverseVideo (\fPclass\fB ReverseVideo)
Specifies that the foreground and background colors should be reversed.
.TP 8
.B scroll (\fPclass\fB Boolean)
Specifies whether the digits should scroll or not.
.TP 8
.B seconds (\fPclass\fB Boolean)
Specifies whether the seconds should be displayed or not.
.TP 8
.B bell (\fPclass\fB Boolean)
Specifies whether the bell should sound on the half hour and on the hour.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH "SEE ALSO"
X(1), xrdb(1), time(3C).
.SH BUGS
.I Dclock
believes the system clock.
.PP
Scrolling from 9 to 10 O'Clock seems weird, but chances are you won't
notice it.
.PP
If the window is too small, the seconds are tough to read.  This should
be recognized by the program and should display seconds using a font
rather than the bitmaps used by the clock itself.
.PP
Color has been untested.
.SH COPYRIGHT
Copyright (c) 1988, Dan Heller.
.SH AUTHOR
.nf
Dan Heller -- <island!argv@sun.com> or <dheller@cory.berkeley.edu>
.fi
