/****************************************************************
 Header: io.c,v 1.30 87/06/10 20:02:11 sue Exp
 ****************************************************************
 * i/o functions
 *
 *   WriteToClient, ReadRequestFromClient
 *
 ****************************************************************/

#include <stdio.h>
#include "Xmd.h"
#include <errno.h>

#undef NULL
#include <sys\param.h>
/*
#include <sys\types.h>
*/
#include <sys\time.h>
#include "X.h"
#include "Xproto.h"
#include "os.h"
#include "osdep.h"
#include "opaque.h"
#include "ndixstruct.h"

extern long ClientsWithInput[];
extern long PartialRequest;
extern int errno;

static int timesThisConnection = 0;
struct ConnectionInput inputBuffers[MAXSOCKS]; 

#define request_length(req, cli) ((cli->swapped ? lswaps((req)->length) : (req)->length) << 2)
#define MAX_TIMES_PER         10

/* For sys\errno.h; same as MSC EDEADLOCK */
#define EWOULDBLOCK           36
#define EMSGSIZE              40

char *ReadRequestFromClient (who, status, oldbuf)
ClientPtr who;
int *status;          /* read at least n from client */
char *oldbuf;
{
    int client = ((osPrivPtr)who->osPrivate)->fd;
    int result, gotnow, needed;
    struct ConnectionInput *pBuff;
    register xReq *request;
 
   /* ignore oldbuf, just assume we're done with prev. buffer */
    if (client == -1) 
	return((char *)NULL);

    pBuff = &inputBuffers[client];
    pBuff->bufptr += pBuff->lenLastReq;
    pBuff->lenLastReq = 0;

    /* handle buffer empty or full case first */
    if ((pBuff->bufptr - pBuff->buffer >= pBuff->bufcnt) || (!pBuff->bufcnt))
    {
        result = read(client, pBuff->buffer, pBuff->size);
	if (result < 0) 
	{
/* EWOULDBLOCK not exist in MSC include/errno.h 
*/
	    if (errno == EWOULDBLOCK)
	        *status = 0;
	    else
	        *status = -1;
	    BITCLEAR(ClientsWithInput, client);
	    isItTimeToYield = TRUE;
	    return((char *)NULL);
	}
	else if (result == 0)
        {
	    BITCLEAR(ClientsWithInput, client);
	    isItTimeToYield = TRUE;
	    *status = -1;
            return((char *) NULL);
	}
	else 
	{
	    pBuff->bufcnt = result; 
	    pBuff->bufptr = pBuff->buffer;
	}
    }
    /* now look if there is enough in the buffer */
    request = (xReq *)pBuff->bufptr;
    gotnow = pBuff->bufcnt + pBuff->buffer - pBuff->bufptr;
    if (gotnow < sizeof(xReq))
        needed = sizeof(xReq) - gotnow;
    else
    {
        needed = request_length(request, who);
        if (needed > MAXBUFSIZE)
        {
    	    *status = -1;
	    BITCLEAR(ClientsWithInput, client);
	    isItTimeToYield = TRUE;
    	    return((char *)NULL);
        }
	if (needed <= 0)
            needed = sizeof(xReq);
    }
        /* if the needed amount won't fit in what's remaining,
	   move everything to the front of the buffer.  If the
	   entire header isn't available, move what's there too */
    if ((pBuff->bufptr + needed - pBuff->buffer > pBuff->size) ||
        (gotnow < sizeof(xReq)))
    {
        bcopy(pBuff->bufptr, pBuff->buffer, gotnow);
	pBuff->bufcnt = gotnow;
        if (needed > pBuff->size)
        {
	    pBuff->size = needed;
    	    pBuff->buffer = (char *)Xrealloc(pBuff->buffer, needed);
        }
        pBuff->bufptr = pBuff->buffer;
    }
               /* don't have a full header */
    if (gotnow < sizeof(xReq))
    {
	ErrorF(  "Don't have full header\n");
        while (pBuff->bufcnt + pBuff->buffer - pBuff->bufptr < sizeof(xReq))
	{
	    result = read(client, pBuff->buffer + pBuff->bufcnt, 
		      pBuff->size - pBuff->bufcnt); 
            pBuff->bufcnt += result;        
	}
        request = (xReq *)pBuff->bufptr;
        gotnow = pBuff->bufcnt + pBuff->buffer - pBuff->bufptr;
        needed = request_length(request, who);
	if (needed <= 0)
            needed = sizeof(xReq);
        if (needed > pBuff->size)
        {
	    pBuff->size = needed;
    	    pBuff->buffer = (char *)Xrealloc(pBuff->buffer, needed);
        }
        pBuff->bufptr = pBuff->buffer;
    }	

    if (gotnow < needed )   
    {
	int i, wanted;

	wanted = needed - gotnow;
	i = 0;
	while (i < wanted) 
	{
	    result = read(client, pBuff->buffer + pBuff->bufcnt, 
			  pBuff->size - pBuff->bufcnt); 
	    if (result < 0) 
	    {
		if (errno == EWOULDBLOCK)
		{
		    ErrorF( "2 WOULD BLOCK == %d\n", client);
		    *status = 0;
                }
		else
		    *status = -1;
		BITCLEAR(ClientsWithInput, client);
		isItTimeToYield = TRUE;
		return((char *)NULL);
	    }
	    else if (result == 0)
	    {
		*status = -1;
		BITCLEAR(ClientsWithInput, client);
		isItTimeToYield = TRUE;
		return((char *)NULL);
	    }
	    i += result;
    	    pBuff->bufcnt += result;
	}
    }
    *status = needed;
    pBuff->lenLastReq = needed;

    /*
     *  Check to see if client has at least one whole request in the
     *  buffer.  If there is only a partial request, treat like buffer
     *  is empty so that select() will be called again and other clients
     *  can get into the queue.   
     */
    if(pBuff->bufcnt + pBuff->buffer >= pBuff->bufptr + needed + sizeof(xReq))
    {
	request = (xReq *)(pBuff->bufptr + needed);
        if ((pBuff->bufcnt + pBuff->buffer) >= 
            ((char *)request + request_length(request, who)))
	    BITSET(ClientsWithInput, client);
        else
	{
	    BITCLEAR(ClientsWithInput, client);
	    isItTimeToYield = TRUE;
	}
    }
    else
    {
        BITCLEAR(ClientsWithInput, client);
	isItTimeToYield = TRUE;
    }
    if ((++timesThisConnection == MAX_TIMES_PER) || (isItTimeToYield))
    {
        isItTimeToYield = TRUE;
        timesThisConnection = 0;
    }
    return((char *)pBuff->bufptr);
}

/*****************
 * WriteToClient
 *    We might have to wait, if the client isn't keeping up with us.  We 
 *    wait for a short time, then close the connection.  This isn't a 
 *    wonderful solution,
 *    but it rarely seems to be a problem right now, and buffering output for
 *    asynchronous delivery sounds complicated and expensive.
 *    Long word aligns all data.
 *****************/

/* lookup table for adding padding bytes to data that is read from
   or written to the X socket.  */
static int padlength[4] = {0, 3, 2, 1};

int
WriteToClient (who, remaining, buf)
    ClientPtr who;
    char *buf;
    int remaining;
{
#define OUTTIME 30		/* 30 seconds */
    int connection = ((osPrivPtr)who->osPrivate)->fd;
    int bytesThisTime = remaining;
    register int n;
    int mask[mskcnt];
    struct timeval outtime;
    char pad[3];
    int len1;
    int secondTime = 0;

    outtime.tv_sec = (long) OUTTIME;
    outtime.tv_usec = 0;

    if (connection == -1) 
    {
	ErrorF( "OH NO, %d translates to -1\n", connection);
	return(-1);
    }

    if (connection == -2) 
    {
	ErrorF( "CONNECTION %d ON ITS WAY OUT\n", connection);
	return(-1);
    }
    while (1) 
    {   len1 = padlength[remaining & 3];
        n = write (connection, buf, bytesThisTime);
        if ((n = (write (connection, pad, len1) + n)) == remaining + len1)
	   return(remaining);
        if (n > 0) 
        {
	    buf += n;
	    remaining -= n;
	    if (remaining < bytesThisTime)
		bytesThisTime = remaining;
	}
        else if (errno == EMSGSIZE) /* buffer to big to write in one go */
	{
	     bytesThisTime >>= 1;
	     continue;
	}
	else if (errno != EWOULDBLOCK)
        {
	    ErrorF("Closing connection %d because write failed\n",connection);
            MarkClientException(who);
	    return(-1);
	}
 /* blocked => be willing to try him once more */
        ErrorF("Blocked, be willing to try write once more:\n");
        ErrorF("need to write: %d, have written: %d, eerno: %d\n", 
	       remaining, n, errno);
	CLEARBITS(mask);
	BITSET(mask, connection);
/*	n = select (connection + 1, (int *) NULL, mask, (int *) NULL, 
		&outtime);
*/	
        if ((n != 1) && (secondTime == 3))
        {
	    ErrorF("write failed after partial\n", connection);
            MarkClientException(who);
	    return(-1);
	}
        else
            secondTime++;
    }
}