/***********************************************************
 Bell Communications Research, David Chan; July 23 1987
 $Header: WaitFor.c,v 1.17 87/06/10 19:58:58 sue Exp $
 * OS Depedent input routines:
 *
 *  WaitForSomething,  GetEvent
 *
 *****************************************************************/

#include <stdio.h>
#include "X.h"
#include "misc.h"
#include <sys\param.h>
#include <signal.h>  /* IBM PC DOS only recognize SIGINT so disable signals */
#include "osdep.h"
#include "dixstruct.h"

extern long AllSockets[];
extern long AllClients[];
extern long LastSelectMask[];
extern long WellKnownConnections;
extern long EnabledDevices;
extern long ClientsWithInput[];
extern ClientPtr ConnectionTranslation[];

#define EBADF 9            /* bad file number; from <sys\errno.h> */

int CheckConnections();
extern int FirstClient;
extern int MaxClients;
extern int errno;

int isItTimeToYield = 1;  /* The PC gives up processing a client */

/*****************
 * WaitForSomething:
 *     Make the server suspend until there is data from clients or
 *     input or ddx notices something of interest (graphics
 *     queue ready, etc.) 
 *     For more info on ClientsWithInput, see ReadRequestFromClient().
 *     pClientsReady is a mask, the bits set are 
 *     indices into the o.s. depedent table of available clients.
 *     (In this case, there is no table -- the index is the socket
 *     file descriptor.)  
 *****************/

static int intervalCount = 0;

WaitForSomething(pClientsReady, nready, pNewClients, nnew)
    ClientPtr *pClientsReady;
    int *nready;
    ClientPtr *pNewClients;
    int *nnew;
{
    int i;
    long readyClients[mskcnt];
    long curclient;

    *nready = 0;
    *nnew = 0;
    CLEARBITS(readyClients);
    if (! (ANYSET(ClientsWithInput)))
    {
	/* We need a while loop here to handle 
	   crashed connections */
	while (1)
        {
      	   /* this needs to be modified */ 
            COPYBITS(AllSockets, LastSelectMask);
/*	    i = select (MAXSOCKS,LastSelectMask,(int *)NULL,(int *)NULL,NULL);
*/	
           if (i <= 0) /* An error or timeout occurred */
            {
		if ((i <0) && (errno == EBADF)) /* Some client disconnected */
	            CheckConnections ();
    	    }
	    else
	    {
		MASKANDSETBITS(readyClients, LastSelectMask, AllClients); 
		if (LastSelectMask[0] & WellKnownConnections) 
		   EstablishNewConnections(pNewClients, nnew);
		if (*nnew || (LastSelectMask[0] & EnabledDevices) 
		    || (ANYSET (readyClients)))
			    break;
	    }
	}
    }
    else
          COPYBITS(ClientsWithInput, readyClients);
   
    if (ANYSET(readyClients))
    {
	for (i=0; i<mskcnt; i++)
	{
	    while (readyClients[i])
	    {
/*		curclient = ffs (readyClients[i]) - 1;
*/
	     /* this is OS dependent; since pClientsReady is a mask to
                index (by bit sets) to socket file descriptors (avail clients)
             */
                pClientsReady[(*nready)++] = 
			ConnectionTranslation[curclient + (32 * i)];
		readyClients[i] &= ~(1 << curclient);
	    }
	}	
    }
}
