/****************************************************************************/
/* ptr_out.c -- X-WINDOW POINTER OUTPUT ROUTINES FOR IBM PC FAMILY	*/
/****************************************************************************/
/****************************************************************************/
#include "ptr_out.h"
#include "msmouse.h"
#include "bit.h"
#include <mp\bool.h>
#include <mp\dos.h>
/****************************************************************************/
/****************************************************************************/
Bool	RealizeCursor(ScreenPtr pScr, CursorPtr pCurs);
/****************************************************************************/
Bool	UnrealizeCursor(ScreenPtr pScr, CursorPtr pCurs);
/****************************************************************************/
Bool	DisplayCursor(ScreenPtr pScr, CursorPtr pCurs)
{
	COORD	dim;
	MSMCURSOR	msmcursor;
	MSMOUSE		msm;
	COORD	pos;
	/* COPY BITMAPS.  NOTE THAT ONLY AS MUCH OF THE UPPER-LEFT-HAND CORNER
	OF EACH BITMAP IS COPIED INTO msmcursor AS WILL FIT INTO dim.  ANY
	REMAINING PORTIONS, IF ANY, ARE LEFT AS 0 */

	dim.x=	16;
	dim.y=	16;
	memset(msmcursor,0,sizeof(msmcursor));
	/* FOR ALL BITS IN x & y DIRECTIONS... */
	for (pos.y= int_min(pCurs->height,dim.y);pos.y--;) {
		for (pos.x= int_min(pCurs->width,dim.x);pos.x--;) {
			BITPTR	bitptr=	bit_ptr(dim,pos);
			/* COPY 1 BIT OF CURSOR MASK */
			bit_write((BITARY)&(msmcursor.cursor),bitptr,
				bit_read((BITARY)(pCurs->source),bitptr));
			/* COPY 1 BIT OF SCREEN MASK */
			bit_write((BITARY)&(msmcursor.screen),bitptr,
				bit_read((BITARY)(pCurs->mask),bitptr));
		}
	}

	msm.func=	MSMOUSE_SETGRAPHICSCURSOR;
	msm.arg2=	int_min(pCurs->xhot,dim.x-1);	/* SHIFT THE HOTSPOT*/
	msm.arg3=	int_min(pCurs->yhot,dim.y-1);	/* INTO MASK IF NECC*/
	msm.arg4=	FP_OFF((char far *)&msmcursor);
	{
		unsigned	es=	_ES;
		_ES=		FP_SEG((char far *)&msmcursor);
		msmouse(&msm);
		_ES=		es;
	}
}
/****************************************************************************/
void	RecolorCursor(ScreenPtr pScr, CursorPtr pCurs) {
	/* DOES NOTHING AS MONOCHROME SCREEN: COLOR CHANGE HAS NO EFFECT */
	return;
}
/****************************************************************************/
void	ConstrainCursor(ScreenPtr pScr, BoxPtr pBox) {
	/* CONSTRAINS THE CURSOR TO A PARTICULAR BOX ON THE SCREEN */
	MSMOUSE	msm;

	msm.func=	MSMOUSE_SETMINANDMAXHORZ;
	msm.arg3=	pBox->x1;
	msm.arg4=	pBox->x2;
	msmouse(&msm);

	msm.func=	MSMOUSE_SETMINANDMAXVERT;
	msm.arg3=	pBox->y1;
	msm.arg4=	pBox->y2;
	msmouse(&msm);
}
/****************************************************************************/
void	PointerNonInterestBox(ScreenPtr pScr, BoxPtr pBox) {
	/* TURN OFF MOTION EVENTS FOR A PARTICULAR BOX -- NOT SUPPORTED */
	return;
}
/****************************************************************************/
void	CursorLimits(ScreenPtr pScr, CursorPtr pCurs, BoxPtr pHotBox, BoxPtr pTopLeftBox) {
	/* FOR NOW, THE CURSOR HOTSPOT HAS NO LIMTS.  RETURN THE SCREEN "BOX" */
	pTopLeftBox->x1=	0;
	pTopLeftBox->y1=	0;
	pTopLeftBox->x2=	pScr->width-1;
	pTopLeftBox->y2=	pScr->height-1;
}
/****************************************************************************/
Bool	SetCursorPosition(ScreenPtr pScr, unsigned int newx, unsigned int newy) {
	MSMOUSE	msm;
	if (!((newx < pScr->width) && (newy < pScr->height)))	return(FALSE);
	msm.func=	MSMOUSE_SETPOS;
	msm.arg3=	newx;
	msm.arg4=	newy;
	msmouse(&msm);
	return(TRUE);
}
/****************************************************************************/
/****************************************************************************/
/****************************************************************************/
