/****************************************************************************/
/* bit.h -- 2 DIMENSIONAL BIT ARRAY/BIT POINTER OPERATIONS		    */
/****************************************************************************/
/****************************************************************************/
#ifndef	_bit_h
#define	_bit_h
/****************************************************************************/
/****************************************************************************/
/****************************************************************************/
typedef	struct {
	short	x,y;
} COORD;
/****************************************************************************/
typedef char		*BITARY;	/* A POINTER TO A 2D ARRAY OF "BITS"*/
typedef	unsigned short	BITPTR;		/* A POINTER TO A BIT IN THE ARRAY  */
/****************************************************************************/
/****************************************************************************/
#define	bit_byte(bp)	((bp) >> 3)
#define	bit_bit(bp)	(0x01 << ((bp) & 0x0007))
/****************************************************************************/
/****************************************************************************/
#define	bit_read(base, bp)			\
		( (base)[bit_byte(bp)] & bit_bit(bp) )
/* READS THE STATUS OF THE BIT AT BITPTR bp IN BITARY base.
RETURNS 0 IFF OFF. */
/****************************************************************************/
#define	bit_write(base, bp, value) (				\
		(value)						\
		?( (base)[bit_byte(bp)]|= bit_bit(bp) )		\
		:( (base)[bit_byte(bp)]&= ~bit_bit(bp) )		\
	)
/* WRITES THE BIT AT BITPTR bp IN BITARY base ACCORDING TO value.
(OFF IFF value IS 0).  RETURNS NOTHING. */
/****************************************************************************/
/****************************************************************************/
#define	bit_ptr(dim, pos)	\
	((dim.x)*(pos.y)+(pos.x))
/* GIVEN A COORDINATE POSITION pos WITHIN AN ARRAY OF BITS OF DIMENSIONS dim,
RETURNS THE COORESPONDING BITPTR */
/****************************************************************************/
#define	bit_ptrdelta(dim, delta, bp)				\
	(	bp						\
		+						\
		delta.x						\
		+						\
		((delta.y)					\
			?((delta.y>0)				\
				?((delta.y==1)			\
					?(+dim.x)		\
					:(dim.x*delta.y))	\
				:((delta.y==-1)			\
					?(-dim.x)		\
					:(dim.x*delta.y))	\
			)					\
			:0					\
		)						\
	)							
/* GIVEN A BITPTR bp WITHIN A BIT ARRAY OF DIMENSION COORD dim, RETURNS
A NEW BITPTR SHIFTED BY COORD delta. */
/****************************************************************************/
/****************************************************************************/
/****************************************************************************/
#endif
		
