/*****************************************************************************/
/* bios.h - bios CALLS TO THE IBMPC BIOS ROUTINES */
/*****************************************************************************/
#ifndef	_bios_h
#define	_bios_h
/*****************************************************************************/
#include <mp\bool.h>
/*****************************************************************************/
/*****************************************************************************/
/*****************************************************************************/
/* bioskey */
/*****************************************************************************/
#define	BIOSKEY_GETKEYCODE		(0)
#define	BIOSKEY_KEYWAITING		(1)
#define	BIOSKEY_GETSHIFTSTATE		(2)

typedef	struct {
	unsigned	rightshift:	1;
	unsigned	leftshift: 	1;
	unsigned	ctrl: 		1;
	unsigned	alt:		1;
	unsigned	scrolllock:	1;
	unsigned	numlock:	1;
	unsigned	caps:		1;
	unsigned	insert:		1;
	unsigned	:		8;
} BIOSKEY_SHIFTSTATE;

BIOSKEY_SHIFTSTATE	bioskey_shiftstate(void);
/*****************************************************************************/
/*****************************************************************************/
/*****************************************************************************//*****************************************************************************/
/* biosvideo */
/*****************************************************************************/
void	biosvideo_setmode(unsigned char mode);
/*
EFFECTS:       CLEARS THE SCREEN AND SETS THE CURRENT VIDEO MODE:
		MODE	DIM	COLORS	CARDS
		text modes....
		0	40x25	2	CGA,EGA
		1	40x25	16/8	CGA,EGA
		2	80x25	2	CGA,EGA
		3	80x25	16/8	CGA,EGA
		graphics modes...
		4	320x200	4 of 16	CGA,EGA
		5	320x200	2	CGA,EGA
		6	640x200	2	CGA,EGA
		7	80x25	2	MONO
		BW MODES OPERATE THE SAME AS COLOR MODES, BUT COLOR
		BURST IS NOT ENABLED.
		CURSOR IS NOT DISPLAYED IN GRAPHICS MODES.
REQUIRES:	mode IS A LEGAL MODE NUMBER.
MODIFIES:	VIDEO STATE (HARDWARE)
*/

#define	EGAADDR		(MK_FP(0xB000,0))
#define	MONOADDR	(MK_FP(0xA000,0))
#define	CGAADDR		(MK_FP(0xA800,0))
#define	VGAADDR		(MK_FP(?,0))


BOOL	ram_isMEM(char *ptr);

#define	video_isEGA()	ram_isMEM(EGAADDR)
#define	video_isMONO()	ram_isMEM(MONOADDR)
#define	video_isCGA()	ram_isMEM(CGADDR)
#define	video_isVGA()	ram_isMEM(VGAADDR)

/*****************************************************************************/
/*****************************************************************************/
/*****************************************************************************/
#endif

