/* sxproto.h By: David K. Chan --- created for x\server\os to compile
   on Microsoft C to overcome stack overflow problem 
*/
#ifndef XPROTO_H
#define XPROTO_H

#include "Xmd.h"
#include "Xprotostr.h"

#define Window CARD32
#define Drawable CARD32
#define Font CARD32
#define Pixmap CARD32
#define Cursor CARD32
#define Colormap CARD32
#define GContext CARD32
#define Atom CARD32
#define VisualID CARD32
#define Time CARD32
#define KeyCode CARD8
#define KeySym CARD32
#define X_TCP_PORT 6000     /* add display number */
#define xTrue        1
#define xFalse       0

typedef CARD16 KeyButMask;

/***************** 
   connection setup structure.  This is followed by
   numRoots xWindowRoot structs.
*****************/
typedef struct {
    CARD8	byteOrder;
    BYTE	pad;
    CARD16	majorVersion , minorVersion ;
    CARD16	nbytesAuthProto ;	/* Authorization protocol */
    CARD16	nbytesAuthString ;	/* Authorization string */
    CARD16	pad2;
} xConnClientPrefix;

typedef struct {
    BOOL           success;
    BYTE           lengthReason; /*num bytes in string following if failure */
    CARD16         majorVersion , 
                   minorVersion ;
    CARD16         length ;  /* 1/4 additional bytes in setup info */
} xConnSetupPrefix;

typedef struct {
    CARD8          depth;
    CARD8          bitsPerPixel;
    CARD8          scanLinePad;
    CARD8          pad1;
    CARD32	   pad2 ;
} xPixmapFormat;

/* window root */
typedef struct {
    CARD8 	depth;
    CARD8 	pad1;
    CARD16	nVisuals ;  /* number of xVisualType structures following */
    CARD32	pad2 ;
    } xDepth;

typedef struct {
    VisualID visualID ;
    CARD8 class;
    CARD8 bitsPerRGB;
    CARD16 colormapEntries ;
    CARD32 redMask , greenMask , blueMask ;
    CARD32 pad ;
    } xVisualType;

typedef CARD8 KEYCODE;

/* KeymapNotify events are not included in the above union because they
   are different from all other events: they do not have a "detail"
   or "sequenceNumber", so there is room for a 248-bit key mask. */

typedef struct {
    BYTE type;
    BYTE map[31];
    } xKeymapEvent;

#define XEventSize (sizeof(xEvent))

/* restore these definitions back to the typedefs in X.h */
#undef Window
#undef Drawable
#undef Font
#undef Pixmap
#undef Cursor
#undef Colormap
#undef GContext
#undef Atom
#undef VisualID
#undef Time
#undef KeyCode
#undef KeySym

#endif /* XPROTO_H */

