/*
** Copyright 1988 Silicon Graphics Inc.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of SGI not be used in advertising
** or publicity pertaining to distribution of the software without specific,
** written prior permission.  SGI makes no representations about the
** suitability of this software for any purpose.  It is provided "as is"
** without express or implied warranty.
**
** SGI DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL SGI
** BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
** WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
** OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
** CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
**
** Author:  Michael Toy, SGI
*/

#include	"X.h"
#include	"windowstr.h"
#include	"propertyst.h"
#include	<Xatom.h>
#include	"cfb.h"
#include	"sgifb.h"
#include	"sgigl.h"

int	root_winid;	/* winid of the whole root */

PrivateWindowType(pWin)
WindowPtr pWin;
{
    if (pWin->parent)
	if (pWin->parent->parent)
	    return WT_SUBWINDOW;
	else
	    return WT_TOPLEVEL;
    return WT_ROOT;
}

/*
** Routines for switching between 4sight and X window management
*/

LoseGL(pWin)
    WindowPtr pWin;
{
    cfbPrivWin *pPrivWin;

    pPrivWin = (cfbPrivWin *)(pWin->devPrivate);
    if (PrivateWindowType(pWin) == WT_TOPLEVEL && pPrivWin->winID != NO_WID)
	GLwinclose(pPrivWin->winID);
    return WT_WALKCHILDREN;
}

GainX(pWin)
    WindowPtr	pWin;
{
    cfbPrivWin *pPrivWin;
    pPrivWin = (cfbPrivWin *)(pWin->devPrivate);
    pPrivWin->winID = root_winid;
    NakedWindow(pWin);
    return WT_WALKCHILDREN;
}


void
StartXWindowManager()
{
    extern WindowRec	WindowTable[];

    TraverseTree(&WindowTable[0], LoseGL, 0);
    GLrootopen();
    TraverseTree(&WindowTable[0], GainX, 0);
    miValidateTree (&WindowTable[0], WindowTable[0].firstChild, TRUE, FALSE);
    HandleExposures(&WindowTable[0]);
}

SGIWindowManager() { return (root_winid == 0); }

void
StopXWindowManager()
{
    /*
    ** Hack for now ...
    */
    FatalError("X Window Manager exited, so the server did too.");
}

/*
** Routines for extracting useful properties from the property lists
** of X windows.
*/

typedef struct {
    	long flags;	/* marks which fields in this structure are defined */
	int x, y;
	int width, height;
	int min_width, min_height;
	int max_width, max_height;
    	int width_inc, height_inc;
	struct {
		int x;	/* numerator */
		int y;	/* denominator */
	} min_aspect, max_aspect;
} XSizeHints;

/*
 * The next block of definitions are for window manager properties that
 * clients and applications use for communication.
 */

/* flags argument in size hints */
#define USPosition	(1L << 0) /* user specified x, y */
#define USSize		(1L << 1) /* user specified width, height */

#define PPosition	(1L << 2) /* program specified position */
#define PSize		(1L << 3) /* program specified size */
#define PMinSize	(1L << 4) /* program specified minimum size */
#define PMaxSize	(1L << 5) /* program specified maximum size */
#define PResizeInc	(1L << 6) /* program specified resize increments */
#define PAspect		(1L << 7) /* program specified min and max aspect ratios */
#define PAllHints (PPosition|PSize|PMinSize|PMaxSize|PResizeInc|PAspect)


char *WM_WinName(pWin)
    WindowPtr	pWin;
{
    PropertyPtr	prop;
    static char winname[80];
    int len;

    for (prop = pWin->userProps; prop; prop = prop->next)
	if (prop->propertyName == XA_WM_NAME) {
	    len = prop->size * (prop->format/8);
	    if (len > sizeof winname - 1)
		len = sizeof winname - 1;
	    strncpy(winname, prop->data, len);
	    winname[len] = 0;
	    return winname;
	}
    return NULL;
}

char *WM_IconName(pWin)
    WindowPtr	pWin;
{
    PropertyPtr	prop;
    static char iconname[80];
    int len;

    for (prop = pWin->userProps; prop; prop = prop->next)
	if (prop->propertyName == XA_WM_ICON_NAME) {
	    len = prop->size * (prop->format/8);
	    if (len > sizeof iconname - 1)
		len = sizeof iconname - 1;
	    strncpy(iconname, prop->data, len);
	    iconname[len] = 0;
	    return iconname;
	}
    return NULL;
}

void WM_WindowHints(pWin, pWinSize)
    WindowPtr	pWin;
    SGIWinSize	*pWinSize;
{
    PropertyPtr	prop;
    XSizeHints *sh;
    int	border;

    memset(pWinSize, 0, sizeof *pWinSize);
    border = pWin->borderWidth;
    pWinSize->xorg = pWin->clientWinSize.x;
    pWinSize->yorg = pWin->clientWinSize.y;
    pWinSize->width = pWin->clientWinSize.width;
    pWinSize->height = pWin->clientWinSize.height;
    pWinSize->override = pWin->overrideRedirect ? 1 : 0;
    for (prop = pWin->userProps; prop; prop = prop->next)
	switch (prop->propertyName) {
	    case XA_WM_TRANSIENT_FOR:
		pWinSize->is_popup = 1;
		break;
	    case XA_WM_NORMAL_HINTS:
		if (pWinSize->override)
		    break;
		sh = (XSizeHints *) prop->data;
		if (sh->flags & (USSize|PSize)) {
		    pWinSize->width = sh->width;
		    pWinSize->height = sh->height;
		}
		if (sh->flags & (USPosition|PPosition)) {
		    pWinSize->xorg = sh->x;
		    pWinSize->yorg = sh->y;
		    pWinSize->has_preforigin = 1;
		}
		if (sh->flags & PMaxSize) {
		    pWinSize->maxx = sh->max_width;
		    pWinSize->maxy = sh->max_height;
		    pWinSize->has_maxsize = 1;
		}
		if (sh->flags & PMinSize) {
		    pWinSize->minx = sh->min_width;
		    pWinSize->miny = sh->min_height;
		    pWinSize->has_minsize = 1;
		}
		if (sh->flags & PResizeInc) {
		    pWinSize->stepx = sh->width_inc;
		    pWinSize->stepy = sh->height_inc;
		    pWinSize->has_stepunit = 1;
		}
		if (sh->flags & PAspect) {
		    pWinSize->aspectx = sh->max_aspect.x;
		    pWinSize->aspecty = sh->max_aspect.y;
		    pWinSize->has_aspect = 1;
		}
		break;
	    }
    pWinSize->xorg -= border;
    pWinSize->width += 2*border;
    pWinSize->height += 2*border;
    pWinSize->yorg = SGI_Y(pWinSize->yorg - border + pWinSize->height - 1);
    pWinSize->pXWin = (XWinPointer) pWin;
}
