/*
** Copyright 1988 Silicon Graphics Inc.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of SGI not be used in advertising
** or publicity pertaining to distribution of the software without specific,
** written prior permission.  SGI makes no representations about the
** suitability of this software for any purpose.  It is provided "as is"
** without express or implied warranty.
**
** SGI DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL SGI
** BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
** WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
** OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
** CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
**
** Author:  Michael Toy, SGI
*/

#include "X.h"
#define	NEED_EVENTS
#include "Xproto.h"
#include "scrnintstr.h"
#include "cursorstr.h"
#include "colormapst.h"
#include "windowstr.h"
#include "input.h"
#include "dix.h"

#include <sys/types.h>

#include "sgifb.h"
#include "sgigl.h"
#include "cfb.h"


#ifdef X4D
#define DPI 96
#else
#define DPI 72
#endif

extern void VoidNoop();
extern int TrueNoop(), FalseNoop();
extern Bool sgiDisplayCursor();
extern void sgiRecolorCursor(), sgiCursorLimits();

/*
** Make X's colormap match the current GL colormap
*/

void
sgiCreateColormap(pCmap)
    ColormapPtr	pCmap;
{
    Pixel	color;
    short	Red, Green, Blue;
    xColorItem	def;

    if (pCmap->flags & BeingCreated)
	for (color = 0; color < 256; color++) {
	    getmcolor(color, &Red, &Green, &Blue);
	    Red <<= 8;
	    Green <<= 8;
	    Blue <<= 8;
	    pCmap->red[color].co.local.red = Red;
	    pCmap->red[color].co.local.green = Green;
	    pCmap->red[color].co.local.blue = Blue;
	}
}


/*-
 *-----------------------------------------------------------------------
 * sunQueryBestSize --
 *	Supposed to hint about good sizes for things.
 *
 * Results:
 *	Perhaps change *pwidth (Height irrelevant)
 *
 * Side Effects:
 *	None.
 *
 *-----------------------------------------------------------------------
 */
/*ARGSUSED*/
void
sunQueryBestSize(class, pwidth, pheight)
int class;
short *pwidth;
short *pheight;
{
    unsigned width, test;

    switch(class)
    {
      case CursorShape:
      case TileShape:
      case StippleShape:
	  width = *pwidth;
	  if (width > 0) {
	      /* Return the closes power of two not less than what they gave me */
	      test = 0x80000000;
	      /* Find the highest 1 bit in the width given */
	      while(!(test & width))
		 test >>= 1;
	      /* If their number is greater than that, bump up to the next
	       *  power of two */
	      if((test - 1) & width)
		 test <<= 1;
	      *pwidth = test;
	  }
	  /* We don't care what height they use */
	  break;
    }
}

Bool
sgiScreenInit(index, pScr, argc, argv)
    int index;
    ScreenPtr pScr;
    int argc;
    char **argv;
{
    int retval = TRUE;
    register int i;
    static char firsttime = 1;
    ColormapPtr	cmap;

    if (firsttime) {
	firsttime = 0;
	GLginit();
    }

    pScr->CreateColormap = sgiCreateColormap;
    retval = cfbScreenInit(index, pScr, 0, SGI_WIDTH, SGI_HEIGHT, DPI);

    pScr->CloseScreen = TrueNoop;
    pScr->SaveScreen = FalseNoop;

    pScr->ConstrainCursor = VoidNoop;
    pScr->CursorLimits = sgiCursorLimits;
    pScr->DisplayCursor = sgiDisplayCursor;
    pScr->RealizeCursor = TrueNoop;
    pScr->UnrealizeCursor = FalseNoop;
    pScr->RecolorCursor = sgiRecolorCursor;
    pScr->SetCursorPosition = TrueNoop;
    pScr->PointerNonInterestBox = VoidNoop;
    pScr->QueryBestSize = sunQueryBestSize;

    pScr->StoreColors = VoidNoop;
    pScr->ResolveColor = VoidNoop;
    pScr->whitePixel = 7;
    pScr->blackPixel = 0;
    cmap = (ColormapPtr)LookupID(pScr->defColormap, RT_COLORMAP, RC_CORE);
    cfbInstallColormap(cmap);
    return(retval);
}

NakedWindow(pWin, arg)
    WindowPtr	pWin;
{
    ScreenPtr	pScreen = pWin->drawable.pScreen;

    if (pWin->mapped && pWin->realized) {
	(* pScreen->RegionCopy) (pWin->borderExposed, pWin->borderSize);
	(* pScreen->RegionCopy) (pWin->exposed, pWin->winSize);
	return WT_WALKCHILDREN;
    } else
	return WT_DONTWALKCHILDREN;
}

RedrawGLWindow(wid)
{
    WindowPtr	pWin = (WindowPtr) _WinPtr(wid);
    cfbPrivWin	*pPrivWin = (cfbPrivWin *)(pWin->devPrivate);

    if (winChanged & CHANGED_SIZE)
	SlideAndSizeWindow(pWin, newX, newY, newW, newH, pWin->nextSib);
    else if (winChanged & CHANGED_POSITION)
	MoveWindow(pWin, newX, newY, pWin->nextSib);
    TraverseTree(pWin, NakedWindow, 0);
    HandleExposures(pWin);
}

KillGLWindow(wid)
{
    WindowPtr	pWin = (WindowPtr) _WinPtr(wid);
    cfbPrivWin	*pPrivWin = (cfbPrivWin *)(pWin->devPrivate);

    CloseDownClient(pWin->client);
}

/*
** Called in response to a depth change events, re-stacks the top level
** windows according to their windepth()'s
*/

WinCmp(pwp1, pwp2)
    WindowPtr	*pwp1, *pwp2;
{
    cfbPrivWin	*pPriv1 = (cfbPrivWin *)((*pwp1)->devPrivate),
		*pPriv2 = (cfbPrivWin *)((*pwp2)->devPrivate);
    int depth1 = 999, depth2 = 999;

    if (pPriv1->winID != NO_WID)
	depth1 = windepth(pPriv1->winID);
    if (pPriv2->winID != NO_WID)
	depth2 = windepth(pPriv2->winID);
    return depth1 - depth2;
}
    
RestackGLWindows()
{
    extern WindowRec	WindowTable[];
    WindowPtr		AllWindows[256],
			pPrev,
			pWin;
    int			nWin = 0,
			cnt = 0;

    for (pWin = WindowTable[0].firstChild; pWin; pWin = pWin->nextSib)
	AllWindows[nWin++] = pWin;
    AllWindows[nWin] = NullWindow;
    qsort(AllWindows, nWin, sizeof pWin, WinCmp);
    WindowTable[0].firstChild = AllWindows[0];
    WindowTable[0].lastChild = AllWindows[nWin - 1];
    for (pWin = AllWindows[0], pPrev = NullWindow; cnt++ < nWin; ) {
	pWin->prevSib = pPrev;
	pWin->nextSib = AllWindows[cnt];
	pPrev = pWin;
	pWin = AllWindows[cnt];
    }
#ifdef DEBUG
    if (AllWindows[0]) {
	sgiBeginWindowDraw(AllWindows[0]);
	wintitle("X -- Top");
    }
    if (nWin > 1) {
	sgiBeginWindowDraw(AllWindows[nWin-1]);
	wintitle("X -- bottom");
    }
#endif
}

_WinBorder(pWin) WindowPtr pWin; { return pWin->borderWidth; }
