/*
** Copyright 1988 Silicon Graphics Inc.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of SGI not be used in advertising
** or publicity pertaining to distribution of the software without specific,
** written prior permission.  SGI makes no representations about the
** suitability of this software for any purpose.  It is provided "as is"
** without express or implied warranty.
**
** SGI DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL SGI
** BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
** WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
** OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
** CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
**
** Author:  Michael Toy, SGI
*/

#include	"X.h"
#include	"Xmd.h"
#include	"Xproto.h"
#include	"input.h"
#include	"sgifb.h"

/*
** Most of the initialzation for the mouse is done in
** sgiKeyBd.c
*/
 
/*-
 *-----------------------------------------------------------------------
 * sgiMouseControl --
 *	Alter the control parameters for the mouse. Since acceleration
 *	etc. is done from the PtrCtrl record in the mouse's device record,
 *	there's nothing to do here.
 *
 * Results:
 *	None.
 *
 * Side Effects:
 *	None.
 *
 *-----------------------------------------------------------------------
 */
static void
sgiMouseControl (pMouse)
    DevicePtr	  pMouse;
{
}

/*-
 *-----------------------------------------------------------------------
 * sgiMouseGetMotionEvents --
 *	Return the (number of) motion events in the "motion history
 *	buffer" (snicker) between the given times.
 *
 * Results:
 *	The number of events stuffed.
 *
 * Side Effects:
 *	The relevant xTimecoord's are stuffed in the passed memory.
 *
 *-----------------------------------------------------------------------
 */
static int
sgiMouseGetMotionEvents (buff, start, stop)
    CARD32 start, stop;
    xTimecoord *buff;
{
    return 0;
}


int
sgiMouseProc (pMouse, what)
    DevicePtr	  pMouse;	/* Pointer to mouse device */
    int	    	  what;	    	/* What to do to it */
{
    BYTE	map[4];
    extern struct MsPrivate MsPrivate;

    switch (what) {
	case DEVICE_INIT:
	    /*
	    ** I don't know why I am doing this
	    */
	    map[1] = 1;
	    map[2] = 2;
	    map[3] = 3;

	    pMouse->devicePrivate = (pointer) &MsPrivate;
	    InitPointerDeviceStruct(
		    pMouse,
		    map,
		    3,
		    sgiMouseGetMotionEvents,
		    sgiMouseControl);
	    break;

	case DEVICE_ON:
	    break;

	case DEVICE_CLOSE:
	case DEVICE_OFF:
	    break;
    }
    return (Success);
}
