/*
** Copyright 1988 Silicon Graphics Inc.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of SGI not be used in advertising
** or publicity pertaining to distribution of the software without specific,
** written prior permission.  SGI makes no representations about the
** suitability of this software for any purpose.  It is provided "as is"
** without express or implied warranty.
**
** SGI DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL SGI
** BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
** WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
** OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
** CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
**
** Author:  Michael Toy, SGI
*/

/*
 * SGI X Key Map
 */

#include	"X.h"
#include	"Xmd.h"
#include	"keysym.h"
#include	"input.h"
#include	"sgifb.h"
#include	<gl/device.h>

static KeySym sgiKbd4D[] = {
	XK_Control_L,	NoSymbol,	/*   3 */
	XK_Caps_Lock,	NoSymbol,	/*   4 */
	XK_Shift_R,	NoSymbol,	/*   5 */
	XK_Shift_L,	NoSymbol,	/*   6 */
	XK_Escape,	NoSymbol,	/*   7 */
	XK_1,		XK_exclam,	/*   8 */
	XK_Tab,		NoSymbol,	/*   9 */
	XK_Q,		NoSymbol,	/*  10 */
	XK_A,		NoSymbol,	/*  11 */
	XK_S,		NoSymbol,	/*  12 */
	NoSymbol,	NoSymbol,	/*  13 */
	XK_2,		XK_at,		/*  14 */
	XK_3,		XK_numbersign,	/*  15 */
	XK_W,		NoSymbol,	/*  16 */
	XK_E,		NoSymbol,	/*  17 */
	XK_D,		NoSymbol,	/*  18 */
	XK_F,		NoSymbol,	/*  19 */
	XK_Z,		NoSymbol,	/*  20 */
	XK_X,		NoSymbol,	/*  21 */
	XK_4,		XK_dollar,	/*  22 */
	XK_5,		XK_percent,	/*  23 */
	XK_R,		NoSymbol,	/*  24 */
	XK_T,		NoSymbol,	/*  25 */
	XK_G,		NoSymbol,	/*  26 */
	XK_H,		NoSymbol,	/*  27 */
	XK_C,		NoSymbol,	/*  28 */
	XK_V,		NoSymbol,	/*  29 */
	XK_6,		XK_asciicircum,	/*  30 */
	XK_7,		XK_ampersand,	/*  31 */
	XK_Y,		NoSymbol,	/*  32 */
	XK_U,		NoSymbol,	/*  33 */
	XK_J,		NoSymbol,	/*  34 */
	XK_K,		NoSymbol,	/*  35 */
	XK_B,		NoSymbol,	/*  36 */
	XK_N,		NoSymbol,	/*  37 */
	XK_8,		XK_asterisk,	/*  38 */
	XK_9,		XK_parenleft,	/*  39 */
	XK_I,		NoSymbol,	/*  40 */
	XK_O,		NoSymbol,	/*  41 */
	XK_L,		NoSymbol,	/*  42 */
	XK_semicolon,	XK_colon,	/*  43 */
	XK_M,		NoSymbol,	/*  44 */
	XK_comma,       XK_less,	/*  45 */
	XK_0,		XK_parenright,	/*  46 */
	XK_minus,	XK_underscore,	/*  47 */
	XK_P,		NoSymbol,	/*  48 */
	XK_bracketleft,	XK_braceleft,	/*  49 */
	XK_quoteright,	XK_quotedbl,	/*  50 */
	XK_Return,	NoSymbol,	/*  51 */
	XK_period,	XK_greater,	/*  52 */
	XK_slash,	XK_question,	/*  53 */
	XK_equal,	XK_plus,	/*  54 */
	XK_quoteleft,	XK_asciitilde,	/*  55 */
	XK_bracketright,XK_braceright,	/*  56 */
	XK_backslash,	XK_bar,		/*  57 */
	XK_KP_1,	XK_End,		/*  58 */
	XK_KP_0,	XK_Insert,	/*  59 */
	NoSymbol,	NoSymbol,	/*  60 */
	XK_BackSpace,	NoSymbol,	/*  61 */
	XK_Delete,	NoSymbol,	/*  62 */
	XK_KP_4,	XK_Left,	/*  63 */
	XK_KP_2,	XK_Down,	/*  64 */
	XK_KP_3,	XK_Next,	/*  65 */
	XK_KP_Separator,XK_Delete,	/*  66 */
	XK_KP_7,	XK_Home,	/*  67 */
	XK_KP_8,	XK_Up,		/*  68 */
	XK_KP_5,	NoSymbol,	/*  69 */
	XK_KP_6,	XK_Right,	/*  70 */
	NoSymbol,	NoSymbol,	/*  71 */
	NoSymbol,	NoSymbol,	/*  72 */
	XK_Left,	NoSymbol,	/*  73 */
	XK_Down,	NoSymbol,	/*  74 */
	XK_KP_9,	XK_Prior,	/*  75 */
	XK_KP_Subtract,	NoSymbol,	/*  76 */
	NoSymbol,	NoSymbol,	/*  77 */
	NoSymbol,	NoSymbol,	/*  78 */
	NoSymbol,	NoSymbol,	/*  79 */
	XK_Right,	NoSymbol,	/*  80 */
	XK_Up,		NoSymbol,	/*  81 */
	XK_KP_Enter,	NoSymbol,	/*  82 */
	XK_space,	NoSymbol,	/*  83 */
	NoSymbol,	NoSymbol,	/*  84 */
	NoSymbol,	NoSymbol,	/*  85 */
	NoSymbol,	NoSymbol,	/*  86 */
	NoSymbol,	NoSymbol,	/*  87 */
	NoSymbol,	NoSymbol,	/*  88 */
	NoSymbol,	NoSymbol,	/*  89 */
	NoSymbol,	NoSymbol,	/*  90 */
	NoSymbol,	NoSymbol,	/*  91 */
	NoSymbol,	NoSymbol,	/*  92 */
	NoSymbol,	NoSymbol,	/*  93 */
	NoSymbol,	NoSymbol,	/*  94 */
	NoSymbol,	NoSymbol,	/*  95 */
	NoSymbol,	NoSymbol,	/*  96 */
	NoSymbol,	NoSymbol,	/*  97 */
	NoSymbol,	NoSymbol,	/*  98 */
	NoSymbol,	NoSymbol,	/*  99 */
	NoSymbol,	NoSymbol,	/* 100 */
	NoSymbol,	NoSymbol,	/* 101 */
	NoSymbol,	NoSymbol,	/* 102 */
	NoSymbol,	NoSymbol,	/* 103 */
	NoSymbol,	NoSymbol,	/* 104 */
	NoSymbol,	NoSymbol,	/* 105 */
	NoSymbol,	NoSymbol,	/* 106 */
	NoSymbol,	NoSymbol,	/* 107 */
	NoSymbol,	NoSymbol,	/* 108 */
	NoSymbol,	NoSymbol,	/* 109 */
	NoSymbol,	NoSymbol,	/* 110 */
	NoSymbol,	NoSymbol,	/* 111 */
	NoSymbol,	NoSymbol,	/* 112 */
	NoSymbol,	NoSymbol,	/* 113 */
	NoSymbol,	NoSymbol,	/* 114 */
	NoSymbol,	NoSymbol,	/* 115 */
	NoSymbol,	NoSymbol,	/* 116 */
	NoSymbol,	NoSymbol,	/* 117 */
	NoSymbol,	NoSymbol,	/* 118 */
	NoSymbol,	NoSymbol,	/* 119 */
	NoSymbol,	NoSymbol,	/* 120 */
	NoSymbol,	NoSymbol,	/* 121 */
	NoSymbol,	NoSymbol,	/* 122 */
	NoSymbol,	NoSymbol,	/* 123 */
	NoSymbol,	NoSymbol,	/* 124 */
	NoSymbol,	NoSymbol,	/* 125 */
	NoSymbol,	NoSymbol,	/* 126 */
	NoSymbol,	NoSymbol,	/* 127 */
	NoSymbol,	NoSymbol,	/* 128 */
	NoSymbol,	NoSymbol,	/* 129 */
	NoSymbol,	NoSymbol,	/* 130 */
	NoSymbol,	NoSymbol,	/* 131 */
	NoSymbol,	NoSymbol,	/* 132 */
	NoSymbol,	NoSymbol,	/* 133 */
	NoSymbol,	NoSymbol,	/* 134 */
	NoSymbol,	NoSymbol,	/* 135 */
	NoSymbol,	NoSymbol,	/* 136 */
	NoSymbol,	NoSymbol,	/* 137 */
	NoSymbol,	NoSymbol,	/* 138 */
	NoSymbol,	NoSymbol,	/* 139 */
	NoSymbol,	NoSymbol,	/* 140 */
	NoSymbol,	NoSymbol,	/* 141 */
	NoSymbol,	NoSymbol,	/* 142 */
	XK_Alt_L,	NoSymbol,	/* 143 */
	XK_Alt_R,	NoSymbol,	/* 144 */
	XK_Control_R,	NoSymbol,	/* 145 */
	XK_F1,		NoSymbol,	/* 146 */
	XK_F2,		NoSymbol,	/* 147 */
	XK_F3,		NoSymbol,	/* 148 */
	XK_F4,		NoSymbol,	/* 149 */
	XK_F5,		NoSymbol,	/* 150 */
	XK_F6,		NoSymbol,	/* 151 */
	XK_F7,		NoSymbol,	/* 152 */
	XK_F8,		NoSymbol,	/* 153 */
	XK_F9,		NoSymbol,	/* 154 */
	XK_F10,		NoSymbol,	/* 155 */
	XK_F11,		NoSymbol,	/* 156 */
	XK_F12,		NoSymbol,	/* 157 */
	XK_Print,	NoSymbol,	/* 158 */
	XK_Pause,	NoSymbol,	/* 159 */
	XK_Pause,	NoSymbol,	/* 160 */
	XK_Insert,	NoSymbol,	/* 161 */
	XK_Home,	NoSymbol,	/* 162 */
	XK_Prior,	NoSymbol,	/* 163 */
	XK_End,		NoSymbol,	/* 164 */
	XK_Next,	NoSymbol,	/* 165 */
	NoSymbol,	NoSymbol,	/* 166 */
	XK_KP_Divide,	NoSymbol,	/* 167 */
	XK_KP_Multiply,	NoSymbol,	/* 168 */
	XK_KP_Add,	NoSymbol	/* 169 */
};

KeySymsRec sgiKeySyms[] = {
    /*	map	   minKeyCode	maxKC	width */
    (KeySym *)NULL,	0,	0,	0,
    sgiKbd4D,		3,	169,	2,
};

void
sgiMakeModMap(type, map, off)
    int type;
    CARD8	*map;
    int off;
{
    memset(map, 0, MAP_LENGTH);
    map += off;
    map[LEFTCTRLKEY] = ControlMask;
    map[CAPSLOCKKEY] = LockMask;
    map[RIGHTSHIFTKEY] = ShiftMask;
    map[LEFTSHIFTKEY] = ShiftMask;
    if (type == KB_SGI4D) {
	map[RIGHTCTRLKEY] = ControlMask;
	map[LEFTALTKEY] = Mod1Mask;
	map[RIGHTALTKEY] = Mod1Mask;
    }
}
