/*
** Copyright 1988 Silicon Graphics Inc.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation, and that the name of SGI not be used in advertising
** or publicity pertaining to distribution of the software without specific,
** written prior permission.  SGI makes no representations about the
** suitability of this software for any purpose.  It is provided "as is"
** without express or implied warranty.
**
** SGI DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL SGI
** BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
** WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
** OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
** CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
**
** Author:  Michael Toy, SGI
*/


#include	"X.h"
#include	"Xproto.h"
#include	"Xprotostr.h"
#include	"miscstruct.h"
#include	"windowstr.h"
#include	"gcstruct.h"
#include	"regionstr.h"
#include	"cfb.h"
#include	"fontstruct.h"
#include	"dixfontstr.h"
#include	"sgifb.h"
#include	"sgigl.h"
#include	<gl/bitmap.h>
#include	<assert.h>

int ForceDrawToLoad;

void
sgiPolylines(pWin, pGC, mode, nPt, pPt)
    WindowPtr	pWin;
    GCPtr	pGC;
    int		mode,
		nPt;
    DDXPointPtr	pPt;
{
    register int x, y, xorg, yorg;

    xorg = pWin->absCorner.x;
    yorg = pWin->absCorner.y;

    x = pPt->x + xorg;
    y = pPt->y + yorg;
    pPt++;
    if (sgiStartDraw(pGC, pWin))
	return;
    GLmoveto(x, y);
    while(--nPt > 0) {
	if (mode == CoordModeOrigin)
	    GLlineto(pPt->x + xorg, pPt->y + yorg);
	else
	    GLlineto(x += pPt->x, y += pPt->y);
    }
    sgiEndDraw(pGC, pWin);
}

void
sgiPolyFillRect(pWin, pGC, nRect, pRect)
    WindowPtr	pWin;
    GCPtr	pGC;
    int		nRect;
    xRectangle	*pRect;
{
    register int xorg, yorg;

    xorg = pWin->absCorner.x;
    yorg = pWin->absCorner.y;
    if (sgiStartDraw(pGC, pWin))
	return;
    for (; nRect-- > 0; pRect++)
	GLrectfill(pRect->x+xorg, pRect->y+yorg, pRect->width, pRect->height);
    sgiEndDraw(pGC, pWin);
}

/*
** sgiBeginWindowDraw -- Called before imaging into a window to make sure that
** the passed window is the current window.
**
** RETURNS
**	1 if now drawing should be done
**	0 otherwise
*/

sgiBeginWindowDraw(pWin)
    WindowPtr pWin;
{
    cfbPrivWin	*pPrivWin = (cfbPrivWin *)(pWin->devPrivate);
    register WindowPtr	pTopWin;
    register int	myWinID, border;

    /*
    ** From this window until we get to a top level window, look for an
    ** ancestor who knows what the winID should be, and save the winID when
    ** we find it.
    */
    for (pTopWin = pWin; pTopWin; pTopWin = pTopWin->parent)
	if (((cfbPrivWin *) (pTopWin->devPrivate))->winID != NO_WID)
	    break;
    if (pTopWin == NullWindow
	|| (myWinID = ((cfbPrivWin *) (pTopWin->devPrivate))->winID) == NO_WID)
	/*
	** We are either part of an unmapped tree, or we are a root window,
	** in either case there is no drawing to do.
	*/
	return 1;
    pPrivWin->winID = myWinID;
    GLwinset(myWinID);
    return 0;
}

sgiStartDraw(pGC, pWin)
    GCPtr	pGC;
    WindowPtr	pWin;
{
    register RegionPtr	pClip = ((cfbPrivGCPtr) (pGC->devPriv))->pCompositeClip;

    if (pClip->numRects == 0 || sgiBeginWindowDraw(pWin))
	return 1;
    GLcolor(pGC->fgPixel);
    if (pGC->planemask != ~0L)
	GLwritemask(pGC->planemask);
    if (pClip->numRects > 1)
	GLmakeobj();
    else {
	BoxPtr	pbox = pClip->rects;
	GLscrmask(pbox->x1, pbox->y1, pbox->x2-pbox->x1, pbox->y2-pbox->y1);
    }
    return 0;
}

sgiEndDraw(pGC, pWin)
    GCPtr	pGC;
    WindowPtr	pWin;
{
    RegionPtr	pClip = ((cfbPrivGCPtr) (pGC->devPriv))->pCompositeClip;
    BoxPtr	pbox;
    int		nbox;

    if ((nbox = pClip->numRects) > 1) {
	GLcloseobj();
	for (pbox = pClip->rects; nbox-- > 0; pbox++) {
	    GLscrmask(pbox->x1, pbox->y1, pbox->x2-pbox->x1, pbox->y2-pbox->y1);
	    GLcallobj();
	}
    }
    GLfixscrmask();
    if (pGC->planemask != ~0L)
	GLwritemask(~0L);
}

/*
** Here are the speed burners, routines which, given the right circumstances
** can draw the characters on the scren using local fast bitmap mode.
*/

void
InvertGlyph(pci, base)
CharInfoPtr	pci;
unsigned char	*base;
{
    register	short *top, *bottom, tmp;
    register	int x, y, ysize, sper;

    pci->inverted = !pci->inverted;
    top = (short *) (base + pci->byteOffset);
    sper = (pci->metrics.rightSideBearing-pci->metrics.leftSideBearing+15)>>4;
    ysize = pci->metrics.ascent + pci->metrics.descent;
    bottom = top + (ysize-1)*sper;

    for (y = ysize/2; y-- > 0;) {
	for (x = sper; x-- > 0;) {
	    tmp = *top;
	    *top++ = *bottom;
	    *bottom++ = tmp;
	}
	bottom -= 2*sper;
    }
}

void
sgiGlyphBlt(pWin, pGC, x, y, nglyph, ppci, pglyphbase, doClear)
WindowPtr	pWin;
GCPtr		pGC;
int		x, y;
unsigned int	nglyph;
CharInfoPtr	*ppci;
unsigned char	*pglyphbase;
int		doClear;
{
    register RegionPtr		pClip;
    register CharInfoPtr	pci;
    register BoxPtr		pbox;
    register int		nbox;
    Bitmap			bm;
    ExtentInfoRec		info;

    pClip = ((cfbPrivGCPtr) (pGC->devPriv))->pCompositeClip;
    if ((nbox = pClip->numRects) == 0 || sgiBeginWindowDraw(pWin))
	return;
    
    if (pGC->miTranslate) {
	x += pWin->absCorner.x;
	y += pWin->absCorner.y;
    }

    if (pGC->planemask  != ~0L)
	GLwritemask(pGC->planemask);

    QueryGlyphExtents(pGC->font, ppci, nglyph, &info);
    bm.ymove = 0;
    for (pbox = pClip->rects; nbox-- > 0; pbox++) {
	register int glyphcnt;
	register CharInfoPtr *allpci;

	GLscrmask(pbox->x1, pbox->y1, pbox->x2-pbox->x1, pbox->y2-pbox->y1);

	/*
	** First clear the entire area to background
	*/
	if (doClear) {
	    GLcolor(pGC->bgPixel);
	    GLrectfill(x, y-pGC->font->pFI->fontAscent, info.overallWidth,
		    pGC->font->pFI->fontAscent + pGC->font->pFI->fontDescent);
	}

	/*
	** Now fill the the good parts with text
	*/
	cmov2i(x, y);
	GLcolor(pGC->fgPixel);
	GLstartbitmap();
	glyphcnt = nglyph;
	allpci = ppci;
	while (glyphcnt--) {
	    pci = *allpci++;
	    if (pci->exists == 0)
		continue;
	    bm.xorig = pci->metrics.leftSideBearing;
	    bm.yorig = pci->metrics.descent - 1;
	    bm.ysize = pci->metrics.ascent + pci->metrics.descent;
	    bm.xsize = pci->metrics.rightSideBearing - pci->metrics.leftSideBearing;
	    bm.xmove = pci->metrics.characterWidth;
	    bm.sper = (bm.xsize + 15) >> 4;
	    bm.base = (unsigned short *) (pglyphbase + pci->byteOffset);
	    CHECK_GLYPH_INVERSION(pci, pglyphbase, TRUE);
	    GLdrawbitmap(&bm);
	}
	GLfinishbitmap();
    }
    GLfixscrmask();
    if (pGC->planemask  != ~0L)
	GLwritemask(~0L);
}

void
sgiImageGlyphBlt(pWin, pGC, x, y, nglyph, ppci, pglyphbase)
WindowPtr	pWin;
GCPtr		pGC;
int		x, y;
unsigned int	nglyph;
CharInfoPtr	*ppci;
unsigned char	*pglyphbase;
{
    sgiGlyphBlt(pWin, pGC, x, y, nglyph, ppci, pglyphbase, TRUE);
}

void
sgiPolyGlyphBlt(pWin, pGC, x, y, nglyph, ppci, pglyphBase)
WindowPtr	pWin;
GCPtr		pGC;
int		x, y;
unsigned int	nglyph;
CharInfoPtr	*ppci;
char		*pglyphBase;
{
    sgiGlyphBlt(pWin, pGC, x, y, nglyph, ppci, pglyphBase, FALSE);
}

/*
** This turns a character upside down because the SGI hardware and the sample
** server disagree on which way is up.  Instead of keeping two copies of
** each character we just call the function when we notice an upside down
** character.
*/

invert_bits(bits, sper, ysize)
    short	*bits;		/* Character data */
    int		sper,		/* Shorts per row */
		ysize;		/* Number of rows */
{
    register short *top, *bottom, tmp;
    register int x, y;

    top = bits;
    bottom = bits + (ysize-1)*sper;

    for (y = ysize/2; y-- > 0;) {
	for (x = sper; x-- > 0;) {
	    tmp = *top;
	    *top++ = *bottom;
	    *bottom++ = tmp;
	}
	bottom -= 2*sper;
    }
}
