/*
 * $Source: /usr/expo/X/src/clients/xsetsize/RCS/xsetsize.c,v $
 * $Header: xsetsize.c,v 1.7 88/04/13 15:46:34 jim Exp $
 *
 * xsetsize - changes size, placement, and border width of a window
 *
 * Copyright 1988 Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of M.I.T. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  M.I.T. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * Authors:  John E. Elsbree, Christopher J. VanHaren, Chris D. Peterson
 * Rewritten for xwininfo-style interface:  Jim Fulton
 */

#ifndef lint
static char rcsid_module_c[] = "$Header: xsetsize.c,v 1.7 88/04/13 15:46:34 jim Exp $";
#endif lint

#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <stdio.h>

char *ProgramName;
Display *dpy = NULL;
Window w = None;

Window select_window();

static Window parse_xid (s)
    char *s;
{
    char *fmt = "%lu";
    unsigned long retval = None;

    if (s && *s) {
	if (*s == '0') {
	    fmt = "%lo";
	    s++;
	}
	if (*s == 'x' || *s == 'X') {
	    fmt = "%lx";
	    s++;
	}
	if (sscanf (s, fmt, &retval) != 1) retval = None;
    }
    return (retval);
}

static void Usage ()
{
    static char *help_message[] = {
"where options include:",
"    -display displaystring        X server to contact",
"    -geometry geometrystring      geometry specification",
"    -relative                     interpret geometry relative",
"    -bw pixels                    set border width",
"    -iconic                       make iconic or manipulate the icon",
"",
"Option names may be abbreviated to the shortest unique prefix.",
"",
NULL};
    char **cpp;

    fprintf (stderr, "usage:\n        %s [-option ...]\n\n", ProgramName);
    for (cpp = help_message; *cpp; cpp++) {
	fprintf (stderr, "%s\n", *cpp);
    }
    if (dpy) XCloseDisplay (dpy);
    exit (1);
}

main (argc, argv)
    int argc;
    char *argv[];
{
    int i;				/* iterator variable */
    char *displayname = NULL;		/* name of X server to contact */
    char *geometry = NULL;		/* if present, new geometry */
    Bool relative = False;		/* if true, position relative */
    Bool iconify = False;		/* if true, iconify window */
    int border_width = -1;		/* if >= 0, set border width */
    int errors = 0;			/* counter of errors */

    ProgramName = argv[0];

    for (i = 1; i < argc; i++) {
	char *arg = argv[i];

	if (arg[0] == '-') {
	    switch (arg[1]) {
	      case 'd':			/* -display displaystring */
		if (++i >= argc) Usage ();
		displayname = argv[i];
		continue;
	      case 'g':			/* -geometry geometrystring */
		if (++i >= argc) Usage ();
		geometry = argv[i];
		continue;
	      case 'i':
		switch (arg[2]) {
		  case 'c':		/* -iconic */
		    iconify = True;
		    continue;
		  case 'd':		/* -id xid */
		    if (++i >= argc) Usage ();
		    w = parse_xid (argv[i]);
		    continue;
		  default:
		    Usage ();
		    /* NOTREACHED */
		}
		/* NOTREACHED */
	      case 'b':			/* -bw pixels */
		if (++i >= argc) Usage ();
		border_width = atoi (argv[i]);
		continue;
	      case 'r':			/* -relative */
		relative = True;
		continue;

	      default:
		Usage ();
		/* NOTREACHED */
	    }
	} else {
	    Usage ();
	}
    }

    dpy = XOpenDisplay (displayname);
    if (!dpy) {
	fprintf (stderr, "%s:  unable to open display \"%s\"\n",
		 ProgramName, XDisplayName (displayname));
	exit (1);
    }

    if (w == None) {
	w = select_window ();
	if (w == None) {
	    fprintf (stderr, "%s:  no window selected\n", ProgramName);
	    exit (1);
	}
    }

    if (iconify) {
      if (do_icon_geometry (geometry ? geometry : "", relative) != 0) errors++;
    } else if (geometry) {
      if (do_geometry (geometry, relative) != 0) errors++;
    }

    if (border_width >= 0) {
	if (do_border_width (border_width) != 0) errors++;
    }

    XSync (dpy, 0);
    XCloseDisplay (dpy);
    exit (errors);
    /* NOTREACHED */
}


static int do_icon_geometry (geometry, relative)
    char *geometry;			/* geometry spec */
    Bool relative;			/* if true, be relative */
{
    int geom_mask;
    int x, y, width, height;
    XWMHints *wmhints;
    XWindowAttributes attr;
    char defgeom[20];			/* big enough for two numbers */

    if (relative) {
	geom_mask = XParseGeometry (geometry, &x, &y, &width, &height);
    } else {
	if (!XGetWindowAttributes (dpy, w, &attr)) {
	    fprintf (stderr,
		     "%s:  unable to get attributes of window 0x%lx = %lu\n",
		     ProgramName, (unsigned long) w, (unsigned long) w);
	    return (-1);
	}
	sprintf (defgeom, "%dx%d", attr.width, attr.height);
	geom_mask = XGeometry (dpy, DefaultScreen (dpy), geometry, defgeom, 
			       attr.border_width, 1, 1, 0, 0, 
			       &x, &y, &width, &height);
    }
    wmhints = XGetWMHints (dpy, w);
    if (wmhints == NULL) {
	fprintf (stderr, 
    "%s:  unable to get WM hints for moving icon for window 0x%lx = %lu.\n",
		 ProgramName, (unsigned long) w, (unsigned long) w);
	return (-1);
    }

    if (geom_mask & XValue) {
	if (relative) {
	    if (!(wmhints->flags & IconPositionHint)) wmhints->icon_x = 0;
	    wmhints->icon_x += x;
	} else {
	    wmhints->icon_x = x;
	}
	wmhints->flags |= IconPositionHint;
    }

    if (geom_mask & YValue) {
	if (relative) {
	    if (!(wmhints->flags & IconPositionHint)) wmhints->icon_y = 0;
	    wmhints->icon_y += y;
	} else {
	    wmhints->icon_y = y;
	}
	wmhints->flags |= IconPositionHint;
    }
	    
    /*
     * ignore size since that really is job of the window manager
     */

    wmhints->flags |= StateHint;
    wmhints->initial_state = IconicState;

    XSetWMHints (dpy, w, wmhints);

    /*
     * since some window manager won't reposition until the window is unmapped
     * and then remapped...
     */

    XUnmapWindow (dpy, w);
    XMapWindow (dpy, w);

    free (wmhints);
    return (0);
}

static int do_geometry (geometry, relative)
    char *geometry;			/* geometry spec */
    Bool relative;			/* if true, be relative */
{
    int x, y, width, height;
    int geom_mask;
    XWindowAttributes attr;
    char defgeom[20];			/* big enough for two numbers */

    if (!XGetWindowAttributes (dpy, w, &attr)) {
	fprintf (stderr,
		 "%s:  unable to get attributes of window 0x%lx = %lu\n",
		 ProgramName, (unsigned long) w, (unsigned long) w);
	return (-1);
    }

    if (relative) {
	geom_mask = XParseGeometry (geometry, &x, &y, &width, &height);
    } else {
	sprintf (defgeom, "%dx%d", attr.width, attr.height);
	geom_mask = XGeometry (dpy, DefaultScreen (dpy), geometry, defgeom, 
			       attr.border_width, 1, 1, 0, 0, 
			       &x, &y, &width, &height);
    }

    if (geom_mask & XValue) {
	if (relative)
	  attr.x += x;
	else 
	  attr.x = x;
    }

    if (geom_mask & YValue) {
	if (relative)
	  attr.y += y;
	else 
	  attr.y = y;
    }

    if (geom_mask & WidthValue) {
	if (relative)
	  attr.width += width;
	else 
	  attr.width = width;
    }
    if (geom_mask & HeightValue) {
	if (relative)
	  attr.height += height;
	else 
	  attr.height = height;
    }

    XMoveResizeWindow (dpy, w, attr.x, attr.y, attr.width, attr.height);

    return (0);
}

static int do_border_width (border_width)
    int border_width;
{
    XSetWindowBorderWidth (dpy, w, border_width);
    return (0);
}



/*
 * Routine to let user select a window using the mouse, cribbed from dsimple.c
 */

Window select_window ()
{
    int status;
    Cursor cursor;
    XEvent event;
    Window target_win = None;
    int buttons = 0;
    Window root = DefaultRootWindow (dpy);

    printf ("Please select a window by pressing a pointer button.\n");

    /* Make the target cursor */
    cursor = XCreateFontCursor (dpy, XC_crosshair);

    /* Grab the pointer using target cursor, letting it room all over */
    status = XGrabPointer (dpy, root, False,
			   ButtonPressMask|ButtonReleaseMask, GrabModeSync,
			   GrabModeAsync, None, cursor, CurrentTime);
    if (status != GrabSuccess) {
	fprintf (stderr, "%s:  unable to grab mouse.\n", ProgramName);
	return (None);
    }

    /* Let the user select a window... */
    while ((target_win == None) || (buttons != 0)) {
	/* allow one more event */
	XAllowEvents (dpy, SyncPointer, CurrentTime);
	XWindowEvent (dpy, root, ButtonPressMask|ButtonReleaseMask, &event);
	switch (event.type) {
	  case ButtonPress:
	    if (target_win == None) {
		target_win = event.xbutton.subwindow;  /* window selected */
		if (target_win == None)
		  target_win = root;
	    }
	    buttons++;
	    break;
	  case ButtonRelease:
	    /* there may have been some down before we started */
	    if (buttons > 0) 
	      buttons--;
	    break;
	}
    } 

    XUngrabPointer (dpy, CurrentTime);	/* Done with pointer */
    XFlush (dpy);

    return (target_win);
}
