#include	<X11/Xlib.h>
#include	<stdio.h>
#include	<X11/bitmaps/wingdogs>

Display	*dpy;
Window	window;
Pixmap	wingdogs;
Pixmap	wingdogsTile;
GC	gc;
int	w = 40, h = 100, l = 100, a0 = 0, a1 = 90;

int	rw = 100, rh = 100, rl = 10, rew = 20, reh = 20;

int	center_x, center_y;

int	two_arcs = 0;

# define max(a, b)	((a) > (b) ? (a) : (b))

struct color {
	char		*name;
	unsigned long	pixel;
} colors[2] = {
	"red",	0,
	"blue",	0,
};

# define NCOLORS	2

main (argc, argv)
char	**argv;
{
	Window	root;
	int	scr;
	XEvent	ev;
	XConfigureEvent	*cev;
	XExposeEvent	*eev;
	XButtonEvent	*bev;
	XGCValues	gcv;
	int		i;
	int		xor = 0;
	int		stipple = 0;
	enum whichDraw { Arcs, Rect, Both } which = Arcs;
	int		line_style = LineSolid;
	int		fill_style = FillSolid;
	int		cap_style = CapButt;
	int		join_style = JoinBevel;
	XColor	hardware_color, exact_color;
	Colormap	def_cm;
	char	*displayName = NULL;
	int		gcmask;
	static char	dash_list[] = { 200, 200, 100, 100 };
	char		*getenv ();

	while (*++argv) {
		if (!strcmp (*argv, "-display")) {
			if (!*++argv) {
				fprintf (stderr, "missing display\n");
				exit (1);
			}
			displayName = *argv;
		} else if (!strcmp (*argv, "-xor")) {
			xor = 1;
		} else if (!strcmp (*argv, "-stipple")) {
			fill_style = FillStippled;
		} else if (!strcmp (*argv, "-two")) {
			two_arcs = 1;
		} else if (!strcmp (*argv, "-opaqueStipple")) {
			fill_style = FillOpaqueStippled;
		} else if (!strcmp (*argv, "-tile")) {
			fill_style = FillTiled;
		} else if (!strcmp (*argv, "-dash")) {
			line_style = LineOnOffDash;
		} else if (!strcmp (*argv, "-doubleDash")) {
			line_style = LineDoubleDash;
		} else if (!strcmp (*argv, "-capRound")) {
			cap_style = CapRound;
		} else if (!strcmp (*argv, "-capProjecting")) {
			cap_style = CapProjecting;
		} else if (!strcmp (*argv, "-joinRound")) {
			join_style = JoinRound;
		} else if (!strcmp (*argv, "-joinBevel")) {
			join_style = JoinBevel;
		}
	}
	dpy = XOpenDisplay (displayName);
	if (!dpy) {
		if (!displayName)
			displayName = getenv ("DISPLAY");
		fprintf (stderr, "can't open display %s\n", displayName);
		exit (1);
	}
	scr = DefaultScreen (dpy);
	root = RootWindow (dpy, scr);
	window = XCreateSimpleWindow (dpy, root, 0, 0, 300, 300, 1,
		BlackPixel (dpy, scr), WhitePixel (dpy, scr));
	def_cm = DefaultColormap(dpy, scr);
	for (i = 0; i < NCOLORS; i++) {
		XAllocNamedColor (dpy, def_cm, colors[i].name,
				  &hardware_color, &exact_color);
		colors[i].pixel = hardware_color.pixel;
	}
	gcmask = 0;
	if (xor) {
		gcv.foreground = BlackPixel (dpy, scr) ^ WhitePixel (dpy, scr);
		gcv.background = 0;
		gcv.function = GXxor;
		gcmask |= GCForeground|GCBackground|GCFunction;
	} else {
		if (colors[0].pixel == colors[1].pixel) {
			gcv.foreground = BlackPixel (dpy, scr);
			gcv.background = WhitePixel (dpy, scr);
		} else {
			gcv.foreground = colors[0].pixel;
			gcv.background = colors[1].pixel;
		}
		gcmask |= GCForeground|GCBackground;
	}
	if (fill_style != FillSolid) {
		wingdogs = XCreateBitmapFromData (dpy, window,
	 			wingdogs_bits, wingdogs_width, wingdogs_height);
		gcv.stipple = wingdogs;
		if (fill_style == FillTiled)
			gcv.fill_style = FillOpaqueStippled;
		else
			gcv.fill_style = fill_style;
		gcmask |= GCStipple|GCFillStyle;
	}
	if (line_style != LineSolid) {
		gcv.line_style = line_style;
		gcmask |= GCLineStyle;
	}
	if (cap_style != CapButt) {
		gcv.cap_style = cap_style;
		gcmask |= GCCapStyle;
	}
	if (join_style != JoinMiter) {
		gcv.join_style = join_style;
		gcmask |= GCJoinStyle;
	}
	gc = XCreateGC (dpy, window, gcmask, &gcv);
	if (line_style != LineSolid) 
		XSetDashes (dpy, gc, 0, dash_list, sizeof (dash_list));
	if (fill_style == FillTiled) {
		wingdogsTile = XCreatePixmap (dpy, window, wingdogs_width, wingdogs_height,
						DefaultDepth (dpy, scr));
		XFillRectangle (dpy, wingdogsTile, gc, 0, 0, wingdogs_width, wingdogs_height);
		gcv.tile = wingdogsTile;
		gcmask = GCFillStyle|GCTile;
		XChangeGC (dpy, gc, gcmask, &gcv);
	}	
	XSelectInput (dpy, window, ExposureMask|ButtonPressMask);
	XMapWindow (dpy, window);
	for (;;) {
		XNextEvent (dpy, &ev);
		switch (ev.type) {
		case ButtonPress:
			bev = (XButtonEvent *) &ev;
			switch (bev->button) {
			case 1:
				printf ("w, h, l, a0, a1: ");
				scanf ("%d %d %d %d %d", &w, &h, &l, &a0, &a1);
				break;
			case 2:
				printf ("rw, rh, rew, reh, rl: ");
				scanf ("%d %d %d %d %d", &rw, &rh, &rew, &reh, &rl);
				break;
			case 3:
				switch (which) {
				case Rect:
					which = Both;
					break;
				case Arcs:
					which = Rect;
					break;
				case Both:
					which = Arcs;
					break;
				}
				break;
			}
			XClearWindow (dpy, window);
			center_x = 10 + max ((rw + rl) / 2, w/4 + (w + l) / 2);
			center_y = 10 + max ((rh + rl) / 2, h/4 + (h + l) / 2);
			if (which != Rect)
				drawArc (w, h, l, a0*64, a1*64);
			if (which != Arcs)
				drawRect (rw, rh, rew, reh, rl);
			break;
		case Expose:
			eev = (XExposeEvent *) &ev;
			if (eev->count == 0) {
				center_x = 10 + max ((rw + rl) / 2, w/4 + (w + l) / 2);
				center_y = 10 + max ((rh + rl) / 2, h/4 + (h + l) / 2);
				if (which != Rect)
					drawArc (w, h, l, a0*64, a1*64);
				if (which != Arcs)
					drawRect (rw, rh, rew, reh, rl);
			}
			break;
		}
	}
}

drawArc (w, h, l, a0, a1)
int	w, h, l, a0, a1;
{
	XArc		arcs[2];
	XGCValues	gcv;
	int		c = 1;
	
	gcv.line_width = l;
	XChangeGC (dpy, gc, GCLineWidth, &gcv);
	arcs[0].x = center_x - w/2;
	arcs[0].y = center_y - h/2;
	arcs[0].width = w;
	arcs[0].height = h;
	arcs[0].angle1 = a0;
	arcs[0].angle2 = a1;
	if (two_arcs) {
		arcs[0].x -= w/4;
		arcs[0].y -= h/4;
		c = 2;
		arcs[1].x = arcs[0].x + w/2;
		if (w == 0)
			arcs[1].x = arcs[0].x + 2 * l;
		arcs[1].y = arcs[0].y + h/2;
		if (h == 0)
			arcs[1].y = arcs[0].y + 2 * l;
		arcs[1].width = w;
		arcs[1].height = h;
		arcs[1].angle1 = a0;
		arcs[1].angle2 = a1;
	}
	XDrawArcs (dpy, window, gc, arcs, c);
}

drawRect (w, h, ew, eh, l)
int	w, h, ew, eh, l;
{
	XGCValues	gcv;
	int		x, y;

	x = center_x - w/2;
	y = center_y - h/2;
	gcv.line_width = l;
	XChangeGC (dpy, gc, GCLineWidth, &gcv);
	XmuDrawRoundedRectangle (dpy, window, gc, x, y, w, h, ew, eh);
}

XmuDrawRoundedRectangle (dpy, draw, gc, x, y, w, h, ew, eh)
    Display		*dpy;
    Drawable		draw;
    GC			gc;
    int			x, y, w, h, ew, eh;
{
	XArc	arcs[8];

	arcs[0].x = x;
	arcs[0].y = y;
	arcs[0].width = ew * 2;
	arcs[0].height = eh * 2;
	arcs[0].angle1 = 180*64;
	arcs[0].angle2 = -90*64;

	arcs[1].x = x + ew;
	arcs[1].y = y;
	arcs[1].width = w - ew*2;
	arcs[1].height = 0;
	arcs[1].angle1 = 180*64;
	arcs[1].angle2 = -180*64;

	arcs[2].x = x + w - ew*2;
	arcs[2].y = y;
	arcs[2].width = ew * 2;
	arcs[2].height = eh * 2;
	arcs[2].angle1 = 90*64;
	arcs[2].angle2 = -90*64;

	arcs[3].x = x + w;
	arcs[3].y = y + eh;
	arcs[3].width = 0;
	arcs[3].height = h - eh*2;
	arcs[3].angle1 = 90 * 64;
	arcs[3].angle2 = -180*64;

	arcs[4].x = x + w - ew*2;
	arcs[4].y = y + h - eh*2;
	arcs[4].width = ew * 2;
	arcs[4].height = eh * 2;
	arcs[4].angle1 = 0;
	arcs[4].angle2 = -90*64;

	arcs[5].x = x + ew;
	arcs[5].y = y + h;
	arcs[5].width = w - ew*2;
	arcs[5].height = 0;
	arcs[5].angle1 = 0;
	arcs[5].angle2 = -180*64;

	arcs[6].x = x;
	arcs[6].y = y + h - eh*2;
	arcs[6].width = ew * 2;
	arcs[6].height = eh * 2;
	arcs[6].angle1 = 270*64;
	arcs[6].angle2 = -90*64;

	arcs[7].x = x;
	arcs[7].y = y + eh;
	arcs[7].width = 0;
	arcs[7].height = h - eh*2;
	arcs[7].angle1 = 270*64;
	arcs[7].angle2 = -180*64;
	XDrawArcs (dpy, draw, gc, arcs, 8);
}
