
/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/*
 * X11 support and other enhancements added by Jeff Weinstein
 * (jeff@polyslo.calpoly.edu).  Please send all comments, bug
 * reports, fixes, suggestions regarding this version of XTrek
 * to me.  
 */

static char RCSID[] = "$Header: /blackbird/home/jeff/TAPE2/xtrek.new/RCS/torp.c,v 3.1 88/09/20 00:44:57 jeff Exp $";

#include <X11/Xlib.h>
#include <X11/Xos.h>
#include <stdio.h>
#ifndef ibm032
#include <sys/ipc.h>
#include <sys/shm.h>
#endif ibm032
#include "defs.h"
#include "struct.h"
#include "data.h"

/* Launch torp */

/*
** If a set of given conditions are met, fire a single torp in direction
** course.  Type is used because robots are allowed to shoot straight.
** Torps sent with status TMOVE wobble a bit.  TSTRAIGHT torps (fired
** by robots) move in a straight line.
**
** torp->t_fuse is the life of the torpedo.  It is set here based on
** a random function.  Torps currently live two to five seconds.
*/

static unsigned long lasttime = 0;
#define GAP 100
long random();

ntorp(course, type, curtime)
unsigned char course;
int type;
unsigned long curtime;
{
    register int i;
    register struct torp *k;

/* Hose people who use the 't' key bursts.  */
/* Boy will they be surprised!!! */

    if (me->p_flags & PFWEP) {
	warning("Weapons overheated");
	return;
    }
    if ((curtime - lasttime) < GAP) {
	me->p_wtemp += 20;		/* Heat weapons */
	return;
    }
    else {
	lasttime = curtime;
    }

    if (me->p_ntorp == MAXTORP) {
	me->p_wtemp += 10;		/* Heat weapons */
	warning("Torps limited to 12");
	return;
    }
    if (me->p_fuel < myship->s_torpcost) {
	warning("Not enough fuel for torp");
	return;
    }
    if (me->p_flags & PFREPAIR) {
	warning("Can't fire while repairing");
	return;
    }
    if (me->p_flags & PFCLOAK) {
	warning("Cannot fire while cloaked, deactivating cloaking device");
	me->p_flags &= ~PFCLOAK;
	return;
    }
    me->p_ntorp++;
    me->p_fuel -= myship->s_torpcost;
    me->p_wtemp += (myship->s_torpcost / 10) - 10;	/* Heat weapons */
    for (i = me->p_no * MAXTORP, k = &torps[i];		/* Find a free torp */
	i < me->p_no * MAXTORP + MAXTORP; i++, k++) {
	    if (k->t_status == TFREE)
		break;
    }

    /* Setup data in new torp */

    k->t_no = i;
    k->t_status = type;
    k->t_owner = me->p_no;
    k->t_team = me->p_team;
    k->t_x = me->p_x;
    k->t_y = me->p_y;
    k->t_dir = course;
    k->t_damage = myship->s_torpdamage;
    k->t_speed = myship->s_torpspeed;
    k->t_war = me->p_hostile | me->p_swar;
    k->t_fuse = (random() % 30) + 20;
    mystats->st_torps++;
}
