
/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/*
 * X11 support and other enhancements added by Jeff Weinstein
 * (jeff@polyslo.calpoly.edu).  Please send all comments, bug
 * reports, fixes, suggestions regarding this version of XTrek
 * to me.  
 */

static char RCSID[] = "$Header: /blackbird/home/jeff/TAPE2/xtrek.new/RCS/stats.c,v 3.1 88/09/20 00:44:55 jeff Exp $";

#include <X11/Xlib.h>
#include <X11/X10.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include "defs.h"
#include "struct.h"
#include "data.h"

#define	MIN(a,b)	(((a) < (b)) ? (a) : (b))
#define	MAX(a,b)	(((a) > (b)) ? (a) : (b))

#define	BX_OFF()	((textWidth + 1) * FONTWIDTH(dfontinfo) + S_IBORDER)
#define	BY_OFF(line)	((line) * (FONTHEIGHT(dfontinfo) + S_IBORDER) + S_IBORDER)
#define	TX_OFF(len)	((textWidth - len) * FONTWIDTH(dfontinfo) + S_IBORDER)
#define	TY_OFF(line)	BY_OFF(line)

#define STAT_WIDTH		160
#define STAT_HEIGHT		BY_OFF(NUM_SLIDERS)
#define STAT_BORDER		2
#define S_IBORDER		5
#define STAT_X			422
#define STAT_Y			13

#define SL_WID			\
	(STAT_WIDTH - 2 * S_IBORDER - (textWidth + 1) * FONTWIDTH(dfontinfo))
#define SL_HEI			(FONTHEIGHT(dfontinfo))

#define NUM_ELS(a)		(sizeof (a) / sizeof (*(a)))
#define NUM_SLIDERS		NUM_ELS(sliders)

typedef struct slider {
	char	*label;
	int	min, max;
	int	low_red, high_red;
	int	label_length;
	int	diff;
} SLIDER;

typedef struct record {
	short	*data;
	short	last_value;
} RECORD;

static SLIDER	sliders[] = {
	{ "Shields",		0,	100,	20,	100	},
	{ "Damage",		0,	100,	0,	0	},
	{ "Fuel",		0,	10000,	1000,	10000	},
	{ "Warp",		0,	9,	0,	9	},
	{ "Weapon Temp",	0,	1200,	0,	1000	},
	{ "Engine Temp",	0,	1200,	0,	1000	},
};

static XAssocTable	*table;
static int		textWidth = 0;
static int		statX = STAT_X, statY = STAT_Y;
static XSizeHints	size_hints;
static int		follow = 0;

initStats(prog)
	char	*prog;
{
	int	i, dummy;
	char	*str;

	if ((str = XGetDefault(dpy, prog, "stats.geometry")) != NULL) {
		XParseGeometry(str, &statX, &statY, &dummy, &dummy);
		size_hints.flags = USPosition|USSize;
	}
	else if ( booleanDefault( prog, "stats.follow" ) ) {
		size_hints.flags = USPosition|USSize;
		follow = 1;
	}
	else {
		size_hints.flags = PPosition|PSize;
		follow = 1;
	}

	size_hints.x = statX;
	size_hints.y = statY;
	size_hints.width = STAT_WIDTH;
	size_hints.height = STAT_HEIGHT;

	table = (XAssocTable *) XCreateAssocTable(8);
	for (i = 0; i < NUM_SLIDERS; i++) {
		sliders[i].label_length = strlen(sliders[i].label);
		textWidth = MAX(textWidth, sliders[i].label_length);
		sliders[i].diff = sliders[i].max - sliders[i].min;
	}
}

Window
openStats(p)
	struct player	*p;
{
	Window		w;
	RECORD		*rp;
	char 		*calloc();
	XWindowAttributes attr;
	Window		dummy;

	if ( follow ) {
/*		XGetWindowAttributes( dpy, baseWin, &attr );
		statX = attr.x + 420;
		statY = attr.y - 85;
*/
		XTranslateCoordinates( dpy, baseWin, root, 0, 0, &statX, &statY, &dummy );
		statX += 420;
		statY -= 85;
		size_hints.x = statX;
		size_hints.y = statY;
		if ( statY < 0 )
			statY = 0;
	}
	
	w = X10CreateWindow(root, statX, statY, STAT_WIDTH, STAT_HEIGHT,
		STAT_BORDER, foreTile, backTile);
        XSetTransientForHint( dpy, w, baseWin );
	XSetNormalHints( dpy, w, &size_hints );

	XDefineCursor(dpy, w, crosshair);
	rp = (RECORD *) calloc(NUM_SLIDERS, sizeof (RECORD));
	rp[0].data = &(p->p_shield);
	sliders[0].max = (p->p_ship.s_maxshields);
	sliders[0].diff = sliders[0].max - sliders[0].min;
	sliders[0].low_red = (p->p_ship.s_maxshields / 5);
	sliders[0].high_red = (p->p_ship.s_maxshields);

	rp[1].data = &(p->p_damage);
	sliders[1].max = (p->p_ship.s_maxdamage);
	sliders[1].diff = sliders[1].max - sliders[1].min;
	sliders[1].high_red = (p->p_ship.s_maxdamage);

	rp[2].data = &(p->p_fuel);
	sliders[2].max = (p->p_ship.s_maxfuel);
	sliders[2].diff = sliders[2].max - sliders[2].min;
	sliders[2].low_red = (p->p_ship.s_maxfuel / 5);
	sliders[2].high_red = (p->p_ship.s_maxfuel);

	rp[3].data = &(p->p_speed);
	sliders[3].max = (p->p_ship.s_maxspeed);
	sliders[3].diff = sliders[3].max - sliders[3].min;
	sliders[3].high_red = (p->p_ship.s_maxspeed);

	rp[4].data = &(p->p_wtemp);
	rp[5].data = &(p->p_etemp);
	XMakeAssoc(dpy, table, w, rp);
	XSelectInput(dpy, w, ExposureMask);
	XMapWindow(dpy, w);
	return (w);
}

redrawStats(w)
	Window	w;
{
	int	i;
	RECORD	*rp;

	rp = (RECORD *) XLookUpAssoc(dpy, table, w);
	if (rp == NULL) {
		fputs("You gave redrawStats a bum window\n", stderr);
		return;
	}
	XClearWindow(dpy, w);
	for (i = 0; i < NUM_SLIDERS; i++) {
		rp[i].last_value = 0;
		XText(w, TX_OFF(sliders[i].label_length), TY_OFF(i),
			sliders[i].label, sliders[i].label_length, dfont,
			textColor, backColor);
		box(w, 0, BX_OFF() - 1, BY_OFF(i) - 1, SL_WID+2, SL_HEI+2,
			borderColor, GXcopy, AllPlanes);
	}
}

closeStats(w)
	Window	w;
{
	int dummy;

	if (w == 0)
		return;

	XDeleteAssoc(dpy, table, w);
	XGetGeometry(dpy, w, &dummy, &statX, &statY, &dummy, &dummy, &dummy, &dummy);
	XDestroyWindow(dpy, w);
}

updateStats(w)
	Window		w;
{
	int	i, value, diff, color, old_x, new_x, wid;
	RECORD	*rp, *r;
	SLIDER	*s;

	if (w == 0)
		return;

	rp = (RECORD *) XLookUpAssoc(dpy, table, w);
	for (i = 0; i < NUM_SLIDERS; i++) {
		r = &rp[i];
		s = &sliders[i];
		value = *(r->data);
		if (value < s->min)
			value = s->min;
		else if (value > s->max)
			value = s->max;
		if (value == r->last_value)
			continue;
		diff = value - r->last_value;
		if (diff < 0)
			color = backColor;
		else {
			if (value < s->low_red)
				color = warningColor;
			else if (value > s->high_red) {
				color = warningColor;
			    	if (r->last_value <= s->high_red)
					r->last_value = 0;
			} else {
				color = myColor;
				if (r->last_value < s->low_red)
					r->last_value = 0;
			}
		}
		old_x = r->last_value * SL_WID / s->diff;
		new_x = value * SL_WID / s->diff;
		wid = new_x - old_x;
		/*
		if (wid > 0)
			wid++;
		else if (wid < 0)
			wid--;
		*/
		box(w, 1, BX_OFF() + old_x, BY_OFF(i), wid,
			SL_HEI, color, GXcopy, AllPlanes);
		if (diff < 0) {
			if (r->last_value >= s->low_red && value < s->low_red)
				box(w, 1, BX_OFF(), BY_OFF(i), new_x, SL_HEI,
					warningColor, GXcopy, AllPlanes);
			else if (r->last_value > s->high_red && 
				 value <= s->high_red)
				box(w, 1, BX_OFF(), BY_OFF(i), new_x, SL_HEI,
					myColor, GXcopy, AllPlanes);
		}
		r->last_value = value;
	}
}


			
box(w, filled, x, y, wid, hei, pixel, func, planes)
	Window	w;
{
	int	minX, minY;
	static GC gc = 0;

	if (wid == 0 || hei == 0)
		return;

	if ( gc == 0 )
		gc = XCreateGC(dpy, root, 0, NULL);

	XSetFunction(dpy, gc, func);
	XSetPlaneMask(dpy, gc, planes);
	XSetForeground(dpy, gc, pixel);

	minX = MIN(x, x + wid);
	wid = ABS(wid);
	minY = MIN(y, y + hei);
	hei = ABS(hei);

	if ( filled )
		XFillRectangle(dpy, w, gc, minX, minY, wid + 1, hei + 1);
	else
		XDrawRectangle(dpy, w, gc, minX, minY, wid + 1, hei + 1);

	return;
	}
