
/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/*
 * X11 support and other enhancements added by Jeff Weinstein
 * (jeff@polyslo.calpoly.edu).  Please send all comments, bug
 * reports, fixes, suggestions regarding this version of XTrek
 * to me.  
 */

static char RCSID[] = "$Header: /blackbird/home/jeff/TAPE2/xtrek.new/RCS/smessage.c,v 3.1 88/09/20 00:44:50 jeff Exp $";


#include <X11/Xlib.h>
#include <stdio.h>
#include <math.h>
#include <signal.h>
#include <ctype.h>
#include "defs.h"
#include "struct.h"
#include "data.h"

#define ADDRLEN 10

static int lcount;
static char buf[80];
static char addr;
static char addrmesg[ADDRLEN];

smessage(ichar)
char ichar;
{
    register int i;

    if (watch) {
	warning("cannot send messages from watch");
	return;
    }
    if (messpend == 0) {
	messpend = 1;
	if (mdisplayed) {
	    XClearWindow(dpy, messagew);
	    mdisplayed = 0;
	}
	/* Put the proper recipient in the window */
	if (getaddr(ichar) < 0) {
	    /* print error message */
	    messpend = 0;
	    return;
	}
	XText(messagew, MESSAGEBD + FONTWIDTH(dfontinfo), MESSAGEBD,
	    addrmesg, ADDRLEN, dfont, textColor, backColor);
	lcount = ADDRLEN;
	return;
    }
    switch (ichar) {
	case '\b':
	case '\177':
	    if (--lcount < ADDRLEN) {
		lcount = ADDRLEN;
		break;
	    }
	    XPixSet(messagew, MESSAGEBD + FONTWIDTH(dfontinfo) * lcount, 
		MESSAGEBD, FONTWIDTH(dfontinfo), FONTHEIGHT(dfontinfo), 
		backColor);
	    break;
	case '\027':
	    i = 0;
	    /* back up over blanks */
	    while (--lcount >= ADDRLEN && isspace(buf[lcount - ADDRLEN]))
		i++;
	    lcount++;
	    /* back up over non-blanks */
	    while (--lcount >= ADDRLEN && !isspace(buf[lcount - ADDRLEN]))
		i++;
	    lcount++;

	    if (i > 0)
		XPixSet(messagew, MESSAGEBD + FONTWIDTH(dfontinfo) * lcount, 
		    MESSAGEBD, FONTWIDTH(dfontinfo) * i, FONTHEIGHT(dfontinfo),
		    backColor);
	    break;
	case '\025':
	case '\030':
	    if (lcount > ADDRLEN)
		XPixSet(messagew, MESSAGEBD + FONTWIDTH(dfontinfo) * ADDRLEN, 
		    MESSAGEBD, FONTWIDTH(dfontinfo) * (lcount - ADDRLEN),
		    FONTHEIGHT(dfontinfo), backColor);
	    lcount = ADDRLEN;
	    break;
	case '\033':
	    XPixSet(messagew, MESSAGEBD, MESSAGEBD, 
		FONTWIDTH(dfontinfo) * lcount,
		FONTHEIGHT(dfontinfo), backColor);
	    mdisplayed = 0;
	    messpend = 0;
	    break;
	case '\r':
	    buf[lcount - ADDRLEN] = 0;
	    messpend = 0;
	    switch (addr) {
		case 'A':
		    pmessage(buf, 0, MALL, addrmesg);
		    break;
		case 'F':
		    pmessage(buf, FED, MTEAM, addrmesg);
		    break;
		case 'R':
		case 'r':
		    pmessage(buf, ROM, MTEAM, addrmesg);
		    break;
		case 'K':
		case 'k':
		    pmessage(buf, KLI, MTEAM, addrmesg);
		    break;
		case 'O':
		case 'o':
		    pmessage(buf, ORI, MTEAM, addrmesg);
		    break;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		    pmessage(buf, addr - '0', MINDIV, addrmesg);
		    break;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
		    pmessage(buf, addr - 'a' - 10, MINDIV, addrmesg);
		    break;
		default:
		    warning("Not legal recipient");
	    }
	    XPixSet(messagew, MESSAGEBD, MESSAGEBD, 
		FONTWIDTH(dfontinfo) * lcount,
		FONTHEIGHT(dfontinfo), backColor);
	    mdisplayed = 0;
	    lcount = 0;
	    break;
	default:
	    if (lcount == 80) {
		XBell(dpy, 0);
		break;
	    }
	    if (iscntrl(ichar))
		break;
	    XText(messagew, MESSAGEBD + FONTWIDTH(dfontinfo) * lcount, 
		MESSAGEBD, &ichar, 1, dfont, textColor, backColor);
	    buf[(lcount++) - ADDRLEN] = ichar;
	    break;
    }
}

pmessage(str, recip, group, address)
char *str;
int recip;
int group;
char *address;
{
    struct message *cur;
    if (++(mctl->mc_current) >= MAXMESSAGE)
	mctl->mc_current = 0;
    cur = &messages[mctl->mc_current];
    cur->m_no = mctl->mc_current;
    cur->m_flags = group;
    cur->m_time = 0;
    cur->m_recpt = recip;
    (void) sprintf(cur->m_data, "%-9s %s", address, str);
    cur->m_flags |= MVALID;
}

getaddr(who)
char who;
{
    addr = who;
    (void) sprintf(addrmesg, " %c%x->", teamlet[me->p_team], me->p_no);
    switch (who) {
	case 'A':
	    (void) sprintf(&addrmesg[5], "ALL");
	    break;
	case 'F':
	    (void) sprintf(&addrmesg[5], "FED");
	    break;
	case 'R':
	case 'r':
	    (void) sprintf(&addrmesg[5], "ROM");
	    break;
	case 'K':
	case 'k':
	    (void) sprintf(&addrmesg[5], "KLI");
	    break;
	case 'O':
	case 'o':
	    (void) sprintf(&addrmesg[5], "ORI");
	    break;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	    if (isAlive(&players[who - '0'])) {
		(void) sprintf(&addrmesg[5], "%c%x ",
		    teamlet[players[who - '0'].p_team], who - '0');
	    }
	    else {
		warning("Player is not in game");
		return(-1);
	    }
	    break;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	    if (isAlive(&players[who - 'a' + 10])) {
		(void) sprintf(&addrmesg[5], "%c%x ",
		    teamlet[players[who - 'a' + 10].p_team], who - 'a' + 10);
	    }
	    else {
		warning("Player is not in game");
		return(-1);
	    }
	    break;
	default:
	    warning("Not legal recipient");
	    return(-1);
    }
    return(0);
}
