
/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/*
 * X11 support and other enhancements added by Jeff Weinstein
 * (jeff@polyslo.calpoly.edu).  Please send all comments, bug
 * reports, fixes, suggestions regarding this version of XTrek
 * to me.  
 */

static char RCSID[] = "$Header: /blackbird/home/jeff/TAPE2/xtrek.new/RCS/redraw.c,v 3.1 88/09/20 00:44:40 jeff Exp $";

#include <X11/Xlib.h>
#include <stdio.h>
#include <signal.h>
#include <math.h>
#include "defs.h"
#include "struct.h"
#include "data.h"
#include "bitmaps.h"


static char *shipnos = "0123456789abcdef";

static XRectangle clearzone[(MAXTORP + 1) * MAXPLAYER + MAXPLANETS];
static int clearcount = 0;
static XSegment clearline[MAXPLAYER];
static int clearlcount = 0;
static XRectangle mclearzone[MAXPLAYER + MAXPLANETS];	/* For map window */
static int mclearcount = 0;

static short nplayers;
static int tstatoffset = MESSAGEBD;

intrupt()
{
    if (((me->p_status == PDEAD) || (me->p_status == POUTFIT))
	&& (me->p_ntorp <= 0)) {
	if (copilot)
	    exit(0);
	else if (!watch)
	    death();
    }

    if (! (copilot || watch))
	udcounter++;
    auto_features();
    redraw();
}

redraw()
{

    static int stlinecount = 1;

    /* erase warning line if necessary */
    if ((warntimer <= udcounter) && (warncount > 0)) {
	XClearWindow(dpy, warnw);
	warncount = 0;
    }

    if ((mapmode) && (udcounter % ((nplayers == 0) ? 1 : nplayers) == 0))
	map();

    /* Display a new message every MESSTIME/10 seconds */
    if (udcounter % MESSTIME == 0)
	dmessage();

    if ( clearcount ) {
	XFillRectangles( dpy, w, backGC, clearzone, clearcount );
	clearcount = 0;
    }

    if ( clearlcount ) {
	XDrawSegments( dpy, w, backGC, clearline, clearlcount );
	clearlcount = 0;
    }

    local();	/* redraw local window */

    if ((++stlinecount&02) == 0)
	stline();		/* update every 4 times we update the window */

    if (showStats)
	updateStats(statwin);

}

drawPartialPhaser(j)
register struct player *j;
{
int	sx,ex,sy,ey;
struct	phaser *php;


    sx= j->p_x-me->p_x;
    sy= j->p_y-me->p_y;
    /* Now draw his phaser (if it exists) */
    php = &phasers[j->p_no];
    if (php->ph_status == PHMISS) {
	/* Here I will have to compute end coordinate */
	phasedist(j, php, &ex, &ey);
	ex -= me->p_x;
	ey -= me->p_y;
    }
    else {
	ex = (players[php->ph_target].p_x)-me->p_x;
	ey = (players[php->ph_target].p_y)-me->p_y;
    }
    /* phaser end points are now relative to our position, make them
     * relative to window origin (so X clips them correctly)
     */
    sx= sx/SCALE+WINSIDE/2; sy= sy/SCALE+WINSIDE/2;
    ex= ex/SCALE+WINSIDE/2; ey= ey/SCALE+WINSIDE/2;
    if ((sx<0)&&(ex<0))	return;
    if ((sy<0)&&(ey<0))	return;
    if ((sx>WINSIDE)&&(ex>WINSIDE))	return;
    if ((sy>WINSIDE)&&(ey>WINSIDE))	return;
    XLine(w, sx, sy, ex, ey, 1, 1, phaserColor(php), GXcopy, AllPlanes);
    clearline[clearlcount].x1 = sx;
    clearline[clearlcount].y1 = sy;
    clearline[clearlcount].x2 = ex;
    clearline[clearlcount].y2 = ey;
    clearlcount++;
}

local()
{
    register int h, i;
    register struct player *j;
    register struct torp *k;
    register struct planet *l;
    register struct phaser *php;
    char glyph;

    int dx, dy;
    int view;

    /* Draw Planets */
    view = SCALE * WINSIDE / 2;
    for (i = 0, l = &planets[i]; i < MAXPLANETS; i++, l++) {
	dx = l->pl_x - me->p_x;
	dy = l->pl_y - me->p_y;
	if (dx > view || dx < -view || dy > view || dy < -view)
	    continue;
	dx = dx / SCALE + WINSIDE / 2;
	dy = dy / SCALE + WINSIDE / 2;

        glyph = planetGlyph(l);
	XDrawString(dpy, w, planetGC(l), dx - (planet_width/2),
		dy - (planet_height/2), &glyph, 1);
	if (namemode) {
	    XFontStruct *ptmpFStruct;
	    XCharStruct tmpCStruct;
	    int dummy;
	    XText(w, dx - (planet_width/2), dy + (planet_height/2),
		l->pl_name, l->pl_namelen, planetFont(l),
		planetColor(l), backColor);
	    ptmpFStruct = planetFontInfo(l);
	    XTextExtents(ptmpFStruct, l->pl_name, l->pl_namelen,
		&dummy, &dummy, &dummy, &tmpCStruct);
	    clearzone[clearcount].x = dx - (planet_width/2);
	    clearzone[clearcount].y = dy + (planet_height/2);
	    clearzone[clearcount].width= tmpCStruct.rbearing - tmpCStruct.lbearing + 1;
	    clearzone[clearcount].height = tmpCStruct.ascent +
			tmpCStruct.descent;
/*
	    clearzone[clearcount].width= FONTWIDTH(ptmpFStruct) * l->pl_namelen;
	    clearzone[clearcount].height = FONTHEIGHT(ptmpFStruct);
*/
	    clearcount++;
	}
	clearzone[clearcount].x = dx - (planet_width/2);
	clearzone[clearcount].y = dy - (planet_height/2);
	clearzone[clearcount].width = planet_width;
	clearzone[clearcount].height = planet_height;
	clearcount++;
    }

    /* Draw ships */
    nplayers = 0;
    view = SCALE * WINSIDE / 2;
    for (i = 0, j = &players[i]; i < MAXPLAYER; i++, j++) {
	int tx, ty;
	if ((j->p_status != PALIVE) && (j->p_status != PEXPLODE))
	    continue;
	if ((j->p_flags & PFCLOAK)&&(j!=me)&&((random()%j->p_ship.s_accs)!=0))
	    continue;
	nplayers++;
	dx = j->p_x - me->p_x;
	dy = j->p_y - me->p_y;
	if (dx > view || dx < -view || dy > view || dy < -view) {
	    if (phasers[j->p_no].ph_status!=PHFREE)
		drawPartialPhaser(j);
	    continue;
	}
	dx = dx / SCALE + WINSIDE / 2;
	dy = dy / SCALE + WINSIDE / 2;
	if ((j->p_flags&PFCLOAK)&&(j!=me)) {
	    dx+= 3-(random()%7);
	    dy+= 3-(random()%7);
	}
	if (j->p_status == PALIVE) {
	    XFontStruct *ptmpFStruct;
	    XCharStruct tmpCStruct;
	    int dummy;
	    switch (j->p_team) {
		case FED:
		    glyph = FED_GLYPHS + rosette(j->p_dir);
		    break;
		case ROM:
		    glyph = ROM_GLYPHS + rosette(j->p_dir);
		    break;
		case KLI:
		    glyph = KLI_GLYPHS + rosette(j->p_dir);
		    break;
		case ORI:
		    glyph = ORI_GLYPHS + rosette(j->p_dir);
		    break;
	    }
	    XDrawString(dpy, w, playerGC(j), dx - (ship_width/2),
			dy - (ship_height/2), &glyph, 1);
	    XText(w, dx + (ship_width/2), dy - (ship_height/2),
		shipnos + j->p_no, 1, shipFont(j), playerColor(j), backColor);
	    
	    if ( mono )	{
		if (showShields && j->p_flags & PFSHIELD) {
		    if ( j == me ) { /* change shield glyph based on damage */
		        if ( j->p_damage > ( j->p_ship.s_maxdamage / 2 ) )
			    glyph = RSHIELD_GLYPH;
			else if ( j->p_shield < ( j->p_ship.s_maxshields / 2 ) )
			    glyph = YSHIELD_GLYPH;
			else
			    glyph = SHIELD_GLYPH;
		    }
		    else
			glyph = SHIELD_GLYPH;
		    XDrawString( dpy, w, playerGC(j), dx - (shield_width/2),
				dy - (shield_height/2), &glyph, 1 );
		}
	    }
	    else { /* color */
	        if (showShields && j->p_flags & PFSHIELD) {
		    GC tmpgc;
		
		    if ( j == me ) { /* change shield color based on damage */
			if ( j->p_damage > 50 )
			    tmpgc = rGC;
			else if ( j->p_shield < 50 )
			    tmpgc = yGC;
			else
			    tmpgc = playerGC(j);
		    }
		    else
			tmpgc = playerGC(j);

		    glyph = SHIELD_GLYPH;
		    XDrawString( dpy, w, tmpgc, dx - (shield_width/2),
				dy - (shield_height/2), &glyph, 1 );
		}
	    }

	    ptmpFStruct = shipFontInfo(j);
	    XTextExtents(ptmpFStruct, shipnos+ j->p_no, 1,
		&dummy, &dummy, &dummy, &tmpCStruct);
	    clearzone[clearcount].x = dx + (ship_width/2);
	    clearzone[clearcount].y = dy - (ship_height/2);
	    clearzone[clearcount].width = tmpCStruct.rbearing + tmpCStruct.lbearing + 1;
	    clearzone[clearcount].height = tmpCStruct.ascent + tmpCStruct.descent;
	    clearcount++;
	    clearzone[clearcount].x = dx - (shield_width/2);
	    clearzone[clearcount].y = dy - (shield_height/2);
	    clearzone[clearcount].width = shield_width;
	    clearzone[clearcount].height = shield_height;
	    clearcount++;
	}
	else if (j->p_status == PEXPLODE) {

	    glyph = EXP_GLYPHS_LEFT + (10 - j->p_explode)/2;
	    XDrawString(dpy, w, playerGC(j), dx - (ex_width/2), 
		dy - (ex_height/2), &glyph, 1);

	    glyph = EXP_GLYPHS_RIGHT + (10 - j->p_explode)/2;
	    XDrawString(dpy, w, playerGC(j), dx, 
		dy - (ex_height/2), &glyph, 1);

	    clearzone[clearcount].x = dx - (ex_width/2);
	    clearzone[clearcount].y = dy - (ex_height/2);
	    clearzone[clearcount].width = ex_width;
	    clearzone[clearcount].height = ex_height;
	    clearcount++;
	}
	/* Now draw his phaser (if it exists) */
	php = &phasers[j->p_no];
	if (php->ph_status != PHFREE) {
	    if (php->ph_status == PHMISS) {
		/* Here I will have to compute end coordinate */
		phasedist(j, php, &tx, &ty);
		tx = (tx - me->p_x) / SCALE + WINSIDE / 2;
		ty = (ty - me->p_y) / SCALE + WINSIDE / 2;
		XDrawLine(dpy, w, phaserGC(php), dx, dy, tx, ty);
	    }
	    else { /* Start point is dx, dy */
		tx = (players[php->ph_target].p_x - me->p_x) /
		    SCALE + WINSIDE / 2;
		ty = (players[php->ph_target].p_y - me->p_y) /
		    SCALE + WINSIDE / 2;
		XDrawLine(dpy, w, phaserGC(php), dx, dy, tx, ty);
	    }
	    clearline[clearlcount].x1 = dx;
	    clearline[clearlcount].y1 = dy;
	    clearline[clearlcount].x2 = tx;
	    clearline[clearlcount].y2 = ty;
	    clearlcount++;
	}
    }
    /* Draw torps */
    view = SCALE * WINSIDE / 2;
    for (i = 0, j = &players[i]; i < MAXPLAYER; i++, j++) {
	if (!j->p_ntorp)
	    continue;
	for (h = 0, k = &torps[MAXTORP * i + h]; h < MAXTORP; h++, k++) {
	    if (!k->t_status)
		continue;
	    dx = k->t_x - me->p_x;
	    dy = k->t_y - me->p_y;
	    if (dx > view || dx < -view || dy > view || dy < -view)
		continue;
	    dx = dx / SCALE + WINSIDE / 2;
	    dy = dy / SCALE + WINSIDE / 2;
	    if (k->t_status == TEXPLODE) {

		glyph = CLOUD_GLYPH;
		XDrawString(dpy, w, torpGC(k), dx - (cloud_width/2), 
			dy - (cloud_height/2), &glyph, 1);

		clearzone[clearcount].x = dx - (cloud_width/2);
		clearzone[clearcount].y = dy - (cloud_height/2);
		clearzone[clearcount].width = cloud_width;
		clearzone[clearcount].height = cloud_height;
		clearcount++;
	    }
	    else if (k->t_owner != me->p_no && ((k->t_war & me->p_team) ||
		      (k->t_team & (me->p_hostile | me->p_swar))))
	    {
		glyph = ETORP_GLYPH;
		XDrawString(dpy, w, torpGC(k), dx - (etorp_width/2), 
			dy - (etorp_height/2), &glyph, 1);

		clearzone[clearcount].x = dx - (etorp_width/2);
		clearzone[clearcount].y = dy - (etorp_height/2);
		clearzone[clearcount].width = etorp_width;
		clearzone[clearcount].height = etorp_height;
		clearcount++;
	    }
	    else {
		glyph = MTORP_GLYPH;
		XDrawString(dpy, w, torpGC(k), dx - (mtorp_width/2), 
			dy - (mtorp_height/2), &glyph, 1);

		clearzone[clearcount].x = dx - (mtorp_width/2);
		clearzone[clearcount].y = dy - (mtorp_height/2);
		clearzone[clearcount].width = mtorp_width;
		clearzone[clearcount].height = mtorp_height;
		clearcount++;
	    }
	}
    }
    /* Draw Edges */
    if (me->p_x < (WINSIDE / 2) * SCALE) {
	int	sy, ey;

	dx = (WINSIDE / 2) - (me->p_x) / SCALE;
	sy = (WINSIDE / 2) + (0 - me->p_y) / SCALE;
	ey = (WINSIDE / 2) + (GWIDTH - me->p_y) / SCALE;
	if (sy < 0) sy = 0;
	if (ey > WINSIDE - 1) ey = WINSIDE - 1;
	XDrawLine(dpy, w, warningGC, dx, sy, dx, ey);
	clearline[clearlcount].x1 = dx;
	clearline[clearlcount].y1 = sy;
	clearline[clearlcount].x2 = dx;
	clearline[clearlcount].y2 = ey;
	clearlcount++;
    }
    if ((GWIDTH - me->p_x) < (WINSIDE / 2) * SCALE) {
	int	sy, ey;

	dx = (WINSIDE / 2) + (GWIDTH - me->p_x) / SCALE;
	sy = (WINSIDE / 2) + (0 - me->p_y) / SCALE;
	ey = (WINSIDE / 2) + (GWIDTH - me->p_y) / SCALE;
	if (sy < 0) sy = 0;
	if (ey > WINSIDE - 1) ey = WINSIDE - 1;
	XDrawLine(dpy, w, warningGC, dx, sy, dx, ey);
	clearline[clearlcount].x1 = dx;
	clearline[clearlcount].y1 = sy;
	clearline[clearlcount].x2 = dx;
	clearline[clearlcount].y2 = ey;
	clearlcount++;
    }
    if (me->p_y < (WINSIDE / 2) * SCALE) {
	int	sx, ex;

	dy = (WINSIDE / 2) - (me->p_y) / SCALE;
	sx = (WINSIDE / 2) + (0 - me->p_x) / SCALE;
	ex = (WINSIDE / 2) + (GWIDTH - me->p_x) / SCALE;
	if (sx < 0) sx = 0;
	if (ex > WINSIDE - 1) ex = WINSIDE - 1;
	XDrawLine(dpy, w, warningGC, sx, dy, ex, dy);
	clearline[clearlcount].x1 = sx;
	clearline[clearlcount].y1 = dy;
	clearline[clearlcount].x2 = ex;
	clearline[clearlcount].y2 = dy;
	clearlcount++;
    }
    if ((GWIDTH - me->p_y) < (WINSIDE / 2) * SCALE) {
	int	sx, ex;

	dy = (WINSIDE / 2) + (GWIDTH - me->p_y) / SCALE;
	sx = (WINSIDE / 2) + (0 - me->p_x) / SCALE;
	ex = (WINSIDE / 2) + (GWIDTH - me->p_x) / SCALE;
	if (sx < 0) sx = 0;
	if (ex > WINSIDE - 1) ex = WINSIDE - 1;
	XDrawLine(dpy, w, warningGC, sx, dy, ex, dy);
	clearline[clearlcount].x1 = sx;
	clearline[clearlcount].y1 = dy;
	clearline[clearlcount].x2 = ex;
	clearline[clearlcount].y2 = dy;
	clearlcount++;
    }

    /* Change border color to signify alert status */

    if (oldalert != (me->p_flags & (PFGREEN|PFYELLOW|PFRED))) {
        oldalert = (me->p_flags & (PFGREEN|PFYELLOW|PFRED));
	switch (oldalert) {
	    case PFGREEN:
		XSetWindowBorderPixmap(dpy, baseWin, gTile);
		XSetWindowBorderPixmap(dpy, iconWin, gTile);
		break;
	    case PFYELLOW:
		XSetWindowBorderPixmap(dpy, baseWin, yTile);
		XSetWindowBorderPixmap(dpy, iconWin, yTile);
		break;
	    case PFRED:
		XSetWindowBorderPixmap(dpy, baseWin, rTile);
		XSetWindowBorderPixmap(dpy, iconWin, rTile);
		break;
	}
    }
}

/*
 * compute position of the end of the phasor
 * and return in tx and ty.
 */
phasedist(j, php, tx, ty)
    struct player *j;
    struct phaser *php;
    int *tx, *ty;
{
	*tx = j->p_x + (int) (PHASEDIST(&j->p_ship) * Cos[php->ph_dir]);
	*ty = j->p_y + (int) (PHASEDIST(&j->p_ship) * Sin[php->ph_dir]);
}

map()
{
    char buf[80];
    register int i;
    register struct player *j;
    register struct planet *l;
    int dx, dy;
    char glyph;

    if ( mclearcount ) {
	XFillRectangles( dpy, mapw, backGC, mclearzone, mclearcount );
	mclearcount = 0;
    }

    /* Draw Planets */
    for (i = 0, l = &planets[i]; i < MAXPLANETS; i++, l++) {
	if (!(l->pl_flags & PLREDRAW) && (!redrawall))
	    continue;
	dx = l->pl_x * WINSIDE / GWIDTH;
	dy = l->pl_y * WINSIDE / GWIDTH;

	glyph = mplanetGlyph(l);
	XDrawString(dpy, mapw, planetGC(l), dx - (mplanet_width/2), 
		dy - (mplanet_height/2), &glyph, 1);

	XText(mapw, dx - (mplanet_width/2), dy + (mplanet_height/2),
	    l->pl_name, 3, planetFont(l), planetColor(l), backColor);

/*
	clearzone[0][clearcount] = dx - (mplanet_width/2);
	clearzone[1][clearcount] = dy + (mplanet_height/2);
	clearzone[2][clearcount] = dfontinfo->width * 3;
	clearzone[3][clearcount] = dfontinfo->height;
	clearcount++;
	clearzone[0][clearcount] = dx - (mplanet_width/2);
	clearzone[1][clearcount] = dy - (mplanet_height/2);
	clearzone[2][clearcount] = mplanet_width;
	clearzone[3][clearcount] = mplanet_height;
	clearcount++;
*/
    }
    redrawall = 0;

    /* Draw ships */
    nplayers = 0;
    for (i = 0, j = &players[i]; i < MAXPLAYER; i++, j++) {
	XFontStruct *ptmpFStruct;
	int dummy;
	XCharStruct tmpCStruct;
	if (j->p_status != PALIVE)
	    continue;
	nplayers++;
	dx = j->p_x * WINSIDE / GWIDTH;
	dy = j->p_y * WINSIDE / GWIDTH;
	if (j->p_flags & PFCLOAK) {
	    if ((random()%(j->p_ship.s_accs*2)) == 0) {
	        ptmpFStruct = dfontinfo;
		dx+= 3-(random()%7);
		dy+= 3-(random()%7);
		XText(mapw, dx - FONTWIDTH(dfontinfo), 
		    dy - FONTHEIGHT(dfontinfo)/2,
		    "??", 2, dfont, unColor, backColor);
		XTextExtents(ptmpFStruct, "??", 2,
		    &dummy, &dummy, &dummy, &tmpCStruct);
	        mclearzone[mclearcount].x = dx - FONTWIDTH(ptmpFStruct);
	        mclearzone[mclearcount].y = dy - FONTHEIGHT(ptmpFStruct)/2;
	        mclearzone[mclearcount].width = tmpCStruct.rbearing - tmpCStruct.lbearing + 1;
	        mclearzone[mclearcount].height = tmpCStruct.ascent + tmpCStruct.descent;
	        mclearcount++;
	    }
	}
	else {
	    ptmpFStruct = shipFontInfo(j);
	    XText(mapw, dx - FONTWIDTH(ptmpFStruct), 
		dy - FONTHEIGHT(ptmpFStruct)/2,
		j->p_mapchars, 2, shipFont(j), playerColor(j), backColor);
	    XTextExtents(ptmpFStruct, j->p_mapchars, 2,
		&dummy, &dummy, &dummy, &tmpCStruct);
	    mclearzone[mclearcount].x = dx - FONTWIDTH(ptmpFStruct);
	    mclearzone[mclearcount].y = dy - FONTHEIGHT(ptmpFStruct)/2;
	    mclearzone[mclearcount].width = tmpCStruct.rbearing - tmpCStruct.lbearing + 1;
	    mclearzone[mclearcount].height = tmpCStruct.ascent + tmpCStruct.descent;
	    mclearcount++;
	}

    }
}

stline()
{
    static char buf[80] = "               0    0    0  0    0.00   0        0    0     0";

#ifndef SPRINTF
    /* Instead of one sprintf, we do all this by hand for optimization */
    static flags, speed, damage, shield, ntorp, kills, armies, fuel, wtemp, etemp;
    int changed = 0;
    static int unchanged = -1;
#ifdef DEBUG
    static int timeschanged = 0;
    static int fieldschanged = 0;
    static int timesthru = 0;
#endif /* DEBUG */

    if (buf[0] == 0) {
	int i;
	for (i=0; i<63; ++i)
	    buf[i] = ' ';
	}
	
    if (flags != me->p_flags) {
	buf[0] = (me->p_flags & PFSHIELD ? 'S': ' ');
	if (me->p_flags & PFGREEN)
	    buf[1] = 'G';
	else if (me->p_flags & PFYELLOW)
	    buf[1] = 'Y';
	else if (me->p_flags & PFRED)
	    buf[1] = 'R';
	buf[2] = (me->p_flags & (PFPLLOCK | PFPLOCK) ? 'L': ' ');
	buf[3] = (me->p_flags & PFREPAIR ? 'R': ' ');
	buf[4] = (me->p_flags & PFBOMB ? 'B': ' ');
	buf[5] = (me->p_flags & PFORBIT ? 'O': ' ');
	buf[6] = (me->p_flags & PFCLOAK ? 'C': ' ');
	buf[7] = (me->p_flags & PFWEP ? 'W': ' ');
	buf[8] = (me->p_flags & PFENG ? 'E': ' ');
	buf[9] = (me->p_flags & PFBEAMUP ? 'u': ' ');
	buf[10] = (me->p_flags & PFBEAMDOWN ? 'd': ' ');
	buf[11] = (me->p_flags & PFCOPILOT ? 'P' : ' ');
	flags = me->p_flags;
	++changed;
	}
    if (speed != me->p_speed) {
	buf[14] = (me->p_speed>9?'0'+((me->p_speed/10)%10):' ');
	buf[15] = '0' + (me->p_speed%10);	/* speed */
	speed = me->p_speed;
	++changed;
    }
    if (damage != me->p_damage) {
	buf[17] = '0' + (me->p_damage / 1000);
	if (buf[17] == '0')
	    buf[17] = ' ';
	buf[18] = '0' + ((me->p_damage % 1000) / 100);
	if ((buf[18] == '0') && (me->p_damage < 1000))
	    buf[18] = ' ';
	buf[19] = '0' + ((me->p_damage % 100) / 10);
	if ((buf[19] == '0') && (me->p_damage < 100))
	    buf[19] = ' ';
	buf[20] = '0' + (me->p_damage % 10);
	damage = me->p_damage;
	++changed;
    }

    if (shield != me->p_shield) {
	buf[22] = '0' + (me->p_shield / 1000);
	if (buf[22] == '0')
	    buf[22] = ' ';
	buf[23] = '0' + ((me->p_shield % 1000) / 100);
	if ((buf[23] == '0') && (me->p_shield < 1000))
	    buf[23] = ' ';
	buf[24] = '0' + ((me->p_shield % 100) / 10);
	if ((buf[23] == '0') && (me->p_shield < 100))
	    buf[23] = ' ';
	buf[25] = '0' + (me->p_shield % 10);
	shield = me->p_shield;
	++changed;
    }
    if (ntorp != me->p_ntorp) {
	buf[27] = '0' + ((me->p_ntorp % 100) / 10);
	if (buf[27] == '0')
	    buf[27] = ' ';
	buf[28] = '0' + (me->p_ntorp % 10);
	ntorp = me->p_ntorp;
	++changed;
    }
    if (kills != me->p_kills) {
	buf[32] = '0' + ((int) (me->p_kills / 10));
	if (buf[32] == '0')
	    buf[32] = ' ';
	buf[33] = '0' + (((int) me->p_kills) % 10);
	buf[34] = '.';
	buf[35] = '0' + (((int) (me->p_kills * 10)) % 10);
	buf[36] = '0' + (((int) (me->p_kills * 100)) % 10);
	kills = me->p_kills;
	++changed;
    }
    if (armies != me->p_armies) {
	buf[39] = '0' + ((me->p_armies % 100) / 10);
	if (buf[39] == '0')
	    buf[39] = ' ';
	buf[40] = '0' + (me->p_armies % 10);
	armies = me->p_armies;
	++changed;
    }

    if (fuel != me->p_fuel) {
/*  I should really fix this at some point
	buf[44] = '0' + (me->p_fuel / 100000);
	if (buf[44] == '0')
	    buf[44] = ' ';
	buf[45] = '0' + ((me->p_fuel % 100000) / 10000);
	if ((buf[45] == '0') && (me->p_fuel < 100000))
*/
	buf[45] = '0' + (me->p_fuel / 10000);
	if (buf[45] == '0')
	    buf[45] = ' ';
	buf[46] = '0' + ((me->p_fuel % 10000) / 1000);
	if ((buf[46] == '0') && (me->p_fuel < 10000))
	    buf[46] = ' ';
	buf[47] = '0' + ((me->p_fuel % 1000) / 100);
	if ((buf[47] == '0') && (me->p_fuel < 1000))
	    buf[47] = ' ';
	buf[48] = '0' + ((me->p_fuel % 100) / 10);
	if ((buf[48] == '0') && (me->p_fuel < 100))
	    buf[48] = ' ';
	buf[49] = '0' + (me->p_fuel % 10);
	fuel = me->p_fuel;
	++changed;
    }

    if (wtemp != me->p_wtemp && wtemp/10 != me->p_wtemp/10) {
	buf[52] = '0' + ((me->p_wtemp / 10) / 100);
	if (buf[52] == '0')
	    buf[52] = ' ';
	buf[53] = '0' + (((me->p_wtemp / 10) % 100) / 10);
	if ((buf[53] == '0') && (me->p_wtemp < 1000))
	    buf[53] = ' ';
	buf[54] = '0' + ((me->p_wtemp / 10) % 10);
	wtemp = me->p_wtemp;
	++changed;
    }

    if (etemp != me->p_etemp && etemp/10 != me->p_etemp/10) {
	buf[58] = '0' + ((me->p_etemp / 10) / 100);
	if (buf[58] == '0')
	    buf[58] = ' ';
	buf[59] = '0' + (((me->p_etemp / 10) % 100) / 10);
	if ((buf[59] == '0') && (me->p_etemp < 1000))
	    buf[59] = ' ';
	buf[60] = '0' + ((me->p_etemp / 10) % 10);
	etemp = me->p_etemp;
	++changed;
    }

    /* Draw status line */
    if (changed || (++unchanged&07) == 0)
    {
	XText(tstatw, tstatoffset, FONTHEIGHT(dfontinfo) + 3 * MESSAGEBD + borderSize,
		buf, 61, dfont, textColor, backColor);
	unchanged = 0;

#ifdef DEBUG
	timeschanged++;
	fieldschanged+=changed;
#endif /* DEBUG */
    }
#ifdef DEBUG
    timesthru++;
#endif /* DEBUG */

#else

    /* This code is being left around because it is much more elegant
    ** than that above.  However, it lacks a tremendous amount in efficiency.
    */
    char alertchar = '?';

    if (me->p_flags & PFGREEN)
	alertchar = 'G';
    else if (me->p_flags & PFYELLOW)
	alertchar = 'Y';
    else if (me->p_flags & PFRED)
	alertchar = 'R';
    /* Draw status line */
    sprintf(buf,
"%c%c%c%c%c%c%c%c%c%c%c%c   %1d %4d %4d %2d   %5.2f  %2d   %6d  %3d   %3d",
	(me->p_flags & PFSHIELD ? 'S': ' '),
	alertchar,
	(me->p_flags & (PFPLLOCK | PFPLOCK) ? 'L': ' '),
	(me->p_flags & PFREPAIR ? 'R': ' '),
	(me->p_flags & PFBOMB ? 'B': ' '),
	(me->p_flags & PFORBIT ? 'O': ' '),
	(me->p_flags & PFCLOAK ? 'C': ' '),
	(me->p_flags & PFWEP ? 'W': ' '),
	(me->p_flags & PFENG ? 'E': ' '),
	(me->p_flags & PFBEAMUP ? 'u': ' '),
	(me->p_flags & PFBEAMDOWN ? 'd': ' '),
	(me->p_flags & PFCOPILOT ? 'P' : ' '),
	me->p_speed,
	me->p_damage,
	me->p_shield,
	me->p_ntorp,
	me->p_kills,
	me->p_armies,
	me->p_fuel,
	me->p_wtemp/10,
	me->p_etemp/10);
    XText(tstatw, tstatoffset, FONTHEIGHT(dfontinfo) + 3 * MESSAGEBD + borderSize, 
		buf, 63, dfont, textColor, backColor);

#endif /* sprintf */
}

/* These are routines that need to be done on interrupts but
   don't belong in the redraw routine and particularly don't
   belong in the daemon. */

auto_features()
{
    char buf[80];
    struct player *pl;
    struct planet *pln;
    unsigned char course;

    if (copilot && (!(me->p_flags & PFCOPILOT))) {
	printf("Owning player has kicked you out\n");
	exit(0);
    }
    if ((!copilot) && (!watch)  && (me->p_flags & PFSELFDEST)) {
	if ((me->p_updates >= selfdest) ||
	    ((me->p_flags & PFGREEN) && (me->p_damage == 0)
		&& (me->p_shield == me->p_ship.s_maxshields))) {
	    me->p_flags &= ~PFSELFDEST;
	    me->p_explode = 10;
	    me->p_whydead = KQUIT;
	    me->p_status = PEXPLODE;
	}
	else {
	    sprintf(buf, "Self Destruct in %d seconds",
		(selfdest - me->p_updates) / 10);
	    warning(buf);
	}
    }
    /* give certain information about bombing or beaming */
    if (me->p_flags & PFBOMB) {
	if (planets[me->p_planet].pl_armies < 5) {
	    sprintf(buf, "Cannot bomb %s while armies are less than 5",
		planets[me->p_planet].pl_name);
	    warning(buf);
	    if (! (copilot || watch))
		me->p_flags &= ~PFBOMB;
	}
	else {
	    sprintf(buf, "Bombing %s.  %d armies left",
		planets[me->p_planet].pl_name,
		planets[me->p_planet].pl_armies);
	    warning(buf);
	}
    }

    if (me->p_flags & PFBEAMUP) {
	if (planets[me->p_planet].pl_armies < 5) {
	    sprintf(buf, "%s: Too few armies to beam up",
		planets[me->p_planet].pl_name);
	    warning(buf);
	    if (! (copilot || watch))
		me->p_flags &= ~PFBEAMUP;
	}
	else if ((me->p_armies == (int) (me->p_kills * 2)) ||
	    (me->p_armies == myship->s_maxarmies)) {
		sprintf(buf, "No more room on board for armies");
	    warning(buf);
	    if (! (copilot || watch))
		me->p_flags &= ~PFBEAMUP;
	}
	else {
	    sprintf(buf, "Beaming up.  (%d/%d)", me->p_armies,
		((me->p_kills * 2) > myship->s_maxarmies) ?
		    myship->s_maxarmies : (int) (me->p_kills * 2));
	    warning(buf);
	}
    }
    if (me->p_flags & PFBEAMDOWN) {
	if (me->p_armies == 0) {
	    sprintf(buf, "No more armies to beam down to %s.",
		planets[me->p_planet].pl_name);
	    warning(buf);
	    if (! (copilot || watch))
		me->p_flags &= ~PFBEAMDOWN;
	}
	else {
	    sprintf(buf, "Beaming down.  (%d/%d) %s has %d armies left",
		me->p_armies,
		((me->p_kills * 2) > myship->s_maxarmies) ?
		    myship->s_maxarmies : (int) (me->p_kills * 2),
		planets[me->p_planet].pl_name,
		planets[me->p_planet].pl_armies);
	    warning(buf);
	}
    }
    if (me->p_flags & PFREPAIR) {
	if ((me->p_damage == 0) && (me->p_shield == myship->s_maxshields))
	    if (! (copilot || watch))
		me->p_flags &= ~PFREPAIR;
    }
    if (me->p_flags & PFPLOCK) { 	/* set course to player x */
	pl = &players[me->p_playerl];
	if (pl->p_status != PALIVE)
	    me->p_flags &= ~PFPLOCK;
	course = newcourse(pl->p_x, pl->p_y);
	set_course(course);
    }
    if (me->p_flags & PFPLLOCK) { 	/* set course to planet x */
	int dist;
	pln = &planets[me->p_planet];
	dist = hypot((double) (me->p_x - pln->pl_x),
	    (double) (me->p_y - pln->pl_y));

	/* This is magic.  It should be based on defines, but it slows
	   the ship down to warp two an appropriate distance from the
	   planet for orbit */

	if (dist < (50 * ((me->p_speed * (me->p_speed+1)) + 10)))
	    set_speed(2);
	if ((dist < ENTORBDIST) && (me->p_speed <= 2))  {
	    me->p_flags &= ~PFPLLOCK;
	    orbit();
	}
	else {
	    course = newcourse(pln->pl_x, pln->pl_y);
	    set_course(course);
	}
    }
}

newcourse(x, y)
int x, y;
{
#ifdef SYSATAN2
	return((unsigned char) (atan2((double) (x - me->p_x),
	    (double) (me->p_y - y)) / 3.14159 * 128.));
#else
	return( myatan2( x - me->p_x, me->p_y - y ) );
#endif
}

redrawTstats()
{
    char	buf[BUFSIZ];
    
    tstatoffset = ( WINSIDE - ( 63 * FONTWIDTH(dfontinfo) ) ) / 2;
    if ( tstatoffset < MESSAGEBD )
	tstatoffset = MESSAGEBD;
    
    sprintf(buf, 
	"Flags        warp dam shd torps kills armies fuel  wtemp etemp");
    XText(tstatw, tstatoffset, MESSAGEBD, buf, strlen(buf), dfont, textColor, backColor);
}
