
/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/*
 * X11 support and other enhancements added by Jeff Weinstein
 * (jeff@polyslo.calpoly.edu).  Please send all comments, bug
 * reports, fixes, suggestions regarding this version of XTrek
 * to me.  
 */

static char RCSID[] = "$Header: /blackbird/home/jeff/TAPE2/xtrek.new/RCS/pstats.c,v 3.1 88/09/20 00:44:38 jeff Exp $";

#include <X11/Xlib.h>
#include <X11/Xos.h>
#include <stdio.h>
#include <sys/resource.h>
#include <signal.h>
#include <setjmp.h>
#include "defs.h"
#include "struct.h"
#include "data.h"

static int fd;
static struct stats old;
static struct rusage buf;
static long now;

savestats()
{
    fd = open(SCOREFILE, O_RDWR, 0777);

    if (fd < 0) return;

    lseek(fd, getuid() * sizeof(struct stats), 0);
    read(fd, &old, sizeof(struct stats));

    me->p_stats.st_kills += old.st_kills;
    me->p_stats.st_losses += old.st_losses;
    me->p_stats.st_entries += old.st_entries;
    me->p_stats.st_conqs += old.st_conqs;
    me->p_stats.st_coups += old.st_coups;
    me->p_stats.st_torps += old.st_torps;
    me->p_stats.st_phasers += old.st_phasers;
    me->p_stats.st_armsbomb += old.st_armsbomb;
    me->p_stats.st_armsship += old.st_armsship;
    me->p_stats.st_planets += old.st_planets;
    me->p_stats.st_genocides += old.st_genocides;

    time(&now);
    me->p_stats.st_time = old.st_time + (now - start_time);

    getrusage(0, &buf);
    me->p_stats.st_cpu = old.st_cpu + buf.ru_utime.tv_sec + buf.ru_stime.tv_sec;

    if (oldmax > old.st_maxkills)
	mystats->st_maxkills = oldmax;
    else
	mystats->st_maxkills = old.st_maxkills;

    lseek(fd, getuid() * sizeof(struct stats), 0);
    write(fd, mystats, sizeof(struct stats));
}
