
/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/*
 * X11 support and other enhancements added by Jeff Weinstein
 * (jeff@polyslo.calpoly.edu).  Please send all comments, bug
 * reports, fixes, suggestions regarding this version of XTrek
 * to me.  
 */

static char RCSID[] = "$Header: /blackbird/home/jeff/TAPE2/xtrek.new/RCS/playerlist.c,v 3.1 88/09/20 00:44:36 jeff Exp $";

#include <X11/Xlib.h>
#include <stdio.h>
#include "defs.h"
#include "struct.h"
#include "data.h"

playerlist()
{
    register int i;
    register int k = 0;
    char buf[BUFSIZ];
    register struct player *j;

    (void) sprintf(buf, " # Team Name             Login    Display          dir spd kills");
    XText(playerw, 0, FONTHEIGHT(dfontinfo), buf,
       strlen(buf), dfont, textColor, backColor);
    k = 2;
    for (i = 0, j = &players[i]; i < MAXPLAYER; i++, j++) {
	if (j->p_status != PALIVE)
	    continue;
	(void) sprintf(buf, " %1x  %1c   %-16.16s %-8s %-16.16s %3d %3d %5.2f",
	    j->p_no,
	    teamlet[j->p_team],
	    j->p_name,
	    j->p_login,
	    j->p_monitor,
	    j->p_dir,
	    j->p_speed,
	    j->p_kills);
	XText(playerw, 0, FONTHEIGHT(dfontinfo) * k++, buf, strlen(buf),
	   shipFont(j), playerColor(j), backColor);
    }
    XFlush(dpy);
}
