
/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/*
 * X11 support and other enhancements added by Jeff Weinstein
 * (jeff@polyslo.calpoly.edu).  Please send all comments, bug
 * reports, fixes, suggestions regarding this version of XTrek
 * to me.  
 */

static char RCSID[] = "$Header: /blackbird/home/jeff/TAPE2/xtrek.new/RCS/planetlist.c,v 3.1 88/09/20 00:44:34 jeff Exp $";


#include <X11/Xlib.h>
#include <stdio.h>
#include "defs.h"
#include "struct.h"
#include "data.h"

static char *teamname[9] = {
    "IND",
    "FED",
    "ROM",
    "",
    "KLI",
    "",
    "",
    "",
    "ORI"
};

/*
** Open a window which contains all the planets and their current
** statistics.  Players will not know about planets that their team
** has not orbited.
*/

planetlist()
{
    register int i;
    register int k = 0;
    char buf[BUFSIZ];
    register struct planet *j;

    (void) sprintf(buf, "  # Planet Name      own armies REPAIR FUEL");
    XText(planetw, 0, MESSAGEBD, buf,
       strlen(buf), dfont, textColor, backColor);
    k = 1;
    for (i = 0, j = &planets[i]; i < MAXPLANETS; i++, j++) {
	if (j->pl_info & me->p_team) {
	    (void) sprintf(buf, " %2d %-16s %3s %3d    %6s %4s",
		j->pl_no,
		j->pl_name,
		teamname[j->pl_owner],
		j->pl_armies,
		(j->pl_flags & PLREPAIR ? "REPAIR" : "      "),
		(j->pl_flags & PLFUEL ? "FUEL" : "    "));
	    XText(planetw, 0, MESSAGEBD + FONTHEIGHT(dfontinfo) * k++, buf, 
		strlen(buf), planetFont(j), planetColor(j), backColor);
	}
	else {
	    (void) sprintf(buf, " %2d %-16s",
		j->pl_no,
		j->pl_name);
	    XText(planetw, 0, MESSAGEBD + FONTHEIGHT(dfontinfo) * k++, buf,
	        strlen(buf), dfont, unColor, backColor);
	}
    }
    XFlush(dpy);
}
