
/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/*
 * X11 support and other enhancements added by Jeff Weinstein
 * (jeff@polyslo.calpoly.edu).  Please send all comments, bug
 * reports, fixes, suggestions regarding this version of XTrek
 * to me.  
 */

static char RCSID[] = "$Header: /blackbird/home/jeff/TAPE2/xtrek.new/RCS/inform.c,v 3.1 88/09/20 00:44:07 jeff Exp $";

#include <X11/Xlib.h>
#include <stdio.h>
#include <math.h>
#include <signal.h>
#include "defs.h"
#include "struct.h"
#include "data.h"


/* Display information about the nearest objext to mouse */

/*
** When the player asks for info, this routine finds the object
** nearest the mouse, either player or planet, and pop up a window
** with the desired information in it.
** 
** We intentionally provide less information than is actually
** available.  Keeps the fog of war up.
**
** There is a different sized window for each type player/planet
** and we take care to keep it from extending beyond the main
** window boundaries.
*/

static struct obtype *target;

inform(ww, x, y)
Window ww;
int x, y;
{
    int mx, my;
    Window subw;
    struct obtype *gettarget();
    static int windowWidth = 0;
    static int windowHeight = 0;
    int tmp;
    XSetWindowAttributes attr;

    infomapped = 1;
    target = gettarget(ww, x, y, TARG_PLAYER|TARG_PLANET);

    if (windowWidth == 0)
	XGetGeometry(dpy, ww, &tmp, &tmp, &tmp, &windowWidth, &windowHeight, &tmp, &tmp);

    XQueryPointer(dpy, ww, &tmp, &subw, &tmp, &tmp, &mx, &my, &tmp);

    if (target->o_type == PLAYERTYPE) 
	{
	/* Too close to the edge? */
	if (mx + 23 * FONTWIDTH(dfontinfo) + 2 > windowWidth)
	    mx = windowWidth - 23 * FONTWIDTH(dfontinfo) - 2;
	if (my + 7 * FONTHEIGHT(dfontinfo) + 2 > windowHeight)
	    my = windowHeight - 7 * FONTHEIGHT(dfontinfo) - 2;

	attr.background_pixmap = backTile;
	attr.border_pixmap = foreTile;
	attr.event_mask = ExposureMask;
	infow = XCreateWindow(dpy, ww, mx, my, 23 * FONTWIDTH(dfontinfo), 
	    7 * FONTHEIGHT(dfontinfo), 2, DefaultDepth(dpy, screen), 
	    InputOutput, DefaultVisual(dpy, screen), 
	    CWBackPixmap | CWBorderPixmap | CWEventMask , &attr);
	XMapWindow(dpy, infow);
	}
    else  /* Planet */
	{ 
	/* Too close to the edge? */
	if (mx + 20 * FONTWIDTH(dfontinfo) + 2 > windowWidth)
	    mx = windowWidth - 20 * FONTWIDTH(dfontinfo) - 2;
	if (my + 3 * FONTHEIGHT(dfontinfo) + 2 > windowHeight)
	    my = windowHeight - 3 * FONTHEIGHT(dfontinfo) - 2;

	attr.background_pixmap = backTile;
	attr.border_pixmap = foreTile;
	attr.event_mask = ExposureMask;
	infow = XCreateWindow(dpy, ww, mx, my, 20 * FONTWIDTH(dfontinfo), 
	    3 * FONTHEIGHT(dfontinfo), 2, DefaultDepth(dpy, screen), 
	    InputOutput, DefaultVisual(dpy, screen), 
	    CWBackPixmap | CWBorderPixmap | CWEventMask , &attr);

	XMapWindow(dpy, infow);

	XFlush(dpy);
	}
    }



destroyInfo()
{
    XDestroyWindow(dpy, infow);
    infomapped = 0;
}

drawInfo()
{
    register struct player *j;
    register struct planet *k;
    int line = 0;
    char buf[BUFSIZ];
    double dist;
    
    if ( infomapped )
	{

	XClearWindow( dpy, infow );

	if ( target->o_type == PLAYERTYPE )
	    {
	
	    j = &players[target->o_num];
	    dist = hypot((double) (me->p_x - j->p_x),
			 (double) (me->p_y - j->p_y));
	    (void) sprintf(buf, "%s (%c%1x):", j->p_name, teamlet[j->p_team], j->p_no);
	    XText(infow, FONTWIDTH(dfontinfo), FONTHEIGHT(dfontinfo) * line++, buf,
		  strlen(buf), shipFont(j), playerColor(j), backColor);
	    (void) sprintf(buf, "Login   %-s", j->p_login);
	    XText(infow, FONTWIDTH(dfontinfo), FONTHEIGHT(dfontinfo) * line++, buf,
		  strlen(buf), dfont, playerColor(j), backColor);
	    (void) sprintf(buf, "Display %-s", j->p_monitor);
	    XText(infow, FONTWIDTH(dfontinfo), FONTHEIGHT(dfontinfo) * line++, buf,
		  strlen(buf), dfont, playerColor(j), backColor);
	    (void) sprintf(buf, "Speed   %-d", j->p_speed);
	    XText(infow, FONTWIDTH(dfontinfo), FONTHEIGHT(dfontinfo) * line++, buf,
		  strlen(buf), dfont, playerColor(j), backColor);

	    /*  Too much information.  Let 'em wonder
		(void) sprintf(buf, "Damage  %-d", j->p_damage);
		XText(infow, FONTWIDTH(dfontinfo), FONTHEIGHT(dfontinfo) * line++, buf,
		strlen(buf), dfont, playerColor(j), backColor);
		(void) sprintf(buf, "Shields %-d", j->p_shield);
		XText(infow, FONTWIDTH(dfontinfo), FONTHEIGHT(dfontinfo) * line++, buf,
		strlen(buf), dfont, playerColor(j), backColor);
	    */

	    (void) sprintf(buf, "kills   %-4.2f", j->p_kills);
	    XText(infow, FONTWIDTH(dfontinfo), FONTHEIGHT(dfontinfo) * line++, buf,
		  strlen(buf), dfont, playerColor(j), backColor);
	    (void) sprintf(buf, "dist    %-d", (int) dist);
	    XText(infow, FONTWIDTH(dfontinfo), FONTHEIGHT(dfontinfo) * line++, buf,
		  strlen(buf), dfont, playerColor(j), backColor);
	    if (j->p_swar & me->p_team)
		XText(infow, FONTWIDTH(dfontinfo), FONTHEIGHT(dfontinfo) * line++, "WAR",
		      3, dfont, playerColor(j), backColor);
	    else if (j->p_hostile & me->p_team)
		XText(infow, FONTWIDTH(dfontinfo), FONTHEIGHT(dfontinfo) * line++,
		      "HOSTILE", 7, dfont, playerColor(j), backColor);
	    else
		XText(infow, FONTWIDTH(dfontinfo), FONTHEIGHT(dfontinfo) * line++,
		      "PEACEFUL", 8, dfont, playerColor(j), backColor);
	    }
	else   /* planet */
	    {
	    
	    k = &planets[target->o_num];
	    dist = hypot((double) (me->p_x - k->pl_x),
			 (double) (me->p_y - k->pl_y));
	    if (k->pl_info & me->p_team)
		{
		(void) sprintf(buf, "%s (%c)", k->pl_name, teamlet[k->pl_owner]);
		XText(infow, FONTWIDTH(dfontinfo), FONTHEIGHT(dfontinfo) * line++, buf,
		      strlen(buf), planetFont(k), planetColor(k), backColor);
		(void) sprintf(buf, "Armies %d", k->pl_armies);
		XText(infow, FONTWIDTH(dfontinfo), FONTHEIGHT(dfontinfo) * line++, buf,
		      strlen(buf), dfont, planetColor(k), backColor);
		(void) sprintf(buf, "%s %s  %c%c%c%c",
			       (k->pl_flags & PLREPAIR ? "REPAIR" : "      "),
			       (k->pl_flags & PLFUEL ? "FUEL" : "    "),
			       (k->pl_info & FED ? 'F' : ' '),
			       (k->pl_info & ROM ? 'R' : ' '),
			       (k->pl_info & KLI ? 'K' : ' '),
			       (k->pl_info & ORI ? 'O' : ' '));
		XText(infow, FONTWIDTH(dfontinfo), FONTHEIGHT(dfontinfo) * line++, buf,
		      strlen(buf), dfont, planetColor(k), backColor);
		}
	    else
		{
		(void) sprintf(buf, "%s", k->pl_name);
		XText(infow, FONTWIDTH(dfontinfo), FONTHEIGHT(dfontinfo) * line++, buf,
		      strlen(buf), dfont, planetColor(k), backColor);
		(void) sprintf(buf, "No other info");
		XText(infow, FONTWIDTH(dfontinfo), FONTHEIGHT(dfontinfo) * line++, buf,
		      strlen(buf), dfont, planetColor(k), backColor);
		}
	    }

	XFlush(dpy);
	
	}
    }

