
/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/*
 * X11 support and other enhancements added by Jeff Weinstein
 * (jeff@polyslo.calpoly.edu).  Please send all comments, bug
 * reports, fixes, suggestions regarding this version of XTrek
 * to me.  
 */

/*
 * $Header: /blackbird/home/jeff/TAPE2/xtrek.new/RCS/defs.h,v 3.1 88/09/20 00:45:29 jeff Exp $
 */

#include "xtrekfont.h"

#define MAXPLAYER 16
#define MAXPLANETS 40
#define MAXTORP 12
#define PKEY 257

#define MESSAGEBD 4	/* size of white space around message text */
#define YOFF 100

#ifdef VARSIDE
#undef WINSIDE
#undef SCALE
#define WINSIDE winside
#define SCALE	scale
#endif

#ifndef WINSIDE
#define WINSIDE 512
#endif

/* These are configuration definitions */

#define GWIDTH 100000   /* galaxy is 100000 spaces on a side */
#define WARP1 20	/* warp one will move 20 spaces per update */

#ifndef SCALE
#define SCALE 40	/* Window will be one pixel for 16 spaces */
#endif

#define EXPDIST 400	/* At this range a torp will explode */
#define DETDIST 2500	/* At this range a player can detonate a torp */
#define PHASEDIST(s)	((s)->s_phaserdamage*60) 	/* At this range a player can do damage with phasers */
#define ENTORBDIST 900	/* At this range a player can orbit a planet */
#define ORBDIST 800	/* A player will orbit at this radius */
#define ORBSPEED 2	/* This is the fastest a person can go into orbit */
#define PFIREDIST 1500	/* At this range a planet will shoot at a player */
#define UPDATE 100000	/* Update time is 100000 micro-seconds */
#define AUTOQUIT 60	/* auto logout in 60 secs */


/* These are memory sections */
#define PLAYER 1
#define MAXMESSAGE 50

#define rosette(x)	((((x) + 256/VIEWS/2) / (256/VIEWS)) % VIEWS)

/* These are the teams */
/* Note that I used bit types for these mostly for messages and
   war status.  This was probably a mistake.  It meant that Ed
   had to add the 'remap' area to map these (which are used throughout
   the code as the proper team variable) into a nice four team deep
   array for his color stuff.  Oh well.
*/
#define NOBODY 0x0
#define FED 0x1
#define ROM 0x2
#define KLI 0x4
#define ORI 0x8
#define ALLTEAM (FED|ROM|KLI|ORI)
#define MAXTEAM (ORI)
#define NUMTEAM 4
/*
** These are random configuration variables
*/
#define VICTORY 30	/* Number of planets needed to conquer the galaxy */
#define WARNTIME 30	/* Number of updates to have a warning on the screen */
#define MESSTIME 30	/* Number of updates to have a message on the screen */

#define TARG_PLAYER	0x1	/* Flags for gettarget */
#define TARG_PLANET	0x2
#define TARG_CLOAK	0x4	/* Include cloaked ships in search */

/* Data files to make the game play across daemon restarts. */

#ifndef LIBDIR
#define LIBDIR		"/usr/local/lib/xtrek
#endif /* LIBDIR */

#ifndef FONTDIR
#define FONTDIR		LIBDIR"
#endif /* FONTDIR */

#define PLFILE		LIBDIR/.planets"
#define SCOREFILE	LIBDIR/.scores"
#define MOTD		LIBDIR/.motd"
#define DAEMON		LIBDIR/daemon"
#define ROBOT		LIBDIR/robot"

/* Other stuff that Ed added */

#ifdef __HIGHC__
#define ABS(a)			_abs(a)
#else
#define ABS(a)			/* abs(a) */ (((a) < 0) ? -(a) : (a))
#endif /* __HIGHC__ */

#define myTorp(t)		(me->p_no == (t)->t_owner)
#define friendlyTorp(t)		((!(me->p_team & (t)->t_war)) || (myTorp(t)))
#define myPhaser(p)		(&phasers[me->p_no] == (p))
#define friendlyPhaser(p)	(me->p_team == players[(p) - phasers].p_team)
#define myPlayer(p)		(me == (p))
#define myPlanet(p)		(me->p_team == (p)->pl_owner)
#define friendlyPlayer(p)	((!(me->p_team & \
				    ((p)->p_swar | (p)->p_hostile))) && \
				    (!((p)->p_team & \
				    (me->p_swar | me->p_hostile))))
#define isAlive(p)		((p)->p_status == PALIVE)
#define friendlyPlanet(p)	((p)->pl_info & me->p_team && \
			     !((p)->pl_owner & (me->p_swar | me->p_hostile)))

#define torpColor(t)		\
	(myTorp(t) ? myColor : shipCol[remap[players[(t)->t_owner].p_team]])
#define torpGC(t)		\
	(myTorp(t) ? myGC : shipGC[remap[players[(t)->t_owner].p_team]])
#define phaserColor(p)		\
	(myPhaser(p) ? myColor : shipCol[remap[players[(p) - phasers].p_team]])
#define phaserGC(p)		\
	(myPhaser(p) ? myGC : shipGC[remap[players[(p) - phasers].p_team]])
#define playerColor(p)		\
	(myPlayer(p) ? myColor : shipCol[remap[(p)->p_team]])
#define playerGC(p)		\
	(myPlayer(p) ? myGC : shipGC[remap[(p)->p_team]])
#define planetColor(p)		\
	(((p)->pl_info & me->p_team) ? shipCol[remap[(p)->pl_owner]] : unColor)
#define planetGC(p)		\
	(((p)->pl_info & me->p_team) ? shipGC[remap[(p)->pl_owner]] : unGC)
#define mplanetGlyph(p)		\
	((((p)->pl_info & me->p_team) ? \
	( mono ? remap[(p)->pl_owner] : 0 ) : 0)+MPLANET_GLYPHS)
#define planetGlyph(p)		\
	((((p)->pl_info & me->p_team) ? \
	( mono ? remap[(p)->pl_owner] : 0 ) : 0)+PLANET_GLYPHS)

#define planetFont(p)		\
	(myPlanet(p) ? bfont : friendlyPlanet(p) ? ifont : dfont)
#define planetFontInfo(p)		\
	(myPlanet(p) ? bfontinfo : friendlyPlanet(p) ? ifontinfo : dfontinfo)
#define shipFont(p)		\
	(myPlayer(p) ? bfont : friendlyPlayer(p) ? ifont : dfont)
#define shipFontInfo(p)		\
	(myPlayer(p) ? bfontinfo : friendlyPlayer(p) ? ifontinfo : dfontinfo)

#define FONTHEIGHT(f) (((f)->max_bounds.ascent) + ((f)->max_bounds.descent))
#define FONTWIDTH(f) (((f)->max_bounds.rbearing) - ((f)->max_bounds.lbearing))
#define dpyno() (ConnectionNumber(dpy))
