
/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/*
 * X11 support and other enhancements added by Jeff Weinstein
 * (jeff@polyslo.calpoly.edu).  Please send all comments, bug
 * reports, fixes, suggestions regarding this version of XTrek
 * to me.  
 */

static char RCSID[] = "$Header: /blackbird/home/jeff/TAPE2/xtrek.new/RCS/coup.c,v 3.1 88/09/20 00:43:44 jeff Exp $";

#include <X11/Xlib.h>

#include <stdio.h>
#include <sys/types.h>
#ifndef ibm032
#include <sys/ipc.h>
#include <sys/shm.h>
#endif ibm032
#include "defs.h"
#include "struct.h"
#include "data.h"

/* throw a coup */

coup()
{
    register int i;
    register struct planet *l;

    if (me->p_kills < 1.0) {
	warning("You must have one kill to throw a coup");
	return;
    }
    if (!(me->p_flags & PFORBIT)) {
	warning("You must orbit your home planet to throw a coup");
	return;
    }
    for (i = 0, l = &planets[i]; i < MAXPLANETS; i++, l++) {
	if ((l->pl_owner == me->p_team) && (l->pl_armies > 0)) {
	    warning("You already own a planet!!!");
	    return;
	}
    }
    l = &planets[me->p_planet];

    if ((!(l->pl_flags & PLHOME)) || ((l->pl_flags & ALLTEAM) != me->p_team)) {
	warning("You must orbit your home planet to throw a coup");
	return;
    }

    if (l->pl_armies > 4) {
	warning("Too many armies on planet to throw a coup");
	return;
    }

    if (l->pl_couptime > 0) {
	warning("Planet not yet ready for a coup");
	return;
    }

    if (l->pl_flags & PLCOUP) { /* Avoid race conditions */
	return;
    }

    /* the cases are now met.  We can have a coup. */

    l->pl_flags |= PLCOUP;
    mystats->st_coups++;
}
