
/*

	Copyright (c) 1986 	Chris Guthrie

Permission to use, copy, modify, and distribute this
software and its documentation for any purpose and without
fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting
documentation.  No representations are made about the
suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.

*/

/*
 * X11 support and other enhancements added by Jeff Weinstein
 * (jeff@polyslo.calpoly.edu).  Please send all comments, bug
 * reports, fixes, suggestions regarding this version of XTrek
 * to me.  
 */

static char RCSID[] = "$Header: /blackbird/home/jeff/TAPE2/xtrek.new/RCS/colors.c,v 3.1 88/09/20 00:43:16 jeff Exp $";

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xos.h>
#include "data.h"

typedef struct assoc {
	char	*str;
	int	*colorp;
	GC	*gc;
	int	bWDef;
	char	*colorDef;
} ASSOC;

ASSOC	assoc[] = {
	{ "border",	&borderColor,	&borderGC,	1,	"blue"		},
	{ "background",	&backColor,	&backGC,	0,	"black"		},
	{ "text",	&textColor,	&textGC,	1,	"white"		},
	{ "nobody",	&shipCol[0],	&shipGC[0],	1,	"blue"	},
	{ "fed",	&shipCol[1],	&shipGC[1],	1,	"yellow",	},
	{ "rom",	&shipCol[2],	&shipGC[2],	1,	"red",		},
	{ "kli",	&shipCol[3],	&shipGC[3],	1,	"green",	},
	{ "ori",	&shipCol[4],	&shipGC[4],	1,	"#0ff",	},
	{ "warning",	&warningColor,	&warningGC,	1,	"red"		},
	{ "unknown",	&unColor,	&unGC,		1,	"light grey"	},
	{ "ralert",	&rColor,	&rGC,		1,	"red"		},
	{ "yalert",	&yColor,	&yGC,		1,	"yellow"	},
	{ "galert",	&gColor,	&gGC,		1,	"green"		},
	{ "me",		&myColor,	&myGC,		1,	"white"		}
};

getColorDefs(prog)
	char	*prog;
{
	int	i, invert = 0;
	char	*color;
	XColor	def;

	if ( mono ) {	/* b & w */
		invert = booleanDefault(prog, "reverseVideo");
		for (i = 0; i < sizeof (assoc) / sizeof (*assoc); i++) {
			assoc[i].bWDef = assoc[i].bWDef 
				? WhitePixel(dpy, screen) 
				: BlackPixel(dpy, screen);
			*assoc[i].colorp = 
				invert ? !assoc[i].bWDef : assoc[i].bWDef;
			*assoc[i].gc = XCreateGC( dpy, root, 0, 0 );
			XSetForeground( dpy, *assoc[i].gc, *assoc[i].colorp );
			XSetFont(dpy, *assoc[i].gc, xtrekfont);
		}
	} else {
		for (i = 0; i < sizeof (assoc) / sizeof (*assoc); i++) {
			if ((color = XGetDefault(dpy, prog, assoc[i].str)) == NULL)
				color = assoc[i].colorDef;
			XParseColor(dpy, cmap, color, &def);
			XAllocColor(dpy, cmap, &def);
			*assoc[i].colorp = def.pixel;
			*assoc[i].gc = XCreateGC( dpy, root, 0, 0 );
			XSetForeground( dpy, *assoc[i].gc, *assoc[i].colorp );
			XSetFont(dpy, *assoc[i].gc, xtrekfont);
		}
	}
}

booleanDefault(prog, def)
	char	*prog, *def;
{
	char	*str;

	if ((str = XGetDefault(dpy, prog, def)) != NULL && strcmp(str, "on") == 0)
		return (1);
	else
		return (0);
}

#define iswhite(c)	((c) == ' ' || c == '\t' || (c) == ',')

arrayDefault(prog, def, sizeP, sp)
	char	*prog, *def;
	int	*sizeP;
	short	*sp;
{
	int	max;
	char	*str;

	str = XGetDefault(dpy, prog, def);
	if (str == NULL)
		return (-1);
	max = *sizeP;
	*sizeP = 0;

	for (;;) {
		while (iswhite(*str))
			str++;
		if (*str == '\0')
			break;
		if (++(*sizeP) > max)
			return (-1);
		if (sscanf(str, "0x%hx", &sp[*sizeP]) != 1)
			return (-1);
		while (!iswhite(*str) && *str != '\0')
			str++;
	}
	return (0);
}
