/*  SCORE.C  */

#include "qix.h"
#include <sys/fcntl.h>

#define NAMELEN		3

struct scores {
    int score;
    char initials[NAMELEN+1];
    char login[9];
}   top_ten[10];

extern int errno;
extern char *sys_errlist[];

/* returns whether the score file can be accessed */
score_board(Read, names)
{
    struct scores *scp, *temp;
    char buf[BUFSIZ];
    int fd;

    clear_board();

    for (scp = top_ten; scp < &top_ten[10]; scp++) {
	(void) strcpy(scp->initials, "Qix");
	scp->initials[3] = 0;
	(void) strcpy(scp->login, "computer");
#ifdef DEBUG
	scp->score = 0;
#else DEBUG
	scp->score = 30000;
#endif DEBUG
    }

    /* read the top ten file into the array and close the file. If it doesn't
     * open for read/write, it probably doesn't exit -- create it rw for all.
     */
    if ((fd = open(SCOREFILE, O_RDWR)) == -1 &&
	(Read || (fd = open(SCOREFILE, O_WRONLY, 0666))) ||
	read(fd, (char *) top_ten, sizeof(top_ten)) == -1) {
	msg("No score file:\n%s", sys_errlist[errno]);
	Sleep(2);
	remove_msgs(0);
	return -1;
    }

    /* Print the list */
    if (Read) {
	msg("Top Players:\nScore%24cName\n", ' ');
	for (scp = top_ten; scp < &top_ten[10] && scp->score; scp++) {
	    (void) sprintf(buf, "%7.d%24c%c%c%c  ", scp->score, ' ',
		scp->initials[0], scp->initials[1], scp->initials[2]);
	    if (names)
		(void) strcat(buf, scp->login);
	    msg(buf);
	}
    }
    /* check to see if current score made it */
    else {
	int pos;
	for (pos = 1, scp = top_ten; pos <= 10; scp++, pos++)
	    if (scp->score < score)
		break;
	if (pos <= 10) {
	    char *getlogin(), *login = getlogin();

	    for (temp = &top_ten[9]; temp > scp; temp--)
		*temp = *(temp - 1);
	    scp->score = score;
	    (void) strcpy(scp->login, login);
	    prompt_initials(pos, scp->initials);
	    if (strlen(scp->initials) > 1) {
		(void) lseek(fd, (long)0, 0);
		(void) write(fd, (char *)top_ten, sizeof top_ten);
	    }
	}
    }
    (void) close(fd);
    return 0;
}

char *
ordinate(n)
{
    if (n == 1)
	return "st";
    if (n == 2)
	return "nd";
    if (n == 3)
	return "rd";
    return "th";
}

prompt_initials(pos, buf)
register char *buf;
{
    Event event;
    int x = MID_X - 15 * l_width(big_font);
    int y = 19 * l_height(big_font), len;
    int ID;
    char s[16];

    msg("You attained the %d%s position", pos, ordinate(pos));
    msg("Type initials or use:\nLEFT button to advance one character.");
    msg("MIDDLE button to decrement one character.\n");
    msg("Use RETURN or RIGHT button to enter each letter.");
    msg("Use <backspace> key to go back one position.");
    (void) sprintf(s, "%d", score);
    pw_text(draw_win, x, y, PIX_SRC|PIX_COLOR(TEXT_COLOR), big_font, s);
    x += 25 * l_width(big_font);
    (void) strcpy(buf, "AAA");

    for (len = 0; len < 3;) {
	pw_text(draw_win, x - len*l_width(big_font), y, 
		PIX_SRC|PIX_COLOR(TEXT_COLOR), big_font, buf);
	pw_text(draw_win, x, y, SRC_OR_DST|PIX_COLOR(TEXT_COLOR), 
		big_font, "_");

#ifdef X11
	do XNextEvent(dpy, &event);
	while (event.xany.type != ButtonPress &&
	       event.xany.type != KeyPress);
	if (event.xany.type == ButtonPress)
	    ID = MS_LEFT + event.xbutton.button - 1;
	else {
	    KeySym k;
	    (void) XLookupString(&event, s, 1, &k, NULL);
	    ID = (int)(s[0]);
	}
#else
	do window_read_event(Draw, &event);
	while (event.ie_code == LOC_MOVE || event.ie_code == LOC_DRAG ||
	       event_is_up(&event));
	ID = event.ie_code;
#endif /* X11 */

	switch (ID) {
	    when 8 : case 127 :
		if (len > 0)
		    len--, x -= l_width(big_font);
	    when '\n' : case '\r' : case MS_RIGHT :
		len++, x += l_width(big_font);
	    when MS_LEFT :
		if (++(buf[len]) < 'A' || buf[len] > 'z')
		    buf[len] = 'A';
	    when MS_MIDDLE :
		if (--(buf[len]) < 'A' || buf[len] > 'z')
		    buf[len] = 'z';
	    otherwise :
		if (isascii(ID))
		    buf[len] = (char)ID;
		else
		    printf("%d ", ID);
	}
    }
}
