#include	<stdio.h>
#include	<sys/types.h>
#include	"bdf.h"
#include	"gf.h"

#define		NCHARS		256

static charinfo	ci[NCHARS];

static int	filepos = 0;		/* position in gf output */

static FILE	*plfile	= NULL;		/* property list output */

/*
**	The parameters to these routines follow the order
**	they are described in gftopk.web.
*/

static out(c)
	int		c;
{
	putchar(c);
	filepos++;
}

static out2(c)
	int		c;
{
	out((c >> 8) & 0xff);
	out(c & 0xff);
}

static out3(c)
	int		c;
{
	out((c >> 16) & 0xff);
	out((c >> 8) & 0xff);
	out(c & 0xff);
}

static out4(c)
	int		c;
{
	out((c >> 24) & 0xff);
	out((c >> 16) & 0xff);
	out((c >> 8) & 0xff);
	out(c & 0xff);
}

static paint(n)
	register int	n;
{
	if (0 <= n && n < 64)
		out(PAINT0 + n);
	else if (64 <= n && n < 256)
	{
		out(PAINT1);
		out(n);
	}
	else if (256 <= n && n < 65536)
	{
		out(PAINT2);
		out2(n);
	}
	else if (65536 <= n && n < (1 << 24))
	{
		out(PAINT3);
		out3(n);
	}
	else
		fatal("Impossibly large value for paint(n)");
}

static boc(c, p, minm, maxm, minn, maxn)
	int		c, p, minm, maxm, minn, maxn;
{
	if (p == -1 &&
		0 <= maxm && maxm < 256 &&
		(maxm - minm) < 256 &&
		0 <= maxn && maxn < 256 &&
		(maxn - minn) < 256)
	{
		out(BOC1);
		out(c);
		out(maxm-minm);
		out(maxm);
		out(maxn-minn);
		out(maxn);
	}
	else
	{
		out(BOC);
		out4(c);
		out4(p);
		out4(minm);
		out4(maxm);
		out4(minn);
		out4(maxn);
	}
}

static eoc()
{
	out(EOC);
}

static skip(n)
	int		n;
{
	if (n <= 0)
		out(SKIP0);
	else if (1 <= n && n <= 256)
	{
		out(SKIP1);
		out(n-1);
	}
	else if (256 < n && n < 65536)
	{
		out(SKIP2);
		out2(n);
	}
	else if (65536 <= n && n < (1 << 24))
	{
		out(SKIP3);
		out3(n);
	}
	else
		fatal("Impossibly large value for skip(n)");
}

static newrow(m)
	int		m;
{
	if (m <= 0)
		out(NEWROW0);
	else if (1 <= m && m <= 164)
		out(NEWROW1+m-1);
	else
		fatal("Too large a value for newrow(m)");
}

static xxx(k, x)
	int		k;
	char		*x;
{
	if (0 <= k && k < 256)
	{
		out(XXX1);
		out(k);
	}
	else if (256 <= k && k < 65536)
	{
		out(XXX2);
		out2(k);
	}
	else if (65536 <= k && k < (1 << 24))
	{
		out(XXX3);
		out3(k);
	}
	else
	{
		out(XXX4);
		out4(k);
	}
	while (k-- > 0)
		out(*x++);
}

static yyy(n)
	int		n;
{
	out(YYY);
	out4(n);
}

static noop()
{
	out(NOOP);
}

static charloc(c, dx, dy, w, p)
	int		c, dx, dy, w, p;
{
	if (dy == 0 && (dx & 0xffff) == 0 && (dx >> 16) < 256)
	{
		out(CHARLOC0);
		out(c);
		out(dx >> 16);
		out4(w);
		out4(p);
	}
	else
	{
		out(CHARLOC);
		out(c);
		out4(dx);
		out4(dy);
		out4(w);
		out4(p);
	}
}

static pre(i, k, x)
	int		i, k;
	char		*x;
{
	out(PRE);
	out(i);
	out(k);
	while (k-- > 0)
		out(*x++);
}

static post(p)
	int		p;
{
	out(POST);
	out4(p);
	out4(pointsize * FIX);
	out4(0);			/* checksum */
	out4((xres * (1 << 16))/72);	/* hppp */
	out4((yres * (1 << 16))/72);	/* vppp */
	out4(offx);			/* global */
	out4(bbx + offx);
	out4(offy);
	out4(bby + offy - 1);
}

static postpost(q, i)
	int		q, i;
{
	register int	n;

	out(POSTPOST);
	out4(q);
	out(i);
	for (n = 0; n < 4; ++n)
		out(223);
	while (filepos & 0x3)		/* round off to 4 bytes */
		out(223);
}

initialize(argc, argv)
	int		argc;
	char		*argv[];
{
	register int	i;

	if (argc < 2)
		fatal("Usage: bdf2gf gf [pl]");

	if (freopen(argv[1], "w", stdout) == NULL)
		fatal("Cannot open gf file");

	if (argc >= 3)
	{
		if ((plfile = fopen(argv[2], "w")) == NULL)
			fatal("Cannot open pl file");
	}

	for (i = 0; i < NCHARS; ++i)
		ci[i].p = -1;
}

storeglyph(n, bbx, bby, offx, offy, dx, dy)
	int		n, bbx, bby, offx, offy;
	float		dx, dy;
{
	register charinfo	*cp;

	n %= NCHARS;
	cp = &ci[n];
	if (cp->p != -1)
		(void)fprintf(stderr, "Warning, redefinition of char %d\n", n);
	cp->bbx = bbx;
	cp->bby = bby;
	cp->offx = offx;
	cp->offy = offy;
	cp->w = dx * (float)FIX / 1000.0;
/*
**	Conversion from BDF swidths to pixels:
**	pixels = swidth * (pointsize / 72) * resolution / 1000;
**	i.e. swidths are dimensionless and 1000x the true width.
**	Swidths normally range in the high hundreds, as you would expect.
**
**	To convert to GF escapements we round and multiply by 2^16.
*/
	dx *= (float)(pointsize * xres) / 72000.0;
	cp->dx = (int)(dx + 0.5) * (1 << 16);
	dy *= (float)(pointsize * yres) / 72000.0;
	cp->dy = (int)(dy + 0.5) * (1 << 16);
}

/*
**	We can save white_pixels until a black_pixel forces us
**	to output them.
**	If end_of_row == 0, then white_pixels are row trailing counts,
**	otherwise they are row leading counts.
*/
static int	white_pixels	= 0;
static int	end_of_row 	= 0;

static run(color, length)
	int		color, length;
{
	register int	leading_white;

	if (length <= 0)
		return;
	if (color == WHITE_PIXEL)
		white_pixels += length;
	else			/* BLACK_PIXEL */
	{
		if (end_of_row <= 0)
			paint(white_pixels);
		else
		{
/*
**	This is how we dispose of most of the blank rows.
*/
			if (end_of_row > 1)
				skip(end_of_row - 1);
			if ((leading_white = white_pixels) > 164)
				leading_white = 164;
			newrow(leading_white);
/*
**	It is very unlikely that we will have more than 164
**	leading columns of white but in case, we output a paint(0)
**	followed by as many more white pixels as we need.
*/
			if ((white_pixels - leading_white) > 0)
			{
				paint(0);
				paint(white_pixels);
			}
		}
		white_pixels = end_of_row = 0;	/* reset counts */
		paint(length);		/* and automatically reverse color */
	}
}

static endrow()
{
/*
**	If we have white pixels here they are trailing pixels and
**	we can just throw them away because we will output
**	a newrow command next.
*/
	white_pixels = 0;
	++end_of_row;
}

static dump1map(n, bitmap)
	int		n;
	u_char		*bitmap;
{
	register int	i, j, save, paintswitch, bitpos;
	register u_char	*p;
	register int	bytewidth;
	register charinfo	*cp;

	if (bitmap == 0)	/* no bitmap? */
		return;
	cp = &ci[n];
	i = filepos;		/* save position */
	/* any xxx's come here */
	boc(n, cp->p, cp->offx, cp->bbx + cp->offx,
		cp->offy, cp->bby + cp->offy - 1);
	cp->p = i;		/* set backpointer */
	/* dump bitmap here */
	bytewidth = (cp->bbx + 7) / 8;
	white_pixels = end_of_row = 0;
	for (i = 0; i < cp->bby; ++i)
	{
		p = &bitmap[i * bytewidth];
		bitpos = 7;
		paintswitch = WHITE_PIXEL;
		for (save = j = 0; j < cp->bbx; ++j)
		{
			if (((*p >> bitpos) & 0x1) != paintswitch)
			{
				run(paintswitch, j - save);
				save = j;
				paintswitch ^= 0x1;
			}
			if (--bitpos < 0)
			{
				++p;
				bitpos = 7;
			}
		}
		run(paintswitch, j - save);
		endrow();
	}
	eoc();
}

static dump1loc(n, bitmap)
	int		n;
	u_char		*bitmap;
{
	register charinfo	*cp;

	if (bitmap == 0)
		return;
	cp = &ci[n];
	charloc(n, cp->dx, cp->dy, cp->w, cp->p);
}

static fontdimens(scale, bitmaps)
	float		scale;
	u_char		*bitmaps[NCHARS];
{
	register int	ch;
	register charinfo	*cp;

	(void)fprintf(plfile, "(FONTDIMEN\n");
	ch = bitmaps[' '] != 0 ? ' ' : 'x';
	if (bitmaps[ch] != 0)
	{
		cp = &ci[ch];
		(void)fprintf(plfile, " (SPACE D %d)\n", cp->bbx);
		(void)fprintf(plfile, " (STRETCH R %.9f)\n", (float)cp->bbx * 0.5);
		(void)fprintf(plfile, " (SHRINK R %.9f)\n", (float)cp->bbx * 0.3);
		(void)fprintf(plfile, " (EXTRASPACE R %.9f)\n", (float)cp->bbx * 0.3);
		(void)fprintf(plfile, " (QUAD D %d)\n", cp->bbx * 2);
		(void)fprintf(plfile, " (XHEIGHT D %d)\n", cp->bby);
	}
	else
	{
		(void)fprintf(plfile, " (SPACE R %.9f)\n", scale * 0.75);
		(void)fprintf(plfile, " (STRETCH R %.9f)\n", scale * 0.375);
		(void)fprintf(plfile, " (SHRINK R %.9f)\n", scale * 0.225);
		(void)fprintf(plfile, " (EXTRASPACE R %.9f)\n", scale * 0.225);
		(void)fprintf(plfile, " (QUAD R %.9f)\n", scale * 1.5);
		(void)fprintf(plfile, " (XHEIGHT R %.9f)\n", scale * 0.75);
	}
	(void)fprintf(plfile, " )\n");
}

static dump1pl(n, bitmap)
	int		n;
	u_char		*bitmap;
{
	register charinfo	*cp;

	if (bitmap == 0)
		return;
	cp = &ci[n];
	if (' ' < n && n <= '~' && n != '(' && n != ')')
		(void)fprintf(plfile, "(CHARACTER C %c\n", n);
	else
		(void)fprintf(plfile, "(CHARACTER D %d\n", n);
	(void)fprintf(plfile, " (CHARWD D %d)\n", cp->bbx);
	(void)fprintf(plfile, " (CHARHT D %d)\n", cp->bby + cp->offy);
	(void)fprintf(plfile, " (CHARDP D %d)\n", -cp->offy);
	(void)fprintf(plfile, " )\n");
}

static dumppl(bitmaps)
	u_char	*bitmaps[NCHARS];
{
	register int	i;
	register float	du;

	(void)fprintf(plfile, "(DESIGNSIZE D %d)\n", pointsize);
	du = (float)xres * (float)pointsize / 72.0;
	(void)fprintf(plfile, "(DESIGNUNITS R %.9f)\n", du);
	(void)fprintf(plfile, "(COMMENT Units are in pixels)\n");
	fontdimens(du, bitmaps);
	for (i = 0; i < NCHARS; ++i)
		dump1pl(i, bitmaps[i]);
	(void)fclose(plfile);
}

dumpfont(bitmaps)
	u_char	*bitmaps[NCHARS];
{
	register int	i, lastboc, pos;

	pre(131, 0, "");
	for (i = 0; i < NCHARS; ++i)
		dump1map(i, bitmaps[i]);
	lastboc = filepos;	/* save position of lastboc */
	/* xxx's for the postamble go here */
	pos = filepos;		/* save position of post */
	/* beginning of postamble */
	post(lastboc);
	for (i = 0; i < NCHARS; ++i)
		dump1loc(i, bitmaps[i]);
	postpost(pos, 131);
	if (plfile != NULL)
		dumppl(bitmaps);
}
