#include	<stdio.h>
#include	<sys/types.h>

char		fontname[100];
int		pointsize, xres, yres;
int		bbx, bby, offx, offy;
int		nchars;
u_char		*bitmaps[256] = { 0 };

fatal(m)
	char		*m;
{
	(void)fprintf(stderr, "%s\n", m);
	exit(1);
}

/*
**	Read line in and match against s.
**	If mustmatch and none found, exit.
**	If !mustmatch and none found, return 0.
**	Else return 1.
*/
int match(s, line, max, mustmatch)
	char		*s, *line;
	int		max, mustmatch;
{
	int		len = strlen(s);

	if (fgets(line, max, stdin) == NULL)
		fatal("Unexpected EOF on input");
	if (strncmp(line, s, len) != 0)
	{
		if (mustmatch)
		{
			(void)fprintf(stderr, "Expected %s, got %s", s, line);
			exit(1);
		}
		else
			return (0);
	}
	return (1);
}

readproperties(line, max)
	char		*line;
	int		max;
{
	int		nprops;

	if (sscanf(line, "STARTPROPERTIES %d", &nprops) != 1)
		fatal("No property count");
	while (nprops-- > 0)
	{
		if (fgets(line, max, stdin) == NULL)
			fatal("Unexpected EOF on input reading properties");
	}
	(void)match("ENDPROPERTIES", line, max, 1);
}

u_char *readbitmap(line, max, width, height)
	char		*line;
	int		max;
	int		width, height;
{
	register int	i, j, bytewidth;
	register u_char	*p, *q;
	unsigned	byte;
	char		*malloc();

	(void)match("BITMAP", line, max, 1);
	bytewidth = (width + 7) / 8;
	if ((q = p = (u_char *)malloc(bytewidth * height)) == NULL)
		fatal("Cannot allocate bitmap storage");
	for (i = 0; i < height; ++i)
	{
		if (fgets(line, max, stdin) == NULL)
			fatal("Unexpected EOF on input reading bitmap");
		for (j = 0; j < bytewidth; ++j)
		{
			if (sscanf(&line[j*2], "%02x", &byte) != 1)
				fatal("Cannot read hex pair");
			*q++ = byte & 0xff;
		}
	}
	(void)match("ENDCHAR", line, max, 1);
	return (p);
}

read1char(line, max)
	char		*line;
	int		max;
{
	int		charnum;
	int		width, bbx, bby, offx, offy;
	float		dx, dy;

	(void)match("STARTCHAR", line, max, 1);
	(void)match("ENCODING", line, max, 1);
	if (sscanf(line, "ENCODING %d", &charnum) != 1)
		fatal("No position number for character");
	(void)match("SWIDTH", line, max, 1);
	if (sscanf(line, "SWIDTH %g %g", &dx, &dy) != 2)
		fatal("No scalable width info for character");
	(void)match("DWIDTH", line, max, 1);
	if (sscanf(line, "DWIDTH %d", &width) != 1)
		fatal("No width info for character");
	(void)match("BBX", line, max, 1);
	if (sscanf(line, "BBX %d %d %d %d", &bbx, &bby, &offx, &offy) != 4)
		fatal("Insufficient bounding box info for character");
	bitmaps[charnum % 0x100] = readbitmap(line, max, bbx, bby);
	storeglyph(charnum, bbx, bby, offx, offy, dx, dy);
}

readchars(line, max)
	char		*line;
	int		max;
{
	(void)match("CHARS", line, max, 1);
	if (sscanf(line, "CHARS %d", &nchars) != 1)
		fatal("No count of chars");
	while (nchars-- > 0)
		read1char(line, max);
}

main(argc, argv)
	int		argc;
	char		*argv[];
{
	char		line[512];

	initialize(argc, argv);

	(void)match("STARTFONT 2.1", line, sizeof(line), 1);
	while (!match("FONT", line, sizeof(line), 0))
		;
	if (sscanf(line, "FONT %s", fontname) != 1)
		fatal("No font name");
	(void)match("SIZE", line, sizeof(line), 1);
	if (sscanf(line, "SIZE %d %d %d", &pointsize, &xres, &yres) != 3)
		fatal("Insufficient size info");
	(void)match("FONTBOUNDINGBOX", line, sizeof(line), 1);
	if (sscanf(line, "FONTBOUNDINGBOX %d %d %d %d", &bbx, &bby,
		&offx, &offy) != 4)
		fatal("Insufficient bounding box info");
	if (match("STARTPROPERTIES", line, sizeof(line), 0))
		readproperties(line, sizeof(line));
	readchars(line, sizeof(line));
	dumpfont(bitmaps);
	exit(0);
}
