/* 
 * SlateP.h - Private definitions for Slate.
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#ifndef _SlateP_h
#define _SlateP_h

#include <Slate.h>
#include <X11/CoreP.h>

typedef struct {
    /* public */
    Pixel		foreground;	/* Foreground color */
    Pixel		highlight;	/* Highlight color */
    Pixel		depth_cue;	/* Depth Cue color */
    XtCallbackList	button_proc;	/* Button callback list */
    XtCallbackList	key_proc;	/* Key callback list */
    XtCallbackList	resize_proc;	/* Resize callback list */
    XtCallbackList	redisp_proc;	/* Redisplay callback list */
    XtCallbackList	map_proc;	/* Map event callback list */
    Cursor		cursor;	/* Cursor to use for the window */
    XFontStruct	       *font;	/* Font to draw label in */
    String		label;	/* Label to draw in window */
    int			x;	/* X position of top left of label */
    int 		y;	/* Y position of top left of label */
    /* private */
    GC		gc;
    int		label_len;	/* Number of chars in label */
} SlatePart;

typedef struct _SlateRec {
    CorePart	core;
    SlatePart	slate;
} SlateRec;

typedef struct {int empty;} SlateClassPart;

typedef struct _SlateClassRec {
    CoreClassPart		core_class;
    SlatePart			slate_class;
} SlateClassRec;

#endif _SlateP_h
