/* 
 * fillarea.c - Object handling routines for a swapped fill area OC packet.
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#include "PEX.h"
#include "PEXproto.h"
#include "swapmacros.h"
#include "fillarea.h"

/* +4 below is for n itself. */
#define ExtraSpace(n, fa, va)\
    (sizeof(pexCoord3D) * n) +4+\
    ((fa == GANormal) ? sizeof (pexVector3D) : 0) +\
    ((va == GANormal) ? (sizeof (pexVector3D) * n) : 0)

pexFillAreaWithDataPtr
NewPexFillAreaWithData (nPoints, facetAtt, vertexAtt)
    CARD32 nPoints;
    CARD16 facetAtt, vertexAtt;

{
    pexFillAreaWithDataPtr NewArea;

    /* printf("Newfillarea %d points, ", nPoints); */

    NewArea = (pexFillAreaWithDataPtr)
	xalloc(sizeof(pexFillAreaWithDataRec) +
	       (ExtraSpace(nPoints, facetAtt, vertexAtt)));

    /* printf("%d + %d = %d bytes allocated at %x", sizeof(pexFillAreaWithDataRec),
       ExtraSpace(nPoints, facetAtt, vertexAtt),
       sizeof(pexFillAreaWithDataRec) +
       ExtraSpace(nPoints, facetAtt, vertexAtt),
       NewArea);
      */    

    NewArea->head.length = (sizeof(pexFillAreaWithDataRec) +
			    (ExtraSpace(nPoints, facetAtt, vertexAtt)) ) >> 2;
    NewArea->head.elementType = OCExtFillArea;
    return (NewArea);
};

#define SWAP_FILE "fillarea.ci"
#include "scgen.ci"
#undef SWAP_FILE

/*****************************************************************
 * TAG( FreePexFillAreaWithData )
 * 
 * Inputs:
 *	pexFillAreaWithDataPtr
 * Outputs:
 *	[None]
 * Assumptions:
 *	Area is byteSwapped properly.
 * Algorithm:
 *	[None]
 */

void
FreePexFillAreaWithData (pArea)
    pexFillAreaWithDataPtr pArea;
{
    xfree(pArea);
};
