/* 
 * viewrep.c - Set View Rep request handler
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#include "PEXproto.h"
#include "PEX.h"
#include "renderer.h"
#include "pexextensn.h"

#define SCPexMatrix_C(InMat,OutMat) \
     SWAPFLOAT_C(InMat[0][0],OutMat[0][0]); \
     SWAPFLOAT_C(InMat[0][1],OutMat[0][1]); \
     SWAPFLOAT_C(InMat[0][2],OutMat[0][2]); \
     SWAPFLOAT_C(InMat[0][3],OutMat[0][3]); \
     SWAPFLOAT_C(InMat[1][0],OutMat[1][0]); \
     SWAPFLOAT_C(InMat[1][1],OutMat[1][1]); \
     SWAPFLOAT_C(InMat[1][2],OutMat[1][2]); \
     SWAPFLOAT_C(InMat[1][3],OutMat[1][3]); \
     SWAPFLOAT_C(InMat[2][0],OutMat[2][0]); \
     SWAPFLOAT_C(InMat[2][1],OutMat[2][1]); \
     SWAPFLOAT_C(InMat[2][2],OutMat[2][2]); \
     SWAPFLOAT_C(InMat[2][3],OutMat[2][3]); \
     SWAPFLOAT_C(InMat[3][0],OutMat[3][0]); \
     SWAPFLOAT_C(InMat[3][1],OutMat[3][1]); \
     SWAPFLOAT_C(InMat[3][2],OutMat[3][2]); \
     SWAPFLOAT_C(InMat[3][3],OutMat[3][3])
#define SCPexCoord3D_C(InCoord,OutCoord) \
     SWAPFLOAT_C(InCoord.x,OutCoord.x); \
     SWAPFLOAT_C(InCoord.y,OutCoord.y); \
     SWAPFLOAT_C(InCoord.z,OutCoord.z)

#define SWAP_FILE "viewrep.ci"
#include "scgen.ci"
#undef SWAP_FILE
