/* 
 * validate.h - Makes the PC and RD things in PEX.h easier to use
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#include <PEX.h>

#define PCAllValuesChanged		((PCMask[0]==~0L)&&(PCMask[1]==~0L))
#define PCMarkerTypeChanged		1L << PCMarkerType & PCMask[0]
#define PCMarkerScaleChanged		1L << PCMarkerScale & PCMask[0]
#define PCMarkerColorChanged		1L << PCMarkerColor & PCMask[0]
#define PCMarkerBundleIndexChanged	1L << PCMarkerBundleIndex & PCMask[0]
#define PCTextFontChanged		1L << PCTextFont & PCMask[0]
#define PCTextPrecisionChanged		1L << PCTextPrecision & PCMask[0]
#define PCCharExpansionChanged		1L << PCCharExpansion & PCMask[0]
#define PCCharSpacingChanged		1L << PCCharSpacing & PCMask[0]
#define PCTextColorChanged		1L << PCTextColor & PCMask[0]
#define PCCharHeightChanged		1L << PCCharHeight & PCMask[0]
#define PCCharUpVectorChanged		1L << PCCharUpVector & PCMask[0]
#define PCTextPathChanged		1L << PCTextPath & PCMask[0]
#define PCTextAlignmentChanged		1L << PCTextAlignment & PCMask[0]
#define PCAtextHeightChanged		1L << PCAtextHeight & PCMask[0]
#define PCAtextUpVectorChanged		1L << PCAtextUpVector & PCMask[0]
#define PCAtextPathChanged		1L << PCAtextPath & PCMask[0]
#define PCAtextAlignmentChanged		1L << PCAtextAlignment & PCMask[0]
#define PCAtextStyleChanged		1L << PCAtextStyle & PCMask[0]
#define PCTextBundleIndexChanged	1L << PCTextBundleIndex & PCMask[0]
#define PCLineTypeChanged		1L << PCLineType & PCMask[0]
#define PCLineWidthChanged		1L << PCLineWidth & PCMask[0]
#define PCLineColorChanged		1L << PCLineColor & PCMask[0]
#define PCCurveApproxChanged		1L << PCCurveApprox & PCMask[0]
#define PCPolylineInterpChanged		1L << PCPolylineInterp & PCMask[0]
#define PCLineBundleIndexChanged	1L << PCLineBundleIndex & PCMask[0]
#define PCInteriorStyleChanged		1L << PCInteriorStyle & PCMask[0]
#define PCInteriorStyleIndexChanged	1L << PCInteriorStyleIndex & PCMask[0]
#define PCSurfaceColorChanged		1L << PCSurfaceColor & PCMask[0]
#define PCReflectionAttrChanged		1L << PCReflectionAttr & PCMask[0]
#define PCReflectionModelChanged	1L << PCReflectionModel & PCMask[0]
#define PCSurfaceInterpChanged		1L << PCSurfaceInterp & PCMask[0]
#define PCBfInteriorStyleChanged	1L << (PCBfInteriorStyle-32) &PCMask[1]
#define PCBfInteriorStyleIndexChanged	1L << (PCBfInteriorStyleIndex-32) & PCMask[1]
#define PCBfSurfaceColorChanged		1L << (PCBfSurfaceColor-32) & PCMask[1]
#define PCBfReflectionAttrChanged	1L << (PCBfReflectionAttr-32)&PCMask[1]
#define PCBfReflectionModelChanged	1L << (PCBfReflectionModel-32) & PCMask[1]
#define PCBfSurfaceInterpChanged	1L << (PCBfSurfaceInterp-32) &PCMask[1]
#define PCSurfaceApproxChanged		1L << (PCSurfaceApprox-32) & PCMask[1]
#define PCCullingModeChanged		1L << (PCCullingMode-32) & PCMask[1]
#define PCDistinguishChanged		1L << (PCDistinguish-32) & PCMask[1]
#define PCNormalFlipChanged		1L << (PCNormalFlip-32) & PCMask[1]
#define PCPatternSizeChanged		1L << (PCPatternSize-32) & PCMask[1]
#define PCPatternRefPtChanged		1L << (PCPatternRefPt-32) & PCMask[1]
#define PCPatternRefVec1Changed		1L << (PCPatternRefVec1-32) & PCMask[1]
#define PCPatternRefVec2Changed		1L << (PCPatternRefVec2-32) & PCMask[1]
#define PCInteriorBundleIndexChanged	1L << (PCInteriorBundleIndex-32) & PCMask[1]
#define PCSurfaceEdgeFlagChanged	1L << (PCSurfaceEdgeFlag-32)&PCMask[1]
#define PCSurfaceEdgeTypeChanged	1L << (PCSurfaceEdgeType-32)&PCMask[1]
#define PCSurfaceEdgeWidthChanged	1L << (PCSurfaceEdgeWidth-32)&PCMask[1]
#define PCSurfaceEdgeColorChanged	1L << (PCSurfaceEdgeColor-32)&PCMask[1]
#define PCEdgeBundleIndexChanged	1L << (PCEdgeBundleIndex-32) &PCMask[1]
#define PCLocalTransformChanged		1L << (PCLocalTransform-32) & PCMask[1]
#define PCGlobalTransformChanged	1L << (PCGlobalTransform-32) &PCMask[1]
#define PCModelClipChanged		1L << (PCModelClip-32) & PCMask[1]
#define PCModelClipVolumeChanged	1L << (PCModelClipVolume-32) &PCMask[1]
#define PCViewIndexChanged		1L << (PCViewIndex-32) & PCMask[1]
#define PCLightStateChanged		1L << (PCLightState-32) & PCMask[1]
#define PCDepthCueIndexChanged		1L << (PCDepthCueIndex-32) & PCMask[1]
#define PCPickIdChanged			1L << (PCPickId-32) & PCMask[1]
#define PCHlhsrIdentifierChanged	1L << (PCHlhsrIdentifier-32) &PCMask[1]
#define PCNameSetChanged		1L << (PCNameSet-32) & PCMask[1]
#define PCAsfValuesChanged	        1L << (PCAsfValues-32) & PCMask[1]

#define RDPipelineContextChanged	(RDMask & RDPipelineContext)
#define RDCurrentPathChanged		(RDMask & RDCurrentPath)
#define RDRendererStateChanged		(RDMask & RDRendererState)
#define RDMarkerBundleChanged		(RDMask & RDMarkerBundle)
#define RDTextBundleChanged		(RDMask & RDTextBundle)
#define RDLineBundleChanged		(RDMask & RDLineBundle)
#define RDInteriorBundleChanged		(RDMask & RDInteriorBundle)
#define RDEdgeBundleChanged		(RDMask & RDEdgeBundle)
#define RDViewTableChanged		(RDMask & RDViewTable)
#define RDColorTableChanged		(RDMask & RDColorTable)
#define RDDepthCueTableChanged		(RDMask & RDDepthCueTable)
#define RDLightTableChanged		(RDMask & RDLightTable)
#define RDColorApproxTableChanged	(RDMask & RDColorApproxTable)
#define RDPatternTableChanged		(RDMask & RDPatternTable)
#define RDTextFontTableChanged		(RDMask & RDTextFontTable)
#define RDHighlightInclChanged		(RDMask & RDHighlightIncl)
#define RDHighlightExclChanged		(RDMask & RDHighlightExcl)
#define RDInvisibilityInclChanged	(RDMask & RDInvisibilityIncl)
#define RDInvisibilityExclChanged	(RDMask & RDInvisibilityExcl)
#define RDHlhsrModeChanged		(RDMask & RDHlhsrMode)
#define RDNpcSubvolumeChanged		(RDMask & RDNpcSubvolume)
#define RDViewportChanged		(RDMask & RDViewport)

