/* 
 * mipex.h - macro to set GC values.
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */
#ifndef MIPEX_H
#define MIPEX_H

#include "scrnintstr.h"

#define miPexSetGCValues(pGC, pDraw, colorIndex, shade, index)\
index = PexColorTableIndex(colorIndex, shade);\
if (pDraw->pScreen->rootDepth == 1)\
{\
     if (pGC->fillStyle != FillTiled)\
     {\
	  pGC->fillStyle = FillTiled;\
	  pGC->stateChanges |= GCFillStyle;\
     }\
     if (pGC->tile != (PixmapPtr)index)\
     {\
	  pGC->tile = (PixmapPtr)index;\
	  pGC->stateChanges |= GCTile;\
     }\
     if (pGC->stateChanges != 0)\
          ValidateGC(pDraw, pGC);\
}\
else \
    if (pGC->fgPixel != index)\
{\
    pGC->fgPixel = (Pixel) index;\
    pGC->stateChanges |= GCForeground;\
    ValidateGC(pDraw, pGC);\
}


#define miPexSetGCLineValue(pGC, pDraw, colorIndex, index)\
index = PexColorTableIndex(colorIndex, TRUE_COLOR_SHADE);\
if (pDraw->pScreen->rootDepth == 1)\
{\
    if (pGC->fillStyle != FillSolid)\
    {\
	 pGC->fillStyle = FillSolid;\
	 pGC->tile = (PixmapPtr)NULL;\
         pGC->stateChanges |= GCFillStyle | GCTile;\
	 ValidateGC(pDraw, pGC);\
    }\
    }\
    else\
    if (pGC->fgPixel != index)\
    {\
         pGC->fgPixel = (Pixel) index;\
         pGC->stateChanges |= GCForeground;\
         ValidateGC(pDraw, pGC);\
    }

#endif MIPEX_H
