/* 
 * polyline.h - Header file for polylines
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */
#ifndef PEX_POLYLINE_H
#define PEX_POLYLINE_H

#include "PEXproto.h"
#include "pexarray.h"

typedef struct _pexPolyline3D
{
    pexElementInfo	head;
    CARD32		numVertices;
    CARD32      	vertexStride;
    CARD32      	vertexOffset;
    /* Point list is appended here */
} *pexPolylinePtr, pexPolylineRec;

	/*
       	typedef struct _pexPolyline2D
	{
	    CARD32      numVertices;
no 2D	    CARD32      vertexStride;
yet	    CARD32      vertexOffset;
	} *pexPolyline2Dptr, pexPolyline2D;
	*/


/*****************************************************************
 * TAG( PexPolylineVertex )
 * 
 * Data access macro for the Polyline.
 * This macro is used VERY frequently, so it is not expected to
 * check for input error.
 * 
 * Inputs:
 * 	pPoly - pointer to a pexPolylineRec.
 * 	n - Index into the point array
 * 	     
 * Outputs:
 * 	pointer to the data field desired.
 * 	
 * Assumptions:
 * 	N is bounded correctly,
 * 	
 * Algorithm:
 * 	simple pointer arithmetic.
 */


#define PexPolylineVertex(pPoly, n) (pexCoord3D *)Pex1DData(pPoly, n, vertex)

#if defined(__STDC__)
extern pexPolylinePtr UnpackPexPolyline(pexPolyline *);
extern pexPolylinePtr sUnpackPexPolyline(pexPolyline *); 
extern pexPolylinePtr fUnpackPexPolyline(pexPolyline *); 
extern pexPolylinePtr sfUnpackPexPolyline(pexPolyline *);

extern pexPolylinePtr NewPexPolyline(CARD32 numPoints);
extern pexPolylinePtr CopyPexPolyline(pexPolylinePtr);
extern void		FreePexPolyline(pexPolylinePtr);
extern Bool 		ErrorCheckPexPolyline(pexPolylinePtr);
#else
extern pexPolylinePtr UnpackPexPolyline();
extern pexPolylinePtr sUnpackPexPolyline();     /* s means swap */
extern pexPolylinePtr fUnpackPexPolyline();      /* f means float convert */
extern pexPolylinePtr sfUnpackPexPolyline();

extern pexPolylinePtr NewPexPolyline();
extern pexPolylinePtr CopyPexPolyline();
extern void		FreePexPolyline();
extern Bool 		ErrorCheckPexPolyline();
#endif /* if STDC */

#endif PEX_POLYLINE_H














