/* 
 * p3tst.c - Another wonderful client.
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#include <stdio.h>
#include "X11/Xlib.h"
#include "X11/Xatom.h"
#include "PEXprotostr.h"
#include <errno.h>
#include "phigs.h"

extern int errno;

#include "pexDICE.h"
#include "PEXcolors.h"

Ppoint3 front[] = {
     1.0,  1.0,  1.0, 
    -1.5,  1.0,  1.0,
    -1.5, -1.0,  1.0, 
     1.0, -1.0,  1.0 
};

Ppoint3 back[] = { 
     1.0, -1.0, -1.0, 
    -1.5, -1.0, -1.0, 
    -1.5,  1.0, -1.0,
     1.0,  1.0, -1.0, 
};

Ppoint3 left[] = {
     1.0, -1.0,  1.0,
     1.0, -1.0, -1.0,
     1.0,  1.0, -1.0,
     1.0,  1.0,  1.0
};

Ppoint3 right[] = {
    -1.5,  1.0,  1.0,
    -1.5,  1.0, -1.0,
    -1.5, -1.0, -1.0,
    -1.5, -1.0,  1.0
};

Ppoint3 top[] = {
     1.0, -1.0,  1.0,
    -1.5, -1.0,  1.0,
    -1.5, -1.0, -1.0,
     1.0, -1.0, -1.0
};

Ppoint3 bottom[] = {
     1.0,  1.0,  1.0,
     1.0,  1.0, -1.0,
    -1.5,  1.0, -1.0,
    -1.5,  1.0,  1.0
};

pexCoord3D textPt = { -1.0, -2.0, 0.0 };
pexCoord3D textOff = { 0.0, 0.0, 0.0 };

main(argc, argv)
    int     argc;
    char    *argv[];
{
    XEvent pe;
    XExposeEvent *ee;
    
    /* Phigs variables */
    Ppoint3	vrp;		/* view reference point	*/
    Pvector3	vpn, nvpn;	/* view plane normal	*/
    Pvector3	vup;		/* view up vector	*/
    Pint	error;		/* error indicator	*/
    Pmatrix3	roty;		/* y rotation matrix	*/
    Pviewmapping3 map;		/* view mapping structure */
    Pviewrep3 viewrep;		/* Phigs view representation */
    XButtonPressedEvent *buttonEvent;
 
    pexC *pexi;

    cullflag = 1;
    wireflag = 1;
    
    pexi = popenphigs(0, 0, argc, argv);
    popenws(pexi, 0, 0, 0);
    
    /*
     * Set up X for MouseButton Events.
     */
    XSelectInput(pexi->phigsDisplay, pexi->phigsWindow, 
		 ExposureMask | StructureNotifyMask | ButtonPressMask );


    /* Set up the PHIGS view */
    vrp.x = 0.0; vrp.y = 0.0; vrp.z = 0.0;
    vpn.x = 1.0; vpn.y = 2.0; vpn.z = 3.0;
    vup.x = 0.0; vup.y = 1.0; vup.z = 0.0;
    
    pevalvieworientationmatrix3(&vrp, &vpn, &vup, 
				&error, viewrep.orientation_matrix);
    
    map.window.xmin = -2.0;	map.window.ymin = -1.5;
    map.window.xmax =  2.0;	map.window.ymax =  1.5;
    map.view_plane = 1.5;
    map.back_plane = -1.5;
    map.front_plane = 1.5;
    
    map.viewport.xmin= 0.25; map.viewport.ymin= 0.25; map.viewport.zmin= -1.0;
    map.viewport.xmax= 0.75; map.viewport.ymax= 0.75; map.viewport.zmax= 0.0;
    map.prp.x = 0.0; map.prp.y = 0.0; map.prp.z = 20.0;
    map.proj = PPERSPECTIVE; 
    
    pevalviewmappingmatrix3(&map, &error, viewrep.mapping_matrix);
    
    viewrep.clip_xy = PCLIP;
    viewrep.clip_back = PCLIP;
    viewrep.clip_front = PCLIP;
    viewrep.clip_limit.xmin = 0.0;
    viewrep.clip_limit.xmax = 1.0;
    viewrep.clip_limit.ymin = 0.0;
    viewrep.clip_limit.ymax = 1.0;
    viewrep.clip_limit.zmin = -1.0;
    viewrep.clip_limit.zmax = 0.0;
    
    psetviewind(pexi, 1);
    psetviewrep3( pexi, 1, &viewrep );
    
    protatey( -10.0 * 3.1415 / 180.0, &error, roty );
    
    SetPexSurfaceFlags(pexi);
    PexSurfaceColorIndex(pexi, pexBlue);
    
    while(1)
    {
	
	/* this should get first exposure event */    
        XNextEvent(pexi->phigsDisplay, &pe);
	
        switch (pe.type)
        {
	case Expose:
            ee = (XExposeEvent *) &pe;
            while (ee->count)
            {
                XNextEvent(pexi->phigsDisplay, &pe);       
                ee = (XExposeEvent *) &pe;
            }
	    break;

	case ConfigureNotify:
	{
            XConfigureEvent *ce = (XConfigureEvent *)&pe;
            pexi->winx = ce->x;
            pexi->winy = ce->y;
            pexi->winw = ce->width;
            pexi->winh = ce->height;
	}
	    break;
	    
	case NoExpose:
	    continue;
	    break;

	case ButtonPress:
	    buttonEvent = (XButtonPressedEvent *) &pe;
	    switch (buttonEvent->button)
	    {
	    case 1:
		protatey(10.0 * 3.1415 / 180.0, &error, roty );
		break;
	    case 3:
		protatey(-10.0 * 3.1415 / 180.0, &error, roty );
		break;
	    }
	    break;
	}

	
	
	PexLocalTransform(pexi, PostConcatenate, roty);

	/* Begin the PEX rendering */
	PexBeginRendering(pexi);
	
	/* Draw the cube */
	PexRenderOutputCommands(pexi);
	
	PexFillAreaWithData(pexi, Convex, None,
			    None, 4, front,
			    NULL, NULL, NULL, NULL);
	
	PexFillAreaWithData(pexi, Convex, None,
			    None, 4, back,
			    NULL, NULL, NULL, NULL);
	
	PexFillAreaWithData(pexi, Convex, None,
			    None, 4, right,
			    NULL, NULL, NULL, NULL);
	
	PexFillAreaWithData(pexi, Convex, None,
			    None, 4, left,
			    NULL, NULL, NULL, NULL);
	
	PexFillAreaWithData(pexi, Convex, None,
			    None, 4, top,
			    NULL, NULL, NULL, NULL);
	
	PexFillAreaWithData(pexi, Convex, None,
			    None, 4, bottom,
			    NULL, NULL, NULL, NULL);
	
	PexAnnoText(pexi, "Hello there", &textPt, &textOff);
	
	PexEndRendComm(pexi);
	
	/* End the PEX rendering */
	PexEndRendering(pexi);
	XFlush(pexi->phigsDisplay);
	
    }
    
}

