/* 
 * pexform.c - A test client program
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#include <stdio.h>
#include "X11/Xlib.h"
#include "X11/Xatom.h"
#include "PEXprotostr.h"
#include "PEXcolors.h"
#include <errno.h>
#include "phigs.h"

extern int errno;

#include "pexDICE.h"

extern int pexfg;
extern int redisp;

pexCoord3D qmesh[] = {
    -2.0, -2.0, 1.0,
    -2.0, -1.0, 1.0,
    -2.0, 0.5, 2.0,
    -0.2, -2.0, 1.0,
    -0.2, -1.0, 1.0,
    -0.2, 0.5, 2.0,
    1.0, -2.0, 1.8,
    1.0, -1.0, 1.8,
    0.6, 0.5, 2.5
};

FLOAT kv[12] = { 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 7, 7 };
FLOAT kv2[6] = { 0, 0, 0, 1, 1, 1 };



	/* Global Phigs variables */
Pint		error;		/* error indicator	*/
Ppoint3		vrp;		/* view reference point	*/
Pvector3	vpn, nvpn;	/* view plane normal	*/
Pvector3	vup;		/* view up vector	*/
Pviewrep3 	viewrep;	/* Phigs view representation */

Pmatrix3	rotx, roty, rotz; /* xyz rotation matricies	*/
pexC *pexi = NULL;

void DrawTheThing()
{
    int i;
    redisp = 0;
    
    /* Begin the PEX rendering */

    PexBeginRendering(pexi);
    
    /* Draw the thing */
    PexRenderOutputCommands(pexi); 
    
    PexSurfaceColorIndex(pexi, pexMagenta);
    PexLineColorIndex(pexi, pexRed);

    PexCurveApproximation(pexi, ApproxConstantBetweenKnots, 6.0);
    PexSurfaceApproximation(pexi, ApproxConstantBetweenKnots,
			    4.0, 15.0);
    PexNurbSurface(pexi,
		   3, 3,
		   0.0, 1.0,
		   0.0, 1.0,
		   NonRational,
		   6, 6, 3, 3,
		   kv2, kv2, qmesh);

    PexNurbCurve(pexi, 
		 3,		/* Order */
		 0.0, 7.0,	/* tmin, tmax */
		 NonRational,	/* CoordType */
		 12, kv,	/* Knot vector */
		 9, qmesh	/* Control polygon */
		 );
    
    
    PexEndRendComm(pexi);
    
    /* End the PEX rendering */
    PexEndRendering(pexi);
    
    XFlush(pexi->phigsDisplay);
};

PexFormInit(dpy, window, argc, argv)
Display *dpy;
Window  window;
char **argv;
{
    XEvent pe;
    XExposeEvent *ee;

    Pviewmapping3 map;		/* view mapping structure */
    
    pexi = popenphigs(dpy, window, argc, argv);
    popenws(pexi, 0, 0, 0);
    
    /* Set up the PHIGS view */
    vrp.x = 0.0; vrp.y = 0.0; vrp.z = 0.0;
    vpn.x = 1.0; vpn.y = 2.0; vpn.z = 3.0;
    vup.x = 0.0; vup.y = 1.0; vup.z = 0.0;
    
    pevalvieworientationmatrix3(&vrp, &vpn, &vup, 
				&error, viewrep.orientation_matrix);
    
    map.window.xmin = -2.5;	map.window.ymin = -2.5;
    map.window.xmax =  2.5;	map.window.ymax =  2.5;
    map.view_plane = 2.5;
    map.back_plane = -3.0;
    map.front_plane = 3.0;
    
    map.viewport.xmin= 0.0; map.viewport.ymin= 0.0; map.viewport.zmin= -1.0;
    map.viewport.xmax= 1.0; map.viewport.ymax= 1.0; map.viewport.zmax= 0.0;
    map.prp.x = 0.0; map.prp.y = 0.0; map.prp.z = 20.0;
    map.proj = PPERSPECTIVE; 
    
    pevalviewmappingmatrix3(&map, &error, viewrep.mapping_matrix);
    
    viewrep.clip_xy = PCLIP;
    viewrep.clip_back = PCLIP;
    viewrep.clip_front = PCLIP;
    viewrep.clip_limit.xmin = map.viewport.xmin;
    viewrep.clip_limit.xmax = map.viewport.xmax;
    viewrep.clip_limit.ymin = map.viewport.ymin;
    viewrep.clip_limit.ymax = map.viewport.ymax;
    viewrep.clip_limit.zmin = map.viewport.zmin;
    viewrep.clip_limit.zmax = map.viewport.zmax;
    
    psetviewrep3(pexi, 1, &viewrep );
    psetviewind(pexi, 1);
    
    SetPexSurfaceFlags(pexi);

    DrawTheThing();
}


void rotatex(incx)
float incx;
{
    /* Set up a new PHIGS view */

    protatex( incx, &error, rotx );
    PexLocalTransform(pexi, PostConcatenate, rotx);
    
/*  ptranvc3(&vpn, rotx, &error, &nvpn);
    vpn.x = nvpn.x; vpn.y = nvpn.y; vpn.z = nvpn.z;
    
    pevalvieworientationmatrix3(&vrp, &vpn, &vup, 
				&error, viewrep.orientation_matrix);
    
    psetviewrep3( pexi, 1, &viewrep );*/
    if ( redisp++ > 5 )
	DrawTheThing();
}

void rotatey(incy)
float incy;
{
    /* Set up a new PHIGS view */
    protatey( incy, &error, roty );
    PexLocalTransform(pexi, PostConcatenate, roty);

/*    ptranvc3(&vpn, roty, &error, &nvpn);
    vpn.x = nvpn.x; vpn.y = nvpn.y; vpn.z = nvpn.z;
    
    pevalvieworientationmatrix3(&vrp, &vpn, &vup, 
				&error, viewrep.orientation_matrix);
    
    psetviewrep3( pexi, 1, &viewrep );
*/
    if ( redisp++ > 5 )
	DrawTheThing();
}

void rotatez(incz)
float incz;
{
    /* Set up a new PHIGS view */

    protatez( incz, &error, rotz );
    PexLocalTransform(pexi, PostConcatenate, rotz);
/*    
    ptranvc3(&vpn, rotz, &error, &nvpn);
    vpn.x = nvpn.x; vpn.y = nvpn.y; vpn.z = nvpn.z;
    
    pevalvieworientationmatrix3(&vrp, &vpn, &vup, 
				&error, viewrep.orientation_matrix);
    
    psetviewrep3( pexi, 1, &viewrep );
*/
    if ( redisp++ > 5 )
	DrawTheThing();
}


void translatex(incx)
float incx;
{
    /* set up a new PHIGS view */
    vrp.x -= 3.0 * incx;
    pevalvieworientationmatrix3(&vrp, &vpn, &vup, 
				&error, viewrep.orientation_matrix);
    
    psetviewrep3( pexi, 1, &viewrep );
    if ( redisp++ > 5 )
	DrawTheThing();
}

void translatey(incy)
float incy;
{
    /* set up a new PHIGS view */
    vrp.y -= 3.0 * incy;
    pevalvieworientationmatrix3(&vrp, &vpn, &vup, 
				&error, viewrep.orientation_matrix);
    
    psetviewrep3( pexi, 1, &viewrep );
    if ( redisp++ > 5 )
	DrawTheThing();
}

    


void translatez(incz)
float incz;
{
    /* set up a new PHIGS view */
    vrp.z -= 3.0 * incz;
    pevalvieworientationmatrix3(&vrp, &vpn, &vup, 
				&error, viewrep.orientation_matrix);
    
    psetviewrep3( pexi, 1, &viewrep );
    if ( redisp++ > 5 )
	DrawTheThing();
}
