/* 
 * phigs.h - The C-bindings include file.
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */


/*****************************************************************************
 *	Notes: This is the C-binding phigs include file.  Nothing should be
 *			changed in this file.
 *****************************************************************************
 */

#ifndef PHIGS_H_included
#define PHIGS_H_included

typedef struct implementation_defined_structure * Pconnid;

typedef struct implementation_defined_structure * Pwstype;

typedef int Pint;

typedef long Plong;

typedef float Pfloat;

typedef char Pchar;

typedef Pfloat Pmatrix3[4][4];

typedef Pfloat Pmatrix[3][3];

typedef enum {
    PWORKSTATION_INDEPENDENT,
    PWORKSTATION_DEPENDENT
} Pwsdep;

typedef enum {
    PPHCL,
    PPHOP
} Psystemstate;

typedef enum {
    PWSCL,
    PWSOP
} Pwsstate;

typedef enum {
    PSTCL,
    PSTOP
} Pstructstate;

typedef enum {
    PSTAT_NON_EXISTENT,
    PSTAT_EMPTY,
    PSTAT_NON_EMPTY
} Pstructstatus;

typedef enum {
    PARCL,
    PAROP
} Parchivestate;

typedef enum {
    PVECTOR,
    PRASTER,
    POTHER
} Pwsclass;

typedef enum {
    POUTPUT,
    PINPUT,
    POUTIN,
    PMO,
    PMI
} Pwscat;

typedef enum {
    PCONDITIONALLY,
    PALWAYS
} Pcontrol;

typedef enum {
    PPERFORM,
    PPOSTPONE
} Pregen;

typedef enum {
    PASAP,
    PBNIG,
    PBNIL,
    PASTI,
    PWAIT
} Pdefmode;

typedef enum {
    PNIVE,
    PUWOR,
    PUQUM
} Pmod;

typedef enum {
    PNOMORE,
    PMORE
} Psimultev;

typedef enum {
    PCSS,
    PARCHIVE
} Pstructnetsrc;

typedef enum {
    PDS_EMPTY,
    PDS_NOTEMPTY
} Pdspsurf;

typedef enum {
    PCORRECT,
    PDEFERRED,
    PSIMULATED
} Pvisualrep;

typedef enum {
    PPSTRING,
    PPCHAR,
    PPSTROKE
} Ptxprec;

typedef enum {
    PTP_RIGHT,
    PTP_LEFT,
    PTP_UP,
    PTP_DOWN
} Ptxpath;

typedef enum {
    PAH_NORMAL,
    PAH_LEFT,
    PAH_CENTRE,
    PAH_RIGHT
} Ptxhor;

typedef enum {
    PAV_NORMAL,
    PAV_TOP,
    PAV_CAP,
    PAV_HALF,
    PAV_BASE,
    PAV_BOTTOM
} Ptxver;

typedef enum {
    PHOLLOW,
    PSOLID,
    PPATTERN,
    PHATCH,
    PEMPTY
} Pinterstyle;

typedef enum {
    PEDGE_OFF,
    PEDGE_ON
} Pedgef;

typedef enum {
    PLINETYPE,
    PLINEWIDTH_SCALE_FACTOR,
    PPOLYLINE_COLOUR_INDEX,
    PMARKERTYPE,
    PMARKERSIZE_SCALE_FACTOR,
    PPOLYMARKER_COLOUR_INDEX,
    PTEXT_FONT,
    PTEXT_PRECISION,
    PCHARACTER_EXPANSION_FACTOR,
    PCHARACTER_SPACING,
    PTEXT_COLOUR_INDEX,
    PINTERIOR_STYLE,
    PINTERIOR_STYLE_INDEX,
    PINTERIOR_COLOUR_INDEX,
    PEDGE_FLAG,
    PEDGETYPE,
    PEDGEWIDTH_SCALE_FACTOR,
    PEDGE_COLOUR_INDEX
} Pattrid;

typedef enum {
    PBUNDLED,
    PINDIVIDUAL
} Pasf;

typedef enum {
    PCOLOUR,
    PMONOCHROME
} Pcoavail;

typedef enum {
    PPRECONCATENATE,
    PPOSTCONCATENATE,
    PREPLACE
} Pcomptype;

typedef enum {
    PPARALLEL,
    PPERSPECTIVE
} Pprojtype;

typedef enum {
    PCLIP,
    PNOCLIP
} Pclip;

typedef enum {
    PHIGHER,
    PLOWER
} Pvpri;

typedef enum {
    PMAINTAIN,
    PABANDON,
    PUPDATE
} Pconfres;

typedef enum {
    PPF_POLYLINE,
    PPF_FILLAREA,
    PPF_FILLAREA_SET
} Ppfcf;

typedef enum {
    PTOP_FIRST,
    PBOTTOM_FIRST
} Ppathorder;

typedef enum {
    PREQUEST,
    PSAMPLE,
    PEVENT
} Pimode;

typedef enum {
    PES_ECHO,
    PES_NOECHO
} Pesw;

typedef enum {
    PSTAT_OK,
    PSTAT_NONE
} Pistatus;

typedef enum {
    PCH_OK,
    PCH_NOCHOICE
} Pchoicestatus;

typedef enum {
    PQCH_OK,
    PQCH_NOCHOICE,
    PQCH_NONE
} Pqchoicestatus;

typedef enum {
    PQP_OK,
    PQP_NOPICK,
    PQP_NONE
} Pqpickstatus;

typedef enum {
    PP_OK,
    PP_NOPICK
} Ppickstatus;

typedef enum {
    PSTRUCT_NONE,
    PSTRUCT_OPEN
} Popenstructstatus;

typedef enum {
    PF_LOCATOR,
    PF_STROKE,
    PF_VALUATOR,
    PF_CHOICE,
    PF_PICK,
    PF_STRING
} Pfclass;

typedef enum {
    PI_NONE,
    PI_LOCATOR,
    PI_STROKE,
    PI_VALUATOR,
    PI_CHOICE,
    PI_PICK,
    PI_STRING
} Piclass;

typedef enum {
    PPR_OFF,
    PPR_ON
} Pprf;

typedef enum {
    PSET,
    PREALIZED
} Pinqtype;

typedef enum {
    PNOTPENDING,
    PPENDING
} Pupdatest;

typedef enum {
    PDC_METERS,
    PDC_OTHER
} Pdevunits;

typedef enum {
    PIRG,
    PIMM,
    PCBS
} Pmodtype;

typedef enum {
    PPOLYLINE,
    PPOLYMARKER,
    PTEXT,
    PINTERIOR,
    PEDGE
} Pattrs;

typedef enum {
    PEL_NIL,
    PEL_POLYLINE3,
    PEL_POLYLINE,
    PEL_POLYMARKER3,
    PEL_POLYMARKER,
    PEL_TEXT3,
    PEL_TEXT,
    PEL_ANNOTATION_TEXT_FIXED3,
    PEL_ANNOTATION_TEXT_FIXED,
    PEL_ANNOTATION_TEXT_RELATIVE3,
    PEL_ANNOTATION_TEXT_RELATIVE,
    PEL_FILL_AREA3,
    PEL_FILL_AREA,
    PEL_FILL_AREA_SET3,
    PEL_FILL_AREA_SET,
    PEL_CELL_ARRAY3,
    PEL_CELL_ARRAY,
    PEL_GDP3,
    PEL_GDP,
    PEL_POLYLINE_INDEX,
    PEL_POLYMARKER_INDEX,
    PEL_TEXT_INDEX,
    PEL_INTERIOR_INDEX,
    PEL_EDGE_INDEX,
    PEL_LINETYPE,
    PEL_LINEWIDTH_SCALE_FACTOR,
    PEL_POLYLINE_COLOUR_INDEX,
    PEL_MARKER_TYPE,
    PEL_MARKER_SIZE_SCALE_FACTOR,
    PEL_MARKER_COLOUR_INDEX,
    PEL_TEXT_FONT,
    PEL_TEXT_PRECISION,
    PEL_CHARACTER_EXPANSION_FACTOR,
    PEL_CHARACTER_SPACING,
    PEL_TEXT_COLOUR_INDEX,
    PEL_CHARACTER_HEIGHT,
    PEL_CHARACTER_UP_VECTOR,
    PEL_TEXT_PATH,
    PEL_TEXT_ALIGNMENT,
    PEL_ANNOTATION_TEXT_CHARACTER_HEIGHT,
    PEL_ANNOTATION_TEXT_CHARACTER_UP_VECTOR,
    PEL_ANNOTATION_TEXT_PATH,
    PEL_ANNOTATION_TEXT_ALIGNMENT,
    PEL_ANNOTATION_STYLE,
    PEL_INTERIOR_STYLE,
    PEL_INTERIOR_STYLE_INDEX,
    PEL_INTERIOR_COLOUR_INDEX,
    PEL_EDGE_FLAG,
    PEL_EDGETYPE,
    PEL_EDGEWIDTH_SCALE_FACTOR,
    PEL_EDGE_COLOUR_INDEX,
    PEL_PATTERN_SIZE,
    PEL_PATTERN_REFERENCE_POINT_AND_VECTORS,
    PEL_PATTERN_REFERENCE_POINT,
    PEL_ADD_NAMES_TO_SET,
    PEL_REMOVE_NAMES_FROM_SET,
    PEL_INDIVIDUAL_ASF,
    PEL_HLHSR_IDENTIFIER,
    PEL_LOCAL_MODELLING_TRANSFORMATION3,
    PEL_LOCAL_MODELLING_TRANSFORMATION,
    PEL_GLOBAL_MODELLING_TRANSFORMATION3,
    PEL_GLOBAL_MODELLING_TRANSFORMATION,
    PEL_MODELLING_CLIPPING_VOLUME,
    PEL_MODELLING_CLIPPING_INDICATOR,
    PEL_RESTORE_MODELLING_CLIPPING_VOLUME,
    PEL_VIEW_INDEX,
    PEL_EXECUTE_STRUCTURE,
    PEL_LABEL,
    PEL_APPLICATION_DATA,
    PEL_GSE,
    PEL_PICK_ID
} Peltype;

typedef enum {
    PEDIT_INSERT,
    PEDIT_REPLACE
} Peditmode;

typedef enum {
    PDELETE,
    PKEEP
} Preff;

typedef enum {
    PABSENT,
    PPRESENT
} Pcovalid;

typedef enum {
    PERROR_OFF,
    PERROR_ON
} Perrormode;

typedef enum {
    PFORWARD,
    PBACKWARD
} Psrchdir;

typedef enum {
    PSUCCESS,
    PFAILURE
} Psrchstatus;

typedef enum {
    PSEL_ALL,
    PSEL_NIL,
    PSEL_POLYLINE3,
    PSEL_POLYLINE,
    PSEL_POLYMARKER3,
    PSEL_POLYMARKER,
    PSEL_TEXT3,
    PSEL_TEXT,
    PSEL_ANNOTATION_TEXT_FIXED3,
    PSEL_ANNOTATION_TEXT_FIXED,
    PSEL_ANNOTATION_TEXT_RELATIVE3,
    PSEL_ANNOTATION_TEXT_RELATIVE,
    PSEL_FILL_AREA3,
    PSEL_FILL_AREA,
    PSEL_FILL_AREA_SET3,
    PSEL_FILL_AREA_SET,
    PSEL_CELL_ARRAY3,
    PSEL_CELL_ARRAY,
    PSEL_GDP3,
    PSEL_GDP,
    PSEL_POLYLINE_INDEX,
    PSEL_POLYMARKER_INDEX,
    PSEL_TEXT_INDEX,
    PSEL_INTERIOR_INDEX,
    PSEL_EDGE_INDEX,
    PSEL_LINETYPE,
    PSEL_LINEWIDTH_SCALE_FACTOR,
    PSEL_POLYLINE_COLOUR_INDEX,
    PSEL_MARKER_TYPE,
    PSEL_MARKER_SIZE_SCALE_FACTOR,
    PSEL_MARKER_COLOUR_INDEX,
    PSEL_TEXT_FONT,
    PSEL_TEXT_PRECISION,
    PSEL_CHARACTER_EXPANSION_FACTOR,
    PSEL_CHARACTER_SPACING,
    PSEL_TEXT_COLOUR_INDEX,
    PSEL_CHARACTER_HEIGHT,
    PSEL_CHARACTER_UP_VECTOR,
    PSEL_TEXT_PATH,
    PSEL_TEXT_ALIGNMENT,
    PSEL_ANNOTATION_TEXT_CHARACTER_HEIGHT,
    PSEL_ANNOTATION_TEXT_CHARACTER_UP_VECTOR,
    PSEL_ANNOTATION_TEXT_PATH,
    PSEL_ANNOTATION_TEXT_ALIGNMENT,
    PSEL_ANNOTATION_STYLE,
    PSEL_INTERIOR_STYLE,
    PSEL_INTERIOR_STYLE_INDEX,
    PSEL_INTERIOR_COLOUR_INDEX,
    PSEL_EDGE_FLAG,
    PSEL_EDGETYPE,
    PSEL_EDGEWIDTH_SCALE_FACTOR,
    PSEL_EDGE_COLOUR_INDEX,
    PSEL_PATTERN_SIZE,
    PSEL_PATTERN_REFERENCE_POINT_AND_VECTORS,
    PSEL_PATTERN_REFERENCE_POINT,
    PSEL_ADD_NAMES_TO_SET,
    PSEL_REMOVE_NAMES_FROM_SET,
    PSEL_INDIVIDUAL_ASF,
    PSEL_HLHSR_IDENTIFIER,
    PSEL_LOCAL_MODELLING_TRANSFORMATION3,
    PSEL_LOCAL_MODELLING_TRANSFORMATION,
    PSEL_GLOBAL_MODELLING_TRANSFORMATION3,
    PSEL_GLOBAL_MODELLING_TRANSFORMATION,
    PSEL_MODELLING_CLIPPING_VOLUME,
    PSEL_MODELLING_CLIPPING_INDICATOR,
    PSEL_RESTORE_MODELLING_CLIPPING_VOLUME,
    PSEL_VIEW_INDEX,
    PSEL_EXECUTE_STRUCTURE,
    PSEL_LABEL,
    PSEL_APPLICATION_DATA,
    PSEL_GSE,
    PSEL_PICK_ID
} Psrcheltype;

typedef struct {
    Pint	number;	/* number of Pints in list */
    Pint	*integers;	/* list of integers */
} Pintlst;

typedef struct {
    Pint	number;	/* number of Pfloats in list */
    Pfloat	*floats;	/* list of floats */
} Pfloatlst;

typedef struct {
    Pint	number;	/* number of WS types in list */
    Pwstype	*ws_types;	/* list of types */
} Pwstypelst;

typedef struct {
    Pint	id;	/* GSE identifier */
    Pwsdep	indicator;	/* WS independent/dependent indicator */
} Pgseiddep;

typedef struct {
    Pint	number;	/* number of identifiers/dependency element */
    Pgseiddep	*id_depend;	/* list */
} Pgseiddeplst;

typedef struct {
    Pint	number;	/* number of identifiers and names */
    Pint	*ids;	/* list of identifiers */
    Pchar	**names;	/* list of names */
} Parchivefilelst;

typedef struct {
    Pint	struct_id;	/* structure identifier */
    Pint	elem_num;	/* element number */
} Pexecref;

typedef struct {
    Pint	number;	/* number of execute references */
    Pexecref	*ers;	/* list of execute references */
} Pexecreflst;

typedef struct {
    Pint	number;	/* number of execute references */
    Pexecreflst	*erls;	/* list of execute reference lists */
} Pexecreflstlst;

typedef struct {
    Pint	id;	/* structure id */
    Pfloat	priority;	/* structure priority */
} Pstructpost;

typedef struct {
    Pint	number;	/* number of structure postings */
    Pstructpost	*postings;	/* list of postings */
} Pstructpostlst;

typedef struct {
    Pint	number;	/* number of strings */
    Pchar	**strings;	/* list of strings */
} Pstringlst;

typedef struct {
    Pint	size;	/* sizeof data */
    Pchar	*data;	/* pointer to data */
} Pdata;

typedef struct {
    Pfloat	x;	/* x coordinate */
    Pfloat	y;	/* y coordinate */
} Ppoint;

typedef struct {
    Pfloat	x;	/* x coordinate */
    Pfloat	y;	/* y coordinate */
    Pfloat	z;	/* z coordinate */
} Ppoint3;

typedef struct {
    Pint	x;	/* x coordinate */
    Pint	y;	/* y coordinate */
} Pipoint;

typedef struct {
    Pint	x;	/* x coordinate */
    Pint	y;	/* y coordinate */
    Pint	z;	/* z coordinate */
} Pipoint3;

typedef struct {
    Pfloat	x;	/* x coordinate */
    Pfloat	y;	/* y coordinate */
} Pvector;

typedef struct {
    Pfloat	x;	/* x coordinate */
    Pfloat	y;	/* y coordinate */
    Pfloat	z;	/* z coordinate */
} Pvector3;

typedef struct {
    Ppoint3	pt;	/* point */
    Pvector3	normal;	/* normal */
} Phalfspace;

typedef struct {
    Ppoint	ll;	/* lower left */
    Ppoint	ur;	/* upper right */
} Prect;

typedef struct {
    Ppoint3	fll;	/* front lower left */
    Ppoint3	bur;	/* back upper right */
} Prect3;

typedef struct {
    Pfloat	xmin;	/* x min */
    Pfloat	xmax;	/* x max */
    Pfloat	ymin;	/* y min */
    Pfloat	ymax;	/* y max */
    Pfloat	zmin;	/* z min */
    Pfloat	zmax;	/* z max */
} Plimit3;

typedef struct {
    Pfloat	xmin;	/* x min */
    Pfloat	xmax;	/* x max */
    Pfloat	ymin;	/* y min */
    Pfloat	ymax;	/* y max */
} Plimit;

typedef struct {
    Pint	xmin;	/* x min */
    Pint	xmax;	/* x max */
    Pint	ymin;	/* y min */
    Pint	ymax;	/* y max */
    Pint	zmin;	/* z min */
    Pint	zmax;	/* z max */
} Pilimit3;

typedef struct {
    Pint	xmin;	/* x min */
    Pint	xmax;	/* x max */
    Pint	ymin;	/* y min */
    Pint	ymax;	/* y max */
} Pilimit;

typedef struct {
    Pint	number;	/* number of Ppoints in the list */
    Ppoint	*points;	/* list of points */
} Ppointlst;

typedef struct {
    Pint	number;	/* number of Ppoint3s in the list */
    Ppoint3	*points;	/* list of points */
} Ppointlst3;

typedef struct {
    Pint	number;	/* number of half spaces */
    Phalfspace	*half_spaces;	/* list of half_spaces */
} Phalfspacelst;

typedef struct {
    Ptxhor	hor;	/* horizontal component */
    Ptxver	ver;	/* vertical component */
} Ptxalign;

typedef struct {
    Pint	type;	/* line type */
    Pfloat	width;	/* linewidth scale factor */
    Pint	colour;	/* colour index */
} Plnbundl;

typedef struct {
    Pint	type;	/* marker type */
    Pfloat	size;	/* marker size scale factor */
    Pint	colour;	/* colour index */
} Pmkbundl;

typedef struct {
    Pint	font;	/* text font */
    Ptxprec	precision;	/* text precision */
    Pfloat	exp;	/* character expansion factor */
    Pfloat	space;	/* character spacing */
    Pint	colour;	/* text colour index */
} Ptxbundl;

typedef struct {
    Pinterstyle	style;	/* interior style */
    Pint	index;	/* interior style index */
    Pint	colour;	/* interior colour index */
} Pinterbundl;

typedef struct {
    Pedgef	flag;	/* edge flag */
    Pint	type;	/* edgetype */
    Pfloat	scale;	/* edgewidth scale factor */
    Pint	colour;	/* edge colour index */
} Pedgebundl;

typedef struct {
    Pint	x_dim;	/* dimension (number of divisions) along X */
    Pint	y_dim;	/* dimension (number of divisions) along Y */
} Pdim;

typedef struct {
    Pdim	dim;	/* pattern's dimensions */
    Pint	*array;	/* colour index array */
} Pptbundl;

typedef struct {
    Pfloat	x;	/* red, hue, etc */
    Pfloat	y;	/* green, saturation, lightness, etc */
    Pfloat	z;	/* blue, value, saturation, etc */
} Pcobundl;

typedef struct {
    Pmatrix3	orientation_matrix;	/* orientation matrix */
    Pmatrix3	mapping_matrix;	/* mapping matrix */
    Plimit3	clip_limit;	/* clipping limits */
    Pclip	clip_xy;	/* X-Y clipping indicator */
    Pclip	clip_back;	/* back clipping indicator */
    Pclip	clip_front;	/* front clipping indicator */
} Pviewrep3;

typedef struct {
    Pmatrix	orientation_matrix;	/* orientation matrix */
    Pmatrix	mapping_matrix;	/* mapping matrix */
    Plimit	clip_limit;	/* clipping limits */
    Pclip	clip_xy;	/* X-Y clipping indicator */
} Pviewrep;

typedef struct {
    Plimit	window;	/* window limits */
    Plimit3	viewport;	/* viewport limits */
    Pprojtype	proj;	/* projection type */
    Ppoint3	prp;	/* projection reference point */
    Pfloat	view_plane;	/* view plane distance */
    Pfloat	back_plane;	/* back plane distance */
    Pfloat	front_plane;	/* front plane distance */
} Pviewmapping3;

typedef struct {
    Plimit	window;	/* window limits */
    Plimit	viewport;	/* viewport limits */
} Pviewmapping;

typedef struct {
    Pasf	type;	/* line type asf */
    Pasf	width;	/* line width asf */
    Pasf	colour;	/* line colour index asf */
    Pint	index;	/* line index */
    Plnbundl	bundl;	/* line bundle */
} Plnattr;

typedef struct {
    Pasf	interior;	/* interior asf */
    Pasf	style;	/* interior style asf */
    Pasf	colour;	/* interior colour index asf */
    Pint	index;	/* interior index */
    Pinterbundl	bundl;	/* interior bundle */
} Pinterattr;

typedef struct {
    Pasf	flag;	/* edge flag asf */
    Pasf	width;	/* edge width asf */
    Pasf	colour;	/* edge colour index asf */
    Pint	index;	/* edge index */
    Pedgebundl	bundl;	/* edge bundle */
} Pedgeattr;

typedef struct {
    Pasf	type;	/* marker type asf */
    Pasf	style;	/* marker style asf */
    Pasf	colour;	/* marker colour index asf */
    Pint	index;	/* marker index */
    Pmkbundl	bundl;	/* marker bundle */
} Pmkattr;

typedef struct {
    Pint	view_index;	/* view index */
    Ppoint3	position;	/* point */
} Ploc3;

typedef struct {
    Pint	view_index;	/* view index */
    Ppoint	position;	/* point */
} Ploc;

typedef struct {
    Pint	view_index;	/* view index */
    Pint	n_points;	/* number of points in stroke */
    Ppoint3	*points;	/* points in stroke */
} Pstroke3;

typedef struct {
    Pint	view_index;	/* view index */
    Pint	n_points;	/* number of points in stroke */
    Ppoint	*points;	/* points in stroke */
} Pstroke;

typedef struct {
    Pchoicestatus	status;	/* status of request */
    Pint	choice;	/* choice value */
} Pchoice;

typedef struct {
    Pint	struct_id;	/* structure identifier */
    Pint	pick_id;	/* hierarchical pick identifier */
    Pint	el_num;	/* element sequence number */
} Ppickpathel;

typedef struct {
    Pint	depth;	/* pick path depth */
    Ppickpathel	*pick_path;	/* pick path list */
} Ppickpath;

typedef struct {
    Ppickstatus	status;	/* pick status */
    Ppickpath	pick_path;	/* pick path */
} Ppick;

typedef struct {
    Pistatus	status;	/* status of request */
    Ploc3	loc;	/* locator data */
} Pqloc3;

typedef struct {
    Pistatus	status;	/* status of request */
    Ploc	loc;	/* locator data */
} Pqloc;

typedef struct {
    Pistatus	status;	/* status of request */
    Pstroke3	stroke;	/* stroke data */
} Pqstroke3;

typedef struct {
    Pistatus	status;	/* status of request */
    Pstroke	stroke;	/* stroke data */
} Pqstroke;

typedef struct {
    Pistatus	status;	/* status of request */
    Pfloat	val;	/* valuator value */
} Pqval;

typedef struct {
    Pqchoicestatus	status;	/* status of request */
    Pint	choice;	/* choice value */
} Pqchoice;

typedef struct {
    Pqpickstatus	status;	/* status of request */
    Ppickpath	pick;	/* pick information */
} Pqpick;

typedef struct {
    Pistatus	status;	/* status of request */
    Pchar	*string;	/* string */
} Pqstring;

typedef struct {
    Pint	ws;	/* workstation identifier */
    Piclass	class;	/* device class */
    Pint	dev;	/* logical input device number */
} Pevent;

typedef struct {
    Pupdatest	state;	/* update state */
    Plimit3	req_window;	/* requested workstation window */
    Plimit3	cur_window;	/* current workstation window */
    Plimit3	req_viewport;	/* requested workstation viewport */
    Plimit3	cur_viewport;	/* current workstation viewport */
} Pwstran3;

typedef struct {
    Pupdatest	state;	/* update state */
    Plimit	req_window;	/* requested workstation window */
    Plimit	cur_window;	/* current workstation window */
    Plimit	req_viewport;	/* requested workstation viewport */
    Plimit	cur_viewport;	/* current workstation viewport */
} Pwstran;

typedef struct {
    Pdevunits	units;	/* device coordinate units */
    Ppoint	device;	/* device size in coordinate units */
    Pipoint	raster;	/* device size in raster units */
} Pdspsize;

typedef struct {
    Pdevunits	units;	/* device coordinate units */
    Ppoint3	device;	/* device volume in coordinate units */
    Pipoint3	raster;	/* device volume in raster units */
} Pdspsize3;

typedef struct {
    Pmodtype	line;	/* polyline representation */
    Pmodtype	marker;	/* polymarker representation */
    Pmodtype	text;	/* text representation */
    Pmodtype	interior;	/* interior representation */
    Pmodtype	edge;	/* edge representation */
    Pmodtype	pattern;	/* pattern representation */
    Pmodtype	colour;	/* colour representation */
    Pmodtype	view;	/* view representation */
    Pmodtype	wstran;	/* workstation transform */
    Pmodtype	highlight;	/* highlight filter */
    Pmodtype	invis;	/* invisibility filter */
    Pmodtype	hlhsr;	/* HLHSR mode */
} Pmodws;

typedef struct {
    Pdefmode	def_mode;	/* deferral mode */
    Pmod	mod_mode;	/* modification mode */
} Pdefupdatest;

typedef struct {
    Pintlst	types;	/* list of line types */
    Pint	widths;	/* number of available line widths */
    Pfloat	nom_width;	/* nominal line width */
    Pfloat	min_width;	/* min line width */
    Pfloat	max_width;	/* max line width */
    Pint	predefined;	/* number of predefined bundles */
} Plnfac;

typedef struct {
    Pintlst	types;	/* list of marker types */
    Pint	sizes;	/* number of available marker sizes */
    Pfloat	nom;	/* nominal marker size */
    Pfloat	minn;	/* min marker size */
    Pfloat	maxx;	/* max marker size */
    Pint	predefined;	/* number of predefined bundles */
} Pmkfac;

typedef struct {
    Pint	font;	/* text font */
    Ptxprec	precision;	/* text precision */
} Ptxfp;

typedef struct {
    Pint	n_fps;	/* number of fonts and precisions */
    Ptxfp	*fps;	/* list of fonts and precisions */
    Pint	heights;	/* number of character heights */
    Pfloat	min_ht;	/* minimum height */
    Pfloat	max_ht;	/* maximum height */
    Pint	expansions;	/* number of character expansion factors */
    Pfloat	min_exp;	/* minimum expansion factor */
    Pfloat	max_exp;	/* maximum expansion factor */
    Pint	predefined;	/* number of predefined bundles */
} Ptxfac;

typedef struct {
    Pint	n_inter;	/* number of interior styles */
    Pinterstyle	*interiors;	/* list of available interior styles */
    Pintlst	hatches;	/* list of available hatch styles */
    Pint	predefined;	/* number of predefined bundles */
} Pinterfac;

typedef struct {
    Pintlst	types;	/* list of edge types */
    Pint	widths;	/* number of available edge widths */
    Pfloat	nom;	/* nominal edge width */
    Pfloat	minn;	/* min edge width */
    Pfloat	maxx;	/* max edge width */
    Pint	predefined;	/* number of predefined bundles */
} Pedgefac;

typedef struct {
    Pint	colours;	/* number of colours */
    Pcoavail	coavail;	/* colour availability */
    Pint	predefined;	/* number of predefined bundles */
} Pcofac;

typedef struct {
    Pint	number;	/* number of GDPs */
    Pattrs	*attrs;	/* list of attributes used */
} Pgdpfac;

typedef struct {
    Pint	line;	/* polyline tables */
    Pint	mark;	/* polymarker tables */
    Pint	text;	/* text tables */
    Pint	interior;	/* interior tables */
    Pint	edge;	/* edge tables */
    Pint	pat;	/* pattern tables */
    Pint	colour;	/* colour tables */
    Pint	view;	/* view tables */
} Pwstables;

typedef struct {
    Pmodtype	content;	/* structure content */
    Pmodtype	post;	/* post structure  */
    Pmodtype	unpost;	/* unpost structure  */
    Pmodtype	delete;	/* delete structure  */
    Pmodtype	reference;	/* structure reference  */
} Pmodstruct;

typedef struct {
    Pint	locator;	/* locators */
    Pint	stroke;	/* strokes */
    Pint	valuator;	/* valuators */
    Pint	choice;	/* choices */
    Pint	pick;	/* picks */
    Pint	string;	/* strings */
} Pnumdev;

typedef struct {
    Pint	number;	/* number of elements */
    Psrcheltype	*elems;	/* list of elements */
} Psrcheltypelst;

typedef union {
    int dot_dot_dot;/*. . . */    /* Metafile Records */
} Pitemrec;

typedef struct {
    int dot_dot_dot;/*. . . */    /* implementation dependent */
} Plocpet0001;

typedef struct {
    int dot_dot_dot;/*. . . */    /* implementation dependent */
} Plocpet0002;

typedef struct {
    int dot_dot_dot;/*. . . */    /* implementation dependent */
} Plocpet0003;

typedef struct {
    Plnattr	ln;	/* polyline attributes */
    int dot_dot_dot;/*. . . */    /* implementation dependent */
} Plocpet0004;

typedef struct {
    Ppfcf	pfcf;	/* polyline/fillarea control flag */
    union {
        Plnattr	ln;	/* polyline attributes */
        Pinterattr	in;	/* interior attributes */
        struct {
            Pinterattr	in;	/* interior attributes */
            Pedgeattr	edge;	/* edge attributes */
        } fas;
    } attr;
    int dot_dot_dot;/*. . . */    /* implementation dependent */
} Plocpet0005;

typedef struct {
    int dot_dot_dot;/*. . . */    /* implementation dependent */
} Plocpet0006;

typedef struct {
    Pint	bufsiz;	/* input buffer size */
    Pint	editpos;	/* editing position */
    Ppoint	interval;	/* x y interval */
    Pfloat	time;	/* time interval */
    int dot_dot_dot;/*. . . */    /* implementation dependent */
} Pstrokepet0001;

typedef struct {
    Pint	bufsiz;	/* input buffer size */
    Pint	editpos;	/* editing position */
    Ppoint	interval;	/* x y interval */
    Pfloat	time;	/* time interval */
    int dot_dot_dot;/*. . . */    /* implementation dependent */
} Pstrokepet0002;

typedef struct {
    Pint	bufsiz;	/* input buffer size */
    Pint	editpos;	/* editing position */
    Ppoint	interval;	/* x y interval */
    Pfloat	time;	/* time interval */
    Pmkattr	mk;	/* marker attributes */
    int dot_dot_dot;/*. . . */    /* implementation dependent */
} Pstrokepet0003;

typedef struct {
    Pint	bufsiz;	/* input buffer size */
    Pint	editpos;	/* editing position */
    Ppoint	interval;	/* x y interval */
    Pfloat	time;	/* time interval */
    Plnattr	ln;	/* line attributes */
    int dot_dot_dot;/*. . . */    /* implementation dependent */
} Pstrokepet0004;

typedef struct {
    Pfloat	low;	/* low range limit */
    Pfloat	high;	/* high range limit */
    int dot_dot_dot;/*. . . */    /* implementation dependent */
} Pvalpet0001;

typedef struct {
    Pfloat	low;	/* low range limit */
    Pfloat	high;	/* high range limit */
    int dot_dot_dot;/*. . . */    /* implementation dependent */
} Pvalpet0002;

typedef struct {
    Pfloat	low;	/* low range limit */
    Pfloat	high;	/* high range limit */
    int dot_dot_dot;/*. . . */    /* implementation dependent */
} Pvalpet0003;

typedef struct {
    int dot_dot_dot;/*. . . */    /* implementation dependent */
} Pchoicepet0001;

typedef struct {
    Pint	number;	/* number of alternatives */
    Pprf	*enable;	/* array of prompts */
    int dot_dot_dot;/*. . . */    /* implementation dependent */
} Pchoicepet0002;

typedef struct {
    Pint	number;	/* number of choice strings */
    Pchar	**strings;	/* array of choice strings */
    int dot_dot_dot;/*. . . */    /* implementation dependent */
} Pchoicepet0003;

typedef struct {
    Pint	number;	/* number of choice strings */
    Pchar	**strings;	/* array of strings */
    int dot_dot_dot;/*. . . */    /* implementation dependent */
} Pchoicepet0004;

typedef struct {
    Pint	struct_id;	/* struct identifier */
    Pint	number;	/* number of alternatives */
    Pint	*pickids;	/* array of pick identifiers */
    int dot_dot_dot;/*. . . */    /* implementation dependent */
} Pchoicepet0005;

typedef struct {
    int dot_dot_dot;/*. . . */    /* implementation dependent */
} Ppickpet0001;

typedef struct {
    int dot_dot_dot;/*. . . */    /* implementation dependent */
} Ppickpet0002;

typedef struct {
    int dot_dot_dot;/*. . . */    /* implementation dependent */
} Ppickpet0003;

typedef struct {
    Pint	bufsiz;	/* buffer size */
    Pint	position;	/* initial cursor position */
    int dot_dot_dot;/*. . . */    /* implementation dependent */
} Pstringpet0001;

typedef struct {
    int dot_dot_dot;/*. . . */    /* implementation dependent */
} Pgdp0001rec3;

typedef struct {
    int dot_dot_dot;/*. . . */    /* implementation dependent */
} Pgdp0001rec;

typedef struct {
    int dot_dot_dot;/*. . . */    /* implementation dependent */
} Pescapeoutrec0001;

typedef struct {
    int dot_dot_dot;/*. . . */    /* implementation dependent */
} Pescapeinrec0001;

typedef struct {
    int dot_dot_dot;/*. . . */    /* implementation dependent */
} Pgse0001rec;

typedef union {
    Plocpet0001	locpet1_datarec;	/* pet 1 data record */
    Plocpet0002	locpet2_datarec;	/* pet 2 data record */
    Plocpet0003	locpet3_datarec;	/* pet 3 data record */
    Plocpet0004	locpet4_datarec;	/* pet 4 data record */
    Plocpet0005	locpet5_datarec;	/* pet 5 data record */
    Plocpet0006	locpet6_datarec;	/* pet 6 data record */
    int dot_dot_dot;/*. . . */    /* implementation dependent records */
} Plocrec;

typedef union {
    Pstrokepet0001	strokepet1_datarec;	/* pet 1 data record */
    Pstrokepet0002	strokepet2_datarec;	/* pet 2 data record */
    Pstrokepet0003	strokepet3_datarec;	/* pet 3 data record */
    Pstrokepet0004	strokepet4_datarec;	/* pet 4 data record */
    int dot_dot_dot;/*. . . */    /* implementation defined PET's */
} Pstrokerec;

typedef union {
    Pvalpet0001	valpet1_datarec;	/* pet 1 data record */
    Pvalpet0002	valpet2_datarec;	/* pet 2 data record */
    Pvalpet0003	valpet3_datarec;	/* pet 3 data record */
    int dot_dot_dot;/*. . . */    /* implementation defined PET's */
} Pvalrec;

typedef union {
    Pchoicepet0001	choicepet1_datarec;	/* pet 1 data record */
    Pchoicepet0002	choicepet2_datarec;	/* pet 2 data record */
    Pchoicepet0003	choicepet3_datarec;	/* pet 3 data record */
    Pchoicepet0004	choicepet4_datarec;	/* pet 4 data record */
    Pchoicepet0005	choicepet5_datarec;	/* pet 5 data record */
    int dot_dot_dot;/*. . . */    /* implementation defined PET's */
} Pchoicerec;

typedef union {
    Ppickpet0001	pickpet1_datarec;	/* pet 1 data record */
    Ppickpet0002	pickpet2_datarec;	/* pet 2 data record */
    Ppickpet0003	pickpet3_datarec;	/* pet 3 data record */
    int dot_dot_dot;/*. . . */    /* implementation defined PET's */
} Ppickrec;

typedef union {
    Pstringpet0001	stringpet1_datarec;	/* pet 1 data record */
    int dot_dot_dot;/*. . . */    /* implementation defined PET's */
} Pstringrec;

typedef union {
    Pgdp0001rec	gdp1_datarec;	/* GDP1 data record */
    int dot_dot_dot;/*. . . */    /* More GDP structures */
    Pdata	unsupported;	/* unsupported GDP data record */
} Pgdprec;

typedef union {
    Pgdp0001rec3	gdp1_datarec;	/* GDP data record */
    int dot_dot_dot;/*. . . */    /* More GDP structures */
    Pdata	unsupported;	/* unsupported GDP data record */
} Pgdprec3;

typedef union {
    Pgse0001rec	gse1_datarec;	/* GSE 1 data record */
    int dot_dot_dot;/*. . . */    /* More escape data structures */
    Pdata	unsupported;	/* unsupported GSE data record */
} Pgserec;

typedef union {
    Pescapeoutrec0001	esc1_odatarec;	/* Escape output data record */
    int dot_dot_dot;/*. . . */    /* More escape data structures */
} Pescapeout;

typedef union {
    Pescapeinrec0001	esc1_idatarec;	/* Escape input data record */
    int dot_dot_dot;/*. . . */    /* More escape data structures */
} Pescapein;

typedef union {
    Pint	idata;	/* integer valued data */
    Pfloat	fdata;	/* float valued data */
    Ppointlst3	pts3;	/* list of 3d points */
    Ppointlst	pts;	/* list of 2d points */
    struct {
        Ppoint3	pt;	/* text pt */
        Pvector3	dir[2];	/* direction vectors */
        Pchar	*str;	/* text string */
    } text3;
    struct {
        Ppoint	pt;	/* text pt */
        Pchar	*str;	/* text string */
    } tx;
    struct {
        Ppoint3	ref_pt;	/* reference pt */
        Ppoint3	anno;	/* anno. pt/offset */
        Pchar	*str;	/* text string */
    } atx3;
    struct {
        Ppoint	ref_pt;	/* reference pt */
        Ppoint	anno;	/* anno. pt/offset */
        Pchar	*str;	/* text string */
    } atx;
    struct {
        Pint	n_sets;	/* number of sets */
        Ppointlst3	*sets;	/* list of sets */
    } fas3;
    struct {
        Pint	n_sets;	/* number of sets */
        Ppointlst	*sets;	/* list of sets */
    } fas;
    struct {
        Ppoint3	pgram[3];	/* parallelogram */
        Pdim	dim;	/* dimension */
        Pint	*colours;	/* colour array */
    } ca3;
    struct {
        Prect	rect;	/* rectangle */
        Pdim	dim;	/* dimension */
        Pint	*colours;	/* colour array */
    } ca;
    Ptxprec	tx_prec;	/* text precision */
    Pvector	char_up;	/* char up vector */
    Ptxpath	tx_path;	/* text path */
    Ptxalign	tx_align;	/* text alignment */
    Pinterstyle	int_style;	/* interior style */
    Pedgef	edge_flag;	/* edge flag */
    Ppoint	pt;	/* pat size or ref pt */
    struct {
        Ppoint3	pt;	/* pattern ref. pt */
        Pvector3	vec[2];	/* vectors */
    } pat;
    Pintlst	name_set;	/* name sets */
    struct {
        Pattrid	id;	/* attribute id */
        Pasf	asf;	/* asf */
    } asf;
    struct {
        Pcomptype	comp;	/* composition type */
        Pmatrix3	mat;	/* matrix */
    } mtran3;
    struct {
        Pcomptype	comp;	/* composition type */
        Pmatrix	mat;	/* matrix */
    } m_tran;
    Pmatrix3	gbl_tran3;	/* global transform3 */
    Pmatrix	gbl_tran;	/* global transform */
    struct {
        Pint	op;	/* operator */
        Phalfspacelst	hsp;	/* half space list */
    } mclip;
    Pclip	clip_ind;	/* clipping indicator */
    struct {
        Pint	id;	/* GDP3 id */
        Ppoint3	*pts;	/* pts */
        Pgdprec3	rec;	/* data record */
    } gdp3;
    struct {
        Pint	id;	/* GDP id */
        Ppoint	*pts;	/* pts */
        Pgdprec	rec;	/* data record */
    } gdp;
    struct {
        Pint	id;	/* GSE id */
        Pgserec	rec;	/* GSE data record */
    } gse;
    Pdata	appl_data;	/* application data */
} Peldata;

typedef struct {
    Pimode	mode;	/* operating mode */
    Pesw	esw;	/* echo switch */
    Ploc3	loc;	/* initial locator information */
    Pint	pet;	/* prompt/echo type */
    Plimit3	e_volume;	/* echo volume */
    Plocrec	record;	/* data record */
} Plocst3;

typedef struct {
    Pimode	mode;	/* operating mode */
    Pesw	esw;	/* echo switch */
    Ploc	loc;	/* initial locator information */
    Pint	pet;	/* prompt/echo type */
    Plimit	e_area;	/* echo area */
    Plocrec	record;	/* data record */
} Plocst;

typedef struct {
    Pimode	mode;	/* operating mode */
    Pesw	esw;	/* echo switch */
    Pstroke3	stroke;	/* initial stroke */
    Pint	pet;	/* prompt/echo type */
    Plimit3	e_volume;	/* echo volume */
    Pstrokerec	record;	/* data record */
} Pstrokest3;

typedef struct {
    Pimode	mode;	/* operating mode */
    Pesw	esw;	/* echo switch */
    Pstroke	stroke;	/* initial stroke */
    Pint	pet;	/* prompt/echo type */
    Plimit	e_area;	/* echo area */
    Pstrokerec	record;	/* data record */
} Pstrokest;

typedef struct {
    Pimode	mode;	/* operating mode */
    Pesw	esw;	/* echo switch */
    Pfloat	val;	/* initial value */
    Pint	pet;	/* prompt/echo type */
    Plimit3	e_volume;	/* echo volume */
    Pvalrec	record;	/* data record */
} Pvalst3;

typedef struct {
    Pimode	mode;	/* operating mode */
    Pesw	esw;	/* echo switch */
    Pfloat	val;	/* initial value */
    Pint	pet;	/* prompt/echo type */
    Plimit	e_area;	/* echo area */
    Pvalrec	record;	/* data record */
} Pvalst;

typedef struct {
    Pimode	mode;	/* operating mode */
    Pesw	esw;	/* echo switch */
    Pchoice	choice;	/* initial choice number and status */
    Pint	pet;	/* prompt/echo type */
    Plimit3	e_volume;	/* echo volume */
    Pchoicerec	record;	/* data record */
} Pchoicest3;

typedef struct {
    Pimode	mode;	/* operating mode */
    Pesw	esw;	/* echo switch */
    Pchoice	choice;	/* initial choice number and status */
    Pint	pet;	/* prompt/echo type */
    Plimit	e_area;	/* echo area */
    Pchoicerec	record;	/* data record */
} Pchoicest;

typedef struct {
    Pimode	mode;	/* operating mode */
    Pesw	esw;	/* echo switch */
    Pintlst	inclusion_filter;	/* pick inclusion filter */
    Pintlst	exclusion_filter;	/* pick exclusion filter */
    Ppick	pick;	/* pick path and status */
    Pint	pet;	/* prompt/echo type */
    Plimit3	e_volume;	/* echo volume */
    Ppickrec	record;	/* data record */
    Ppathorder	order;	/* path order */
} Ppickst3;

typedef struct {
    Pimode	mode;	/* operating mode */
    Pesw	esw;	/* echo switch */
    Pintlst	inclusion_filter;	/* pick inclusion filter */
    Pintlst	exclusion_filter;	/* pick exclusion filter */
    Ppick	pick;	/* pick path and status */
    Pint	pet;	/* prompt/echo type */
    Plimit	e_area;	/* echo area */
    Ppickrec	record;	/* data record */
    Ppathorder	order;	/* path order */
} Ppickst;

typedef struct {
    Pimode	mode;	/* operating mode */
    Pesw	esw;	/* echo switch */
    Pchar	*string;	/* initial string */
    Pint	pet;	/* prompt/echo type */
    Plimit3	e_volume;	/* echo volume */
    Pstringrec	record;	/* data record */
} Pstringst3;

typedef struct {
    Pimode	mode;	/* operating mode */
    Pesw	esw;	/* echo switch */
    Pchar	*string;	/* initial string */
    Pint	pet;	/* prompt/echo type */
    Plimit	e_area;	/* echo area */
    Pstringrec	record;	/* data record */
} Pstringst;

typedef struct {
    Ppoint3	position;	/* initial position */
    Pintlst	pets;	/* list of prompt and echo types */
    Plimit3	e_volume;	/* default echo volume */
    Plocrec	record;	/* default locator data record */
} Pdefloc3;

typedef struct {
    Ppoint	position;	/* initial position */
    Pintlst	pets;	/* list of prompt and echo types */
    Plimit	e_area;	/* default echo area */
    Plocrec	record;	/* default locator data record */
} Pdefloc;

typedef struct {
    Pint	bufsiz;	/* buffer size */
    Pintlst	pets;	/* list of prompt and echo types */
    Plimit3	e_volume;	/* default echo volume */
    Pstrokerec	record;	/* default stroke data record */
} Pdefstroke3;

typedef struct {
    Pint	bufsiz;	/* buffer size */
    Pintlst	pets;	/* list of prompt and echo types */
    Plimit	e_area;	/* default echo area */
    Pstrokerec	record;	/* default stroke data record */
} Pdefstroke;

typedef struct {
    Pfloat	value;	/* initial value */
    Pintlst	pets;	/* list of prompt and echo types */
    Plimit3	e_volume;	/* default echo volume */
    Pvalrec	record;	/* default valuator data record */
} Pdefval3;

typedef struct {
    Pfloat	value;	/* initial value */
    Pintlst	pets;	/* list of prompt and echo types */
    Plimit	e_area;	/* default echo area */
    Pvalrec	record;	/* default valuator data record */
} Pdefval;

typedef struct {
    Pint	choices;	/* maximum number of choices */
    Pintlst	pets;	/* list of prompt and echo types */
    Plimit3	e_volume;	/* default echo volume */
    Pchoicerec	record;	/* default choice data record */
} Pdefchoice3;

typedef struct {
    Pint	choices;	/* maximum number of choices */
    Pintlst	pets;	/* list of prompt and echo types */
    Plimit	e_area;	/* default echo area */
    Pchoicerec	record;	/* default choice data record */
} Pdefchoice;

typedef struct {
    Pintlst	pets;	/* list of prompt and echo types */
    Plimit3	e_volume;	/* default echo volume */
    Ppickrec	record;	/* default pick data record */
} Pdefpick3;

typedef struct {
    Pintlst	pets;	/* list of prompt and echo types */
    Plimit	e_area;	/* default echo area */
    Ppickrec	record;	/* default pick data record */
} Pdefpick;

typedef struct {
    Pint	bufsiz;	/* buffer size */
    Pintlst	pets;	/* list of prompt and echo types */
    Plimit3	e_volume;	/* default echo volume */
    Pstringrec	record;	/* default string data record */
} Pdefstring3;

typedef struct {
    Pint	bufsiz;	/* buffer size */
    Pintlst	pets;	/* list of prompt and echo types */
    Plimit	e_area;	/* default echo area */
    Pstringrec	record;	/* default string data record */
} Pdefstring;

#endif
