/* 
 * PViewRep.c - Set view Rep Request.
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#include "pexDICE.h"

PexSetViewRep(pexi, tableIndex, clipXY, clipBack, clipFront, 
	      orientation, mapping, xmin, xmax, ymin, ymax, zmin, zmax)
    register pexC *pexi;
    pexTableIndex tableIndex;
    Pclip clipXY, clipBack, clipFront;
    pexMatrix *orientation, mapping;
    FLOAT xmin, xmax, ymin, ymax, zmin, zmax;
{
    register pexSetViewRepReq *req;
    register Display *dpy;
    
    dpy = pexi->phigsDisplay;
    
    LockDisplay( dpy );
    
    GetPexFltReq(SetViewRep, req );

    req->wks = pexi->renderer;
    req->viewRep.index = tableIndex;
    
    req->viewRep.view.clipFlags = (((clipXY == PCLIP) ? PEXClipXY : 0) |
				   ((clipBack == PCLIP) ? PEXClipBack : 0) |
				   ((clipFront == PCLIP) ? PEXClipFront : 0));

    req->viewRep.view.clipLimits.minval.x = xmin;
    req->viewRep.view.clipLimits.minval.y = ymin;
    req->viewRep.view.clipLimits.minval.z = zmin;
    req->viewRep.view.clipLimits.maxval.x = xmax;
    req->viewRep.view.clipLimits.maxval.y = ymax;
    req->viewRep.view.clipLimits.maxval.z = zmax;

    bcopy( orientation, req->viewRep.view.orientation, sizeof(pexMatrix) );
    bcopy( mapping, req->viewRep.view.mapping, sizeof(pexMatrix) );
    
    UnlockDisplay( dpy );
    
    SyncHandle();
    
}


