/* 
 * PRendOut.c - Render Output Commands 
 * 
 * Copyright 1988
 * Center for Information Technology Integration (CITI)
 * Information Technology Division
 * University of Michigan
 * Ann Arbor, Michigan
 *
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the names of
 * CITI or THE UNIVERSITY OF MICHIGAN not be used in advertising or
 * publicity pertaining to distribution of the software without
 * specific, written prior permission.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS." CITI AND THE UNIVERSITY OF
 * MICHIGAN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 * NO EVENT SHALL CITI OR THE UNIVERSITY OF MICHIGAN BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#include "pexDICE.h"


PexRenderOutputCommands(pexi)
    register pexC *pexi;
{
    register pexRenderOutputCommandsReq *req;
    register Display *dpy;
       
    dpy = pexi->phigsDisplay;
 
    if( pexi->curRenderOut )
    {
	fprintf( stderr, "(renderOut)Already building an element request\n" );
	return;
    }
    
    pexi->buf_current = pexi->buf_begin;
    
    req = (pexRenderOutputCommandsReq *)(pexi->buf_begin);
    
    req->length = (sizeof(pexRenderOutputCommandsReq))>>2;
    req->reqType = pexi->PEXReqCode;
    req->opcode = PEX_RenderOutputCommands;
    req->format.fpFormat = MyFloatType;
    pexi->buf_current += sizeof(pexRenderOutputCommandsReq);
	
    pexi->curRenderOut = req;
    
    req->rdr = pexi->renderer;
    req->numCommands = 0;
    
}





PexEndRendComm(pexi)
    register pexC *pexi;
{
    register pexRenderOutputCommandsReq *req;
    register Display *dpy;
    
    dpy = pexi->phigsDisplay;

    if( (req = pexi->curRenderOut) == 0 )
    {
	fprintf( stderr, "No current Render Output Commands block open\n" );
	return( 1 );
    }

    LockDisplay(dpy);
    PackData(dpy, req, req->length<<2);
    UnlockDisplay(dpy);
    SyncHandle();
    
    pexi->curRenderOut = 0;

}

